/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.vapi.DefaultVapiConnectionControl;
import com.vmware.vise.vim.vapi.EndpointInfo;
import com.vmware.vise.vim.vapi.SessionBasedVapiConnectionAuthenticator;
import com.vmware.vise.vim.vapi.StaticEndpointVapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiSessionProvider;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LsDiscoveryVapiConnectionManager
implements VapiConnectionManager {
    private static final Log _logger = LogFactory.getLog(LsDiscoveryVapiConnectionManager.class);
    private static final String VAPI_HOST_ID = "vapi.hostid";
    private volatile StaticEndpointVapiConnectionManager _wrappedManager;
    private final LookupService _lsService;
    private final EndpointInfo _endpoint;
    private final ExecutorService _asyncCallExecutor;
    private final KeystoreService _ksService;
    private final Class<? extends Service> _sessionManagerType;
    private final String _sessionManagerLoginOperation;
    private final String _sessionManagerLogoutOperation;
    private final VapiSessionProvider _sessionProvider;
    private final ConfigurationService _configService;

    public LsDiscoveryVapiConnectionManager(LookupService lookupService, EndpointInfo endpointInfo, KeystoreService keystoreService, ExecutorService executorService, Class<? extends Service> clazz, String string, String string2, VapiSessionProvider vapiSessionProvider, ConfigurationService configurationService) {
        Validate.notNull((Object)lookupService);
        Validate.notNull((Object)endpointInfo);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)keystoreService);
        Validate.notNull(clazz);
        Validate.notNull((Object)string);
        Validate.notNull((Object)string2);
        Validate.notNull((Object)vapiSessionProvider);
        Validate.notNull((Object)configurationService);
        this._lsService = lookupService;
        this._endpoint = endpointInfo;
        this._asyncCallExecutor = executorService;
        this._ksService = keystoreService;
        this._sessionManagerType = clazz;
        this._sessionManagerLoginOperation = string;
        this._sessionManagerLogoutOperation = string2;
        this._sessionProvider = vapiSessionProvider;
        this._configService = configurationService;
    }

    @Override
    public Service createServiceStub(Class<? extends Service> clazz) {
        return this.connectionManager().createServiceStub(clazz);
    }

    @Override
    public ApiProvider getApiProvider() {
        return this.connectionManager().getApiProvider();
    }

    @Override
    public StubConfiguration getStubConfig() {
        return this.connectionManager().getStubConfig();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        this.connectionManager().sessionStarted(httpSessionEvent, locale);
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        this.connectionManager().sessionEnded(httpSessionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VapiConnectionManager connectionManager() {
        StaticEndpointVapiConnectionManager staticEndpointVapiConnectionManager = this._wrappedManager;
        if (staticEndpointVapiConnectionManager != null) {
            return staticEndpointVapiConnectionManager;
        }
        LsDiscoveryVapiConnectionManager lsDiscoveryVapiConnectionManager = this;
        synchronized (lsDiscoveryVapiConnectionManager) {
            staticEndpointVapiConnectionManager = this._wrappedManager;
            if (staticEndpointVapiConnectionManager != null) {
                return staticEndpointVapiConnectionManager;
            }
            ServiceRegistration.Endpoint endpoint = this.findServiceEndpoint();
            if (endpoint == null) {
                throw new RuntimeException("Unable to find vAPI endpoint service.");
            }
            URI uRI = endpoint.getUrl();
            SessionBasedVapiConnectionAuthenticator sessionBasedVapiConnectionAuthenticator = new SessionBasedVapiConnectionAuthenticator(this._sessionManagerType, this._sessionManagerLoginOperation, this._sessionManagerLogoutOperation, this._sessionProvider, uRI);
            this._wrappedManager = staticEndpointVapiConnectionManager = new StaticEndpointVapiConnectionManager(endpoint.getUrl(), this._ksService, this._asyncCallExecutor, sessionBasedVapiConnectionAuthenticator, new DefaultVapiConnectionControl());
            return staticEndpointVapiConnectionManager;
        }
    }

    private ServiceRegistration.Endpoint findServiceEndpoint() {
        try {
            ServiceRegistration.Info[] infoArray = this.retrieveServices();
            return this.findService(infoArray);
        }
        catch (EntryNotFoundFault entryNotFoundFault) {
            throw new RuntimeException("Error obtaining endpoint corresponding to " + this._endpoint.toString(), entryNotFoundFault);
        }
    }

    private ServiceRegistration.Endpoint findService(ServiceRegistration.Info[] infoArray) {
        if (infoArray == null) {
            return null;
        }
        String string = this._configService.getProperty(VAPI_HOST_ID);
        String string2 = LookupUtil.getLocalHostLduGuid(this._lsService);
        String string3 = !StringUtil.isNullOrEmpty((String)string2) ? string2 : string;
        ServiceRegistration.Endpoint endpoint = null;
        for (ServiceRegistration.Info info : infoArray) {
            String string4 = info.getNodeId();
            ServiceRegistration.Endpoint[] endpointArray = info.getServiceEndpoints();
            if (endpointArray.length > 1) {
                _logger.warn((Object)String.format("Found more than one endpoint of type '%s' on hostId '%s'. Getting the first and ignoring the rest.", this._endpoint.toString(), string4));
            }
            ServiceRegistration.Endpoint endpoint2 = endpointArray[0];
            if (string4 != null && string4.equals(string3)) {
                return endpoint2;
            }
            if (endpoint != null) continue;
            endpoint = endpoint2;
        }
        return endpoint;
    }

    private ServiceRegistration.Info[] retrieveServices() throws EntryNotFoundFault {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(new ServiceRegistration.ServiceType(this._endpoint.getProductId(), this._endpoint.getServiceTypeId()));
        filter.setEndpointType(new ServiceRegistration.EndpointType(this._endpoint.getEndpointProtocolId(), this._endpoint.getEndpointTypeId()));
        return this._lsService.getServiceRegistrationInfos(filter);
    }
}

