/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.cis.authn.SamlTokenSecurityContext;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategy;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SamlVapiConnectionAuthenticator
implements VapiConnectionAuthenticationStrategy {
    private static final Log _logger = LogFactory.getLog(SamlVapiConnectionAuthenticator.class);
    private final SsoService _ssoService;
    private final SsoDomain _ssoDomain;
    private final ConcurrentMap<SamlToken, String> _clientIdByToken;

    public SamlVapiConnectionAuthenticator(SsoService ssoService, SsoDomain ssoDomain) {
        this._ssoService = ssoService;
        this._ssoDomain = ssoDomain;
        this._clientIdByToken = new ConcurrentHashMap<SamlToken, String>();
    }

    @Override
    public void onUserSessionStarted(HttpSessionEvent httpSessionEvent) {
    }

    @Override
    public void onUserSessionEnded(HttpSessionEvent httpSessionEvent, StubFactory stubFactory) {
        if (httpSessionEvent == null || httpSessionEvent.getSession() == null) {
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        this.removeMapEntryByClientId(string);
    }

    @Override
    public ExecutionContext.SecurityContext createSecurityContext(String string, StubFactory stubFactory) {
        Validate.notNull((Object)string);
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)this._ssoDomain, (String)string);
        if (samlToken == null) {
            throw new RuntimeException("Could not create SAML token.");
        }
        PrivateKey privateKey = this._ssoService.getHokPrivateKey();
        if (!this._clientIdByToken.containsKey(samlToken)) {
            this._clientIdByToken.put(samlToken, string);
        }
        return SecurityContextFactory.createSamlSecurityContext((SamlToken)samlToken, (PrivateKey)privateKey);
    }

    @Override
    public void clearState(String string) {
        if (!this.isSupportedClientId(string)) {
            return;
        }
        this.removeMapEntryByClientId(string);
    }

    @Override
    public void clearAllState() {
        this._clientIdByToken.clear();
    }

    @Override
    public String getClientId(ExecutionContext.SecurityContext securityContext) {
        Validate.notNull((Object)securityContext, (String)"Attempting to retrieve clientId of no context");
        SamlToken samlToken = SamlVapiConnectionAuthenticator.getSamlToken(securityContext);
        return (String)this._clientIdByToken.get(samlToken);
    }

    @Override
    public boolean isSupportedClientId(String string) {
        return string != null;
    }

    private void removeMapEntryByClientId(String string) {
        HashSet hashSet = new HashSet();
        for (Map.Entry samlToken : this._clientIdByToken.entrySet()) {
            if (!((String)samlToken.getValue()).equals(string)) continue;
            hashSet.add(samlToken.getKey());
        }
        if (hashSet.size() > 1) {
            _logger.warn((Object)("Multiple SAML tokens stored at session end for clientId " + SessionUtil.getHashedClientId((String)string)));
        }
        for (SamlToken samlToken : hashSet) {
            this._clientIdByToken.remove(samlToken);
        }
    }

    private static SamlToken getSamlToken(ExecutionContext.SecurityContext securityContext) {
        Validate.isTrue((boolean)(securityContext instanceof SamlTokenSecurityContext), (String)"SamlVapiConnectionAuthenticator expects a SAML security context");
        return (SamlToken)securityContext.getProperty("samlToken");
    }
}

