/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vapi.bindings.Service;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.vapi.SessionBasedVapiConnectionAuthenticator;
import com.vmware.vise.vim.vapi.SolutionUserVapiSessionProvider;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategy;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategyFactory;
import com.vmware.vise.vim.vapi.VapiSessionProvider;
import com.vmware.vise.vim.vapi.WebUserVapiSessionProvider;
import java.net.URI;
import org.apache.commons.lang.Validate;

public class SessionVapiConnectionAuthenticatorFactory
implements VapiConnectionAuthenticationStrategyFactory {
    private final SsoService _ssoService;
    private final boolean _isWebUser;
    private final Class<? extends Service> _sessionManagerType;
    private final String _sessionManagerLoginOperation;
    private final String _sessionManagerLogoutOperation;

    public SessionVapiConnectionAuthenticatorFactory(SsoService ssoService, boolean bl, Class<? extends Service> clazz, String string, String string2) {
        Validate.isTrue((!bl || ssoService != null ? 1 : 0) != 0);
        Validate.notNull(clazz);
        Validate.notNull((Object)string);
        Validate.notNull((Object)string2);
        this._ssoService = ssoService;
        this._isWebUser = bl;
        this._sessionManagerType = clazz;
        this._sessionManagerLoginOperation = string;
        this._sessionManagerLogoutOperation = string2;
    }

    @Override
    public VapiConnectionAuthenticationStrategy createAuthenticationStrategy(URI uRI, SsoDomain ssoDomain) {
        Validate.notNull((Object)uRI);
        Validate.notNull((Object)ssoDomain);
        VapiSessionProvider vapiSessionProvider = this._isWebUser ? new WebUserVapiSessionProvider(this._ssoService, ssoDomain) : new SolutionUserVapiSessionProvider(ssoDomain);
        SessionBasedVapiConnectionAuthenticator sessionBasedVapiConnectionAuthenticator = new SessionBasedVapiConnectionAuthenticator(this._sessionManagerType, this._sessionManagerLoginOperation, this._sessionManagerLogoutOperation, vapiSessionProvider, uRI);
        return sessionBasedVapiConnectionAuthenticator;
    }

    @Override
    public VapiConnectionAuthenticationStrategy createAuthenticationStrategy(URI uRI) {
        return this.createAuthenticationStrategy(uRI, SsoDomain.getLocal());
    }
}

