/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.vapi.UnexpectedVapiSessionToken;
import com.vmware.vise.vim.vapi.VapiSessionProvider;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;

public class WebUserVapiSessionProvider
implements VapiSessionProvider {
    private final String _sessionStoreKey;
    private final ConcurrentHashMap<SessionId, String> _sessionToClientIdMap = new ConcurrentHashMap();
    private final SsoService _ssoService;
    private final SsoDomain _ssoDomain;

    public WebUserVapiSessionProvider(SsoService ssoService, SsoDomain ssoDomain) {
        Validate.notNull((Object)ssoService);
        Validate.notNull((Object)ssoDomain);
        this._ssoService = ssoService;
        this._ssoDomain = ssoDomain;
        this._sessionStoreKey = String.format("session_id:%s", UUID.randomUUID().toString());
    }

    @Deprecated
    public WebUserVapiSessionProvider(SsoService ssoService) {
        this(ssoService, SsoDomain.getLocal());
    }

    @Override
    public void clearAllSessions(String string) {
        SessionUtil.removeData((String)this._sessionStoreKey, (String)string);
        this._sessionToClientIdMap.clear();
    }

    @Override
    public void clearSession(String string) {
        char[] cArray = (char[])SessionUtil.removeData((String)this._sessionStoreKey, (String)string);
        if (cArray != null) {
            this._sessionToClientIdMap.remove(SessionId.valueOf(cArray));
        }
    }

    @Override
    public String clientBySessionId(char[] cArray) {
        String string = this._sessionToClientIdMap.get(SessionId.valueOf(cArray));
        if (string == null) {
            throw new UnexpectedVapiSessionToken(cArray);
        }
        return string;
    }

    @Override
    public boolean isValidClientId(String string) {
        return string != null;
    }

    @Override
    public ExecutionContext.SecurityContext createSamlSecurityContext(String string) {
        Validate.notNull((Object)string, (String)"Attempting to create security context for web user with no clientId");
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)this._ssoDomain, (String)string);
        PrivateKey privateKey = this._ssoService.getHokPrivateKey();
        return SecurityContextFactory.createSamlSecurityContext((SamlToken)samlToken, (PrivateKey)privateKey);
    }

    @Override
    public boolean isUserLoggedIn(String string) {
        return SessionUtil.getData((String)this._sessionStoreKey, (String)string) != null;
    }

    @Override
    public boolean logoutRequired() {
        return true;
    }

    @Override
    public char[] sessionId(String string) {
        Validate.notNull((Object)string);
        return (char[])SessionUtil.getData((String)this._sessionStoreKey, (String)string);
    }

    @Override
    public Object sessionMonitor(String string) {
        Validate.notNull((Object)string);
        return SessionUtil.getSessionMonitor((String)string);
    }

    @Override
    public void storeSession(String string, char[] cArray) {
        Validate.notNull((Object)string, (String)"Storing vAPI session in web session requires a valid clientId.");
        Validate.notNull((Object)cArray, (String)"vAPI session cannot be null.");
        SessionUtil.setData((String)this._sessionStoreKey, (Object)cArray, (String)string);
        this._sessionToClientIdMap.put(SessionId.valueOf(cArray), string);
    }

    private static class SessionId {
        private final int _hash;
        private final char[] _rawSessionId;

        public static SessionId valueOf(char[] cArray) {
            Validate.notNull((Object)cArray);
            return new SessionId(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SessionId) {
                return Arrays.equals(this._rawSessionId, ((SessionId)object)._rawSessionId);
            }
            return false;
        }

        public int hashCode() {
            return this._hash;
        }

        private SessionId(char[] cArray) {
            this._rawSessionId = cArray;
            int n = 0;
            for (char c : this._rawSessionId) {
                n = 31 * n + c;
            }
            this._hash = n;
        }
    }
}

