/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.drs;

import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.InitialPlacementAction;
import com.vmware.vim.binding.vim.cluster.MigrationAction;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.storageDrs.HbrDiskMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StorageMigrationAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.drs.model.RecommendationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecommendationsService {
    private static final int MAX_STAR_RATING = 5;

    public List<RecommendationData> getRecommendationListItems(Recommendation[] recommendations) {
        Map<String, Recommendation> recDict = this.buildRecommendationsIndex(recommendations);
        Map<String, Set<String>> nodeParents = this.getRecommendationsDependencies(recommendations);
        List<List<String>> graphGroups = this.buildRecommendationsGroups(recDict, nodeParents);
        return this.makeDataGridData(graphGroups, recDict, nodeParents);
    }

    public ManagedObjectReference[] extractTargetsFromAction(Action action) {
        ArrayList<ManagedObjectReference> targetObjectRefs = new ArrayList<ManagedObjectReference>();
        if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction hbrMigrationAction = (HbrDiskMigrationAction)action;
            targetObjectRefs.add(hbrMigrationAction.source);
            targetObjectRefs.add(hbrMigrationAction.destination);
        } else {
            targetObjectRefs.add(action.target);
            if (action instanceof InitialPlacementAction) {
                InitialPlacementAction initialPlacementAction = (InitialPlacementAction)action;
                targetObjectRefs.add(initialPlacementAction.targetHost);
            } else if (action instanceof MigrationAction) {
                MigrationAction migrationAction = (MigrationAction)action;
                targetObjectRefs.add(migrationAction.drsMigration.source);
                targetObjectRefs.add(migrationAction.drsMigration.destination);
            } else if (action instanceof StorageMigrationAction) {
                StorageMigrationAction storageMigAction = (StorageMigrationAction)action;
                targetObjectRefs.add(storageMigAction.source);
                targetObjectRefs.add(storageMigAction.destination);
            }
        }
        return targetObjectRefs.toArray(new ManagedObjectReference[targetObjectRefs.size()]);
    }

    public Map<String, Recommendation> buildRecommendationsIndex(Recommendation[] recommendations) {
        HashMap<String, Recommendation> recDict = new HashMap<String, Recommendation>();
        if (!ArrayUtil.isNullOrEmpty((Object[])recommendations)) {
            for (Recommendation rec : recommendations) {
                recDict.put(rec.key, rec);
            }
        }
        return recDict;
    }

    public Map<String, Set<String>> getRecommendationsDependencies(Recommendation[] allRecs) {
        HashMap<String, Set<String>> dependencyMap = new HashMap<String, Set<String>>();
        for (Recommendation rec : allRecs) {
            HashSet<String> parentList = new HashSet<String>();
            dependencyMap.put(rec.key, parentList);
            block1: for (Recommendation possibleParent : allRecs) {
                if (possibleParent.key.equals(rec.key) || ArrayUtil.isNullOrEmpty((Object[])possibleParent.prerequisite)) continue;
                for (String childKey : possibleParent.prerequisite) {
                    if (!childKey.equals(rec.key)) continue;
                    parentList.add(possibleParent.key);
                    continue block1;
                }
            }
        }
        return dependencyMap;
    }

    public List<List<String>> buildRecommendationsGroups(Map<String, Recommendation> recDict, Map<String, Set<String>> parentRecs) {
        List<Set<String>> graphs = RecommendationsService.makeGraphs(recDict, parentRecs);
        ArrayList<List<String>> recGroups = new ArrayList<List<String>>();
        for (Set<String> set : graphs) {
            recGroups.add(RecommendationsService.linearizeGraph(set, recDict, parentRecs));
        }
        for (List list : recGroups) {
            Collections.sort(list, new RecommendationsComparator(recDict));
        }
        Collections.sort(recGroups, new GroupComparator(recDict));
        return recGroups;
    }

    public List<RecommendationData> makeDataGridData(List<List<String>> graphGroups, Map<String, Recommendation> recDict, Map<String, Set<String>> nodeParents) {
        ArrayList<RecommendationData> data2 = new ArrayList<RecommendationData>();
        for (List<String> graph : graphGroups) {
            for (String recKey : graph) {
                Recommendation rec = recDict.get(recKey);
                int cnt = 0;
                for (Action action : rec.action) {
                    ManagedObjectReference[] targetObjects = this.extractTargetsFromAction(action);
                    RecommendationData listItem = RecommendationsService.createRecommendationListItemData(rec, action);
                    listItem.isFirst = cnt == 0;
                    listItem.targetObjects = targetObjects;
                    if (listItem.isFirst) {
                        if (rec.getPrerequisite() != null) {
                            HashSet<String> prerequisiteRecommendations = new HashSet<String>();
                            RecommendationsService.addSubGraph(recDict, rec.getPrerequisite(), prerequisiteRecommendations);
                            listItem.prerequisiteRecommendations = prerequisiteRecommendations.toArray(new String[0]);
                        }
                        Set<String> dependantRecommendations = RecommendationsService.getDependantRecommendations(nodeParents, recKey);
                        listItem.dependantRecommendations = dependantRecommendations.toArray(new String[0]);
                    }
                    data2.add(listItem);
                    ++cnt;
                }
            }
        }
        return data2;
    }

    private static Set<String> getDependantRecommendations(Map<String, Set<String>> nodeParents, String recKey) {
        HashSet<String> dependantRecommendations = new HashSet<String>();
        Set<String> recommendationParents = nodeParents.get(recKey);
        if (recommendationParents != null) {
            dependantRecommendations.addAll(recommendationParents);
            for (String parentKey : recommendationParents) {
                dependantRecommendations.addAll(RecommendationsService.getDependantRecommendations(nodeParents, parentKey));
            }
        }
        return dependantRecommendations;
    }

    private static RecommendationData createRecommendationListItemData(Recommendation recommendation, Action action) {
        RecommendationData item = new RecommendationData();
        item.parentRecommendation = recommendation;
        item.action = action;
        int rating = 5 - recommendation.rating + 1;
        item.priorityRating = Integer.toString(rating);
        return item;
    }

    private static List<String> linearizeGraph(Set<String> graph, Map<String, Recommendation> allRecs, Map<String, Set<String>> dependencyMap) {
        HashMap dependencyMapClone = new HashMap();
        for (Map.Entry<String, Set<String>> entry : dependencyMap.entrySet()) {
            dependencyMapClone.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> parentlessRecs = new ArrayList<String>();
        for (String key : graph) {
            if (((Set)dependencyMapClone.get(key)).size() != 0) continue;
            parentlessRecs.add(key);
        }
        while (parentlessRecs.size() > 0) {
            String rec = (String)parentlessRecs.get(0);
            parentlessRecs.remove(0);
            result.add(rec);
            if (ArrayUtil.isNullOrEmpty((Object[])allRecs.get((Object)rec).prerequisite)) continue;
            for (String child : allRecs.get((Object)rec).prerequisite) {
                if (!dependencyMapClone.containsKey(child)) continue;
                Set parentSet = (Set)dependencyMapClone.get(child);
                parentSet.remove(rec);
                if (parentSet.size() != 0) continue;
                parentlessRecs.add(child);
            }
        }
        return result;
    }

    private static List<Set<String>> makeGraphs(Map<String, Recommendation> allRecs, Map<String, Set<String>> dependencyMap) {
        ArrayList<Set<String>> graphList = new ArrayList<Set<String>>();
        for (Map.Entry<String, Set<String>> rec : dependencyMap.entrySet()) {
            Set<String> parentsSet = rec.getValue();
            if (parentsSet.size() != 0) continue;
            Set<String> subGraph = new HashSet<String>();
            subGraph.add(rec.getKey());
            RecommendationsService.addSubGraph(allRecs, allRecs.get((Object)rec.getKey()).prerequisite, subGraph);
            boolean intersectionFound = true;
            while (intersectionFound) {
                intersectionFound = false;
                block2: for (int curGraph = 0; !intersectionFound && curGraph < graphList.size(); ++curGraph) {
                    Set graph = (Set)graphList.get(curGraph);
                    for (String key : subGraph) {
                        if (!graph.contains(key)) continue;
                        graph.addAll(subGraph);
                        graphList.remove(curGraph);
                        subGraph = graph;
                        intersectionFound = true;
                        continue block2;
                    }
                }
            }
            graphList.add(subGraph);
        }
        return graphList;
    }

    private static void addSubGraph(Map<String, Recommendation> allRecs, String[] children, Set<String> subGraph) {
        if (!ArrayUtil.isNullOrEmpty((Object[])children)) {
            for (String recKey : children) {
                if (!allRecs.containsKey(recKey)) continue;
                subGraph.add(recKey);
                RecommendationsService.addSubGraph(allRecs, allRecs.get((Object)recKey).prerequisite, subGraph);
            }
        }
    }

    private static class GroupComparator
    implements Comparator<List<String>> {
        private final Map<String, Recommendation> recDict;

        public GroupComparator(Map<String, Recommendation> recDict) {
            this.recDict = recDict;
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            Recommendation rec1 = this.recDict.get(o1.get(0));
            Recommendation rec2 = this.recDict.get(o2.get(0));
            return rec2.getRating() - rec1.getRating();
        }
    }

    private static class RecommendationsComparator
    implements Comparator<String> {
        private final Map<String, Recommendation> recDict;

        public RecommendationsComparator(Map<String, Recommendation> recDict) {
            this.recDict = recDict;
        }

        @Override
        public int compare(String o1, String o2) {
            Recommendation rec1 = this.recDict.get(o1);
            Recommendation rec2 = this.recDict.get(o2);
            return rec2.getRating() - rec1.getRating();
        }
    }
}

