/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DatastoreListDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String DATASTORE_DEVICE = "device";
    private static final String DATASTORE_STORAGE_IO_CONTROL = "storageIoControl";
    private static final String DATASTORE_CONGESTION_THRESHOLD_MODE = "congestionThresholdMode";
    private static final String DATASTORE_CONGESTION_THRESHOLD = "congestionThreshold";
    private static final String DATASTORE_PROVISIONED_SPACE = "provisionedSpace";
    private static final String DATASTORE_PROVISIONED_SPACE_FORMATTED = "provisionedSpaceFormatted";
    private static final String ACCESS_FORMATTED = "accessFormatted";
    private static final String DATASTORE_UNMOUNTED_FROM_ALL_HOSTS = "unmountedFromAllHosts";
    private static final String INFO = "info";
    private static final String SUMMARY = "summary";
    private static final String STORAGE_IORM_SUPPORTED = "capability.storageIORMSupported";
    private static final String IORM_CONFIG = "iormConfiguration";
    private static final String ACCESSIBLE_HOSTS_COUNT = "host._length";
    private static final String HOST_MOUNT = "hostMount";

    public DatastoreListDerivedPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Datastore.class.getSimpleName();
        ti.properties = new String[]{DATASTORE_DEVICE, DATASTORE_STORAGE_IO_CONTROL, DATASTORE_CONGESTION_THRESHOLD_MODE, DATASTORE_CONGESTION_THRESHOLD, DATASTORE_PROVISIONED_SPACE, DATASTORE_PROVISIONED_SPACE_FORMATTED, ACCESS_FORMATTED, DATASTORE_UNMOUNTED_FROM_ALL_HOSTS};
        ti.derivedProperties = new DerivedPropertyInfo[]{DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_DEVICE, new String[]{INFO}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_STORAGE_IO_CONTROL, new String[]{STORAGE_IORM_SUPPORTED, IORM_CONFIG}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_CONGESTION_THRESHOLD_MODE, new String[]{STORAGE_IORM_SUPPORTED, IORM_CONFIG}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_CONGESTION_THRESHOLD, new String[]{STORAGE_IORM_SUPPORTED, IORM_CONFIG}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_PROVISIONED_SPACE, new String[]{SUMMARY}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_PROVISIONED_SPACE_FORMATTED, new String[]{SUMMARY}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(ACCESS_FORMATTED, new String[]{ACCESSIBLE_HOSTS_COUNT}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_UNMOUNTED_FROM_ALL_HOSTS, new String[]{HOST_MOUNT})};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = obj;
            resultItem.properties = this.computePropertyValues(reqPropSet, sourcePropertyValuesMap, obj);
            resultItems.add(resultItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] computePropertyValues(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (reqProps.contains(DATASTORE_DEVICE)) {
            this.processDevice(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(DATASTORE_STORAGE_IO_CONTROL)) {
            this.processStorageIoSupported(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD_MODE)) {
            this.processCongestionThresholdMode(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD)) {
            this.processCongestionThreshold(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE)) {
            this.processProvisionedSpace(propertyValuesMap, result, resourceObject, false);
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE_FORMATTED)) {
            this.processProvisionedSpace(propertyValuesMap, result, resourceObject, true);
        }
        if (reqProps.contains(ACCESS_FORMATTED)) {
            this.processAccessFormatted(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(DATASTORE_UNMOUNTED_FROM_ALL_HOSTS)) {
            this.processUnmountedFromAllHosts(propertyValuesMap, result, resourceObject);
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    private void processDevice(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Object datastoreInfo = propertyValuesMap.get(INFO);
        String deviceName = StorageUtil.getLocalizedString("deviceName.na");
        if (datastoreInfo instanceof NasDatastoreInfo) {
            NasDatastoreInfo nasInfo = (NasDatastoreInfo)datastoreInfo;
            if (nasInfo.nas != null) {
                deviceName = nasInfo.nas.remoteHost + ":" + nasInfo.nas.remotePath;
            }
        } else if (datastoreInfo instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)datastoreInfo;
            deviceName = StorageUtil.getVmfsDeviceName(vmfsInfo.vmfs);
        } else if (datastoreInfo instanceof VvolDatastoreInfo) {
            VvolDatastoreInfo vvolInfo = (VvolDatastoreInfo)datastoreInfo;
            deviceName = StorageUtil.getVvolDeviceName(vvolInfo.vvolDS);
        }
        propValues.add(this.createPropValue(DATASTORE_DEVICE, deviceName, resourceObject));
    }

    private void processStorageIoSupported(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Boolean ioSupported = (Boolean)propertyValuesMap.get(STORAGE_IORM_SUPPORTED);
        if (!ioSupported.booleanValue()) {
            String notSupported = StorageUtil.getLocalizedString("storageIOControl.notSupported");
            propValues.add(this.createPropValue(DATASTORE_STORAGE_IO_CONTROL, notSupported, resourceObject));
            return;
        }
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)propertyValuesMap.get(IORM_CONFIG);
        if (config != null) {
            ioSupported = config.enabled;
        }
        String enabledOrDisabled = ioSupported != false ? StorageUtil.getLocalizedString("storageIOControl.enabled") : StorageUtil.getLocalizedString("storageIOControl.disabled");
        propValues.add(this.createPropValue(DATASTORE_STORAGE_IO_CONTROL, enabledOrDisabled, resourceObject));
    }

    private void processCongestionThresholdMode(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Boolean siocSupported = (Boolean)propertyValuesMap.get(STORAGE_IORM_SUPPORTED);
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)propertyValuesMap.get(IORM_CONFIG);
        if (!siocSupported.booleanValue() || config != null && !config.enabled) {
            String na = StorageUtil.getLocalizedString("congestionThresholdMode.na");
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, na, resourceObject));
            return;
        }
        if (StorageResourceManager.CongestionThresholdMode.automatic.name().equals(config.congestionThresholdMode)) {
            String percentOfPeakThroughput = config.percentOfPeakThroughput.toString();
            String automatic = StorageUtil.getLocalizedString("congestionThresholdMode.automatic", new String[]{percentOfPeakThroughput});
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, automatic, resourceObject));
            return;
        }
        String manual = StorageUtil.getLocalizedString("congestionThresholdMode.manual");
        propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, manual, resourceObject));
    }

    private void processCongestionThreshold(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Boolean siocSupported = (Boolean)propertyValuesMap.get(STORAGE_IORM_SUPPORTED);
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)propertyValuesMap.get(IORM_CONFIG);
        if (!siocSupported.booleanValue() || config != null && !config.enabled) {
            String na = StorageUtil.getLocalizedString("congestionThreshold.na");
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD, na, resourceObject));
            return;
        }
        String threshold = config.congestionThreshold + "";
        String format = StorageUtil.getLocalizedString("congestionThreshold.format", new String[]{threshold});
        propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD, format, resourceObject));
    }

    private void processProvisionedSpace(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject, boolean formatted) {
        Datastore.Summary summary = (Datastore.Summary)propertyValuesMap.get(SUMMARY);
        long provisionedSpace = summary.capacity - summary.freeSpace;
        if (summary.accessible && summary.uncommitted != null) {
            provisionedSpace += summary.uncommitted.longValue();
        }
        if (formatted) {
            String provisionedSpaceFormatted = FormatUtil.getStorageFormatted((Long)provisionedSpace, (long)1L, (long)-1L);
            propValues.add(this.createPropValue(DATASTORE_PROVISIONED_SPACE_FORMATTED, provisionedSpaceFormatted, resourceObject));
        } else {
            propValues.add(this.createPropValue(DATASTORE_PROVISIONED_SPACE, provisionedSpace, resourceObject));
        }
    }

    private void processAccessFormatted(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        int accessableHostsCount = (Integer)propertyValuesMap.get(ACCESSIBLE_HOSTS_COUNT);
        String accessFormatted = accessableHostsCount > 1 ? StorageUtil.getLocalizedString("datastore.access.multiple") : StorageUtil.getLocalizedString("datastore.access.single");
        propValues.add(this.createPropValue(ACCESS_FORMATTED, accessFormatted, resourceObject));
    }

    private void processUnmountedFromAllHosts(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Boolean result = false;
        Object[] hostMountArray = (Datastore.HostMount[])propertyValuesMap.get(HOST_MOUNT);
        if (!ArrayUtil.isNullOrEmpty((Object[])hostMountArray)) {
            result = true;
            for (Object hostMount : hostMountArray) {
                if (((Datastore.HostMount)hostMount).mountInfo.mounted != null && !((Datastore.HostMount)hostMount).mountInfo.mounted.booleanValue()) continue;
                result = false;
                break;
            }
        }
        propValues.add(this.createPropValue(DATASTORE_UNMOUNTED_FROM_ALL_HOSTS, result, resourceObject));
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String propertyName, String[] sourcePropertyNames) {
        DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
        derivedPropertyInfo.propertyName = propertyName;
        derivedPropertyInfo.sourcePropertyNames = sourcePropertyNames;
        return derivedPropertyInfo;
    }
}

