/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.cis.services.common.sso.SamlSessionAuthData;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.exception.InvalidSignatureException;
import com.vmware.vim.vmomi.server.exception.SignatureValidationException;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginHelper {
    private static final Log _log = LogFactory.getLog(LoginHelper.class);

    public static void loginByToken(Activation activation, List<X509Certificate> stsCertificates, String[] audience) throws AlreadyAuthenticated, TokenNotFound, UnmatchedAudienceRestrictions, InvalidSignatureException, SignatureValidationException {
        Session session;
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"loginByToken: Entering");
        }
        if ((session = activation.getSession()).getAuthData() != null) {
            _log.info((Object)String.format("loginByToken: User '%s' is already authenticated", session.getAuthData().getUser()));
            throw new AlreadyAuthenticated();
        }
        if (stsCertificates == null || stsCertificates.size() == 0) {
            throw new SignatureValidationException("STS signing certificates are missing or empty");
        }
        SamlToken token = activation.findSamlToken(stsCertificates);
        if (token == null) {
            _log.info((Object)"loginByToken: No SSO token found in request");
            throw new TokenNotFound();
        }
        Set restrictions = token.getAudience();
        if (restrictions.size() > 0) {
            if (audience == null) {
                _log.info((Object)"loginByToken: Failed to match audience restrictions");
                throw new UnmatchedAudienceRestrictions(restrictions);
            }
            boolean matched = false;
            for (String a : audience) {
                if (!restrictions.contains(a)) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)String.format("loginByToken: Matched '%s' audience restriction", a));
                }
                matched = true;
                break;
            }
            if (!matched) {
                _log.info((Object)"loginByToken: Failed to match audience restrictions");
                throw new UnmatchedAudienceRestrictions(restrictions);
            }
        }
        SamlSessionAuthData authData = new SamlSessionAuthData(token);
        _log.info((Object)String.format("loginByToken: Successfully authenticated '%s' on session %s", authData.getUser(), session.getSessionNonce()));
        session.setAuthData((SessionAuthData)authData);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"loginByToken: Leaving");
        }
    }

    public static void loginByToken(Activation activation, String[] audience) throws AlreadyAuthenticated, TokenNotFound, UnmatchedAudienceRestrictions, InvalidSignatureException, SignatureValidationException {
        LoginHelper.loginByToken(activation, activation.getSTSCertificates(), audience);
    }

    public static void logout(Activation activation) {
        Session session;
        SamlSessionAuthData authData;
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"logout: Entering");
        }
        if ((authData = (SamlSessionAuthData)(session = activation.getSession()).getAuthData()) != null) {
            _log.info((Object)String.format("logout: Closing session '%s' for '%s'", session.getSessionNonce(), authData.getUser()));
        } else {
            _log.info((Object)String.format("logout: Closing unauthenticated session '%s'", session.getSessionNonce()));
        }
        session.closeSession();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"logout: Leaving");
        }
    }

    public static class UnmatchedAudienceRestrictions
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String[] _restrictions;

        private UnmatchedAudienceRestrictions(Set<String> restrictions) {
            this._restrictions = restrictions.toArray(new String[restrictions.size()]);
        }

        String[] getRestrictions() {
            return this._restrictions;
        }
    }

    public static class AlreadyAuthenticated
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AlreadyAuthenticated() {
        }
    }

    public static class TokenNotFound
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TokenNotFound() {
        }
    }
}

