/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import java.util.Date;
import java.util.List;

public class SamlSessionAuthData
implements SessionAuthData {
    private PrincipalId[] _tokenGroupList;
    private boolean _isSolution;
    private PrincipalId _principal;
    private Date _tokenExpirationTime;

    public SamlSessionAuthData(SamlToken token) {
        this._tokenGroupList = new PrincipalId[token.getGroupList().size()];
        List groupList = token.getGroupList();
        for (int i = 0; i < groupList.size(); ++i) {
            PrincipalId pid = (PrincipalId)groupList.get(i);
            this._tokenGroupList[i] = new PrincipalId(new String(pid.getName()), new String(pid.getDomain()));
        }
        this._isSolution = token.isSolution();
        this._principal = new PrincipalId(new String(token.getSubject().getName()), new String(token.getSubject().getDomain()));
        this._tokenExpirationTime = token.getExpirationTime();
    }

    public PrincipalId getPrincipal() {
        return this._principal;
    }

    public PrincipalId[] getGroups() {
        return this._tokenGroupList;
    }

    public boolean isSolution() {
        return this._isSolution;
    }

    public Date getTokenExpirationTime() {
        return this._tokenExpirationTime;
    }

    public String getUser() {
        return String.format("%s@%s", this._principal.getName(), this._principal.getDomain());
    }

    public void sessionClosed() {
    }
}

