/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.cis.services.common.sso.SsoOverRestVerifierUtil;
import com.vmware.cis.services.common.sso.StsCertManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoAuthenticatedFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(SsoAuthenticatedFileServlet.class);
    private boolean _ssoEnabled = false;
    private final StsCertManager _stsCertManager;
    private final File _file;
    private final String _contentType;
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int CLOCK_TOLERANCE_SEC = 300;
    private static final int MAX_REQUEST_AGE_SEC = 3600;

    public SsoAuthenticatedFileServlet(String filePath, String contentType, boolean ssoEnabled, StsCertManager stsCertManager) {
        this._file = new File(filePath);
        this._contentType = contentType == null ? DEFAULT_CONTENT_TYPE : contentType;
        this._ssoEnabled = ssoEnabled;
        this._stsCertManager = stsCertManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("doGet: Entering (%s)", httpServletRequest.getRequestURI()));
            }
            if (this._ssoEnabled) {
                try {
                    byte[] payload = IOUtils.toByteArray((InputStream)httpServletRequest.getInputStream());
                    SsoOverRestVerifierUtil.verifySecurityHeader(httpServletRequest, payload, this._stsCertManager, 300, 3600);
                }
                catch (SsoOverRestVerifierUtil.SsoAuthException e) {
                    _log.error((Object)("doGet: SSO verification failed for client " + this.getRemoteClientInfo(httpServletRequest)), (Throwable)e);
                    httpServletResponse.setStatus(401);
                    return;
                }
            }
            httpServletResponse.setContentType(this._contentType);
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + this._file.getName() + "\"");
            httpServletResponse.setHeader("Content-Length", String.valueOf(this._file.length()));
            ServletOutputStream sOut = httpServletResponse.getOutputStream();
            FileInputStream in = null;
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            try {
                in = new FileInputStream(this._file);
                bis = new BufferedInputStream(in);
                bos = new BufferedOutputStream((OutputStream)sOut);
                byte[] buff = new byte[16384];
                int bytesRead = 0;
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((OutputStream)bos);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("doGet: Leaving (%s)", httpServletRequest.getRequestURI()));
            }
        }
        catch (Exception e) {
            _log.error((Object)"doGet: Failed to stream data", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private String getRemoteClientInfo(HttpServletRequest request) {
        String info = request.getHeader("X-Forwarded-For");
        if (info == null) {
            info = request.getRemoteAddr();
        }
        return info;
    }
}

