/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.cis.common.sso.AdminHelper;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.vim.sso.admin.client.AdminClient;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StsCertManagerImpl
implements StsCertManager {
    private static final Log _log = LogFactory.getLog(StsCertManager.class);
    private List<X509Certificate> _stsCertificates = new ArrayList<X509Certificate>();
    private AtomicInteger _count = new AtomicInteger(0);
    private AdminHelper _adminHelper = null;
    private AdminClient _adminClient = null;
    private boolean _refetchDisabled;

    @Deprecated
    public StsCertManagerImpl(AdminHelper adminHelper) {
        if (adminHelper == null) {
            throw new IllegalArgumentException();
        }
        this._adminHelper = adminHelper;
        this.refetchStsCertificates();
    }

    public StsCertManagerImpl(AdminClient adminClient) {
        if (adminClient == null) {
            throw new IllegalArgumentException();
        }
        this._adminClient = adminClient;
        this.refetchStsCertificates();
    }

    @Override
    public List<X509Certificate> getStsCertificates() {
        return new ArrayList<X509Certificate>(this._stsCertificates);
    }

    @Override
    public void refetchStsCertificates(StsCertManager.CompletionCallback callback) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"refetchStsCertificates(async): Entering");
        }
        String threadName = "CertFetcher-" + Integer.toString(this._count.getAndIncrement());
        new Thread((Runnable)new CertFetcher(callback), threadName).start();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("refetchStsCertificates(async): Leaving (threadName %s)", threadName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<X509Certificate> refetchStsCertificates() {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"refetchStsCertificates(sync): Entering");
        }
        try {
            SimpleCompletionCallback callback = new SimpleCompletionCallback();
            this.refetchStsCertificates(callback);
            callback.waitForCompletion();
            List<X509Certificate> list = callback._certificates;
            return list;
        }
        finally {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"refetchStsCertificates(sync): Leaving");
            }
        }
    }

    public void setStsCertificates(List<X509Certificate> testCertificates, boolean disableRefetch) {
        _log.warn((Object)String.format("setStsCertificates: Injecting %d test STS certificates, disableRefetch=%b", testCertificates.size(), disableRefetch));
        this._stsCertificates = new ArrayList<X509Certificate>(testCertificates);
        for (X509Certificate cert : this._stsCertificates) {
            _log.warn((Object)cert);
        }
        this._refetchDisabled = disableRefetch;
    }

    private class CertFetcher
    implements Runnable {
        private StsCertManager.CompletionCallback _callback;

        CertFetcher(StsCertManager.CompletionCallback callback) {
            this._callback = callback;
        }

        @Override
        public void run() {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"run: Fetching STS signing certificates");
                }
                if (!StsCertManagerImpl.this._refetchDisabled) {
                    ArrayList certs = null;
                    certs = null != StsCertManagerImpl.this._adminHelper ? StsCertManagerImpl.this._adminHelper.fetchTrustedCertificates() : new ArrayList(StsCertManagerImpl.this._adminClient.getServerConfigurator().getTrustedCertificates());
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)String.format("run: Obtained %d certificates", certs.size()));
                        for (X509Certificate cert : certs) {
                            _log.debug((Object)cert.toString());
                        }
                    }
                    StsCertManagerImpl.this._stsCertificates = certs;
                } else {
                    _log.warn((Object)"run: STS signing certificate refetch is DISABLED");
                }
            }
            catch (Throwable t) {
                _log.warn((Object)"run: Failed to obtain STS signing certificates", t);
            }
            try {
                this._callback.onCompletion(new ArrayList<X509Certificate>(StsCertManagerImpl.this._stsCertificates));
            }
            catch (Throwable t) {
                _log.warn((Object)"run: onCompletion callback failed", t);
            }
        }
    }

    private static class SimpleCompletionCallback
    implements StsCertManager.CompletionCallback {
        public List<X509Certificate> _certificates;

        private SimpleCompletionCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(List<X509Certificate> certificates) {
            SimpleCompletionCallback simpleCompletionCallback = this;
            synchronized (simpleCompletionCallback) {
                this._certificates = certificates;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForCompletion() {
            SimpleCompletionCallback simpleCompletionCallback = this;
            synchronized (simpleCompletionCallback) {
                while (this._certificates == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

