/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.util;

import java.util.concurrent.atomic.AtomicLong;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringApplicationContext
implements ApplicationContextAware {
    private static SpringApplicationContext _instance = new SpringApplicationContext();
    private ApplicationContext _appContext;
    private AbstractAutoProxyCreator _proxyCreator;
    private AtomicLong _proxyCounter;

    private SpringApplicationContext() {
    }

    public static SpringApplicationContext getInstance() {
        return _instance;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this._appContext = context;
        this._proxyCreator = null;
        this._proxyCounter = new AtomicLong();
    }

    public ApplicationContext getApplicationContext() {
        return this._appContext;
    }

    public <T> T maybeCreateProxy(T o) {
        if (this._appContext == null) {
            return o;
        }
        if (this._proxyCreator == null) {
            Object[] proxyCreators = this._appContext.getBeansOfType(AbstractAutoProxyCreator.class).values().toArray();
            if (proxyCreators == null || proxyCreators.length == 0) {
                throw new AssertionError((Object)"Spring application context must have auto-proxy creator bean");
            }
            this._proxyCreator = (AbstractAutoProxyCreator)proxyCreators[0];
        }
        String name = "_internal_name#" + this._proxyCounter.getAndIncrement();
        return (T)this._proxyCreator.postProcessAfterInitialization(o, name);
    }
}

