/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.BinaryType;
import com.vmware.vapi.bindings.type.BooleanType;
import com.vmware.vapi.bindings.type.DateTimeType;
import com.vmware.vapi.bindings.type.DoubleType;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.IntegerType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.OpaqueType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SecretType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.bindings.type.TypeVisitor;
import com.vmware.vapi.bindings.type.UriType;
import com.vmware.vapi.bindings.type.VoidType;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.internal.is.ModelMetadataImpl;
import com.vmware.vapi.is.ModelMetadata;
import com.vmware.vapi.is.Util;
import com.vmware.vapi.is.exception.SerializationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMetadataBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ModelMetadataBuilder.class);

    public static ModelMetadata build(StaticStructure structure) {
        MetadataBuilder builder = new MetadataBuilder(structure);
        structure._getType().accept((TypeVisitor)builder);
        return builder.getMetadata();
    }

    private static class MetadataBuilder
    implements TypeVisitor {
        private Object currentValue;
        private ModelMetadataImpl metadata = new ModelMetadataImpl();
        private ModelMetadata.FieldInfo currentFieldInfo;
        private String currentStructureName;
        private String currentFieldName;
        private boolean isInMap = false;
        private String mapPath;

        public MetadataBuilder(StaticStructure value) {
            this.currentValue = value;
        }

        public ModelMetadata getMetadata() {
            return this.metadata;
        }

        public void visit(VoidType type) {
        }

        public void visit(IntegerType type) {
        }

        public void visit(DoubleType type) {
        }

        public void visit(StringType type) {
        }

        public void visit(BooleanType type) {
        }

        public void visit(BinaryType type) {
        }

        public void visit(DateTimeType type) {
        }

        public void visit(UriType type) {
        }

        public void visit(OptionalType type) {
            type.getElementType().accept((TypeVisitor)this);
        }

        public void visit(ListType type) {
            Object oldValue = this.currentValue;
            if (this.currentValue != null && !((List)this.currentValue).isEmpty()) {
                this.visit((List)this.currentValue, type.getElementType());
            }
            this.currentValue = oldValue;
        }

        public void visit(StructType type) {
            this.isInMap = false;
            if (this.currentValue == null) {
                return;
            }
            Object oldValue = this.currentValue;
            String oldStructureName = this.currentStructureName;
            String oldFieldName = this.currentFieldName;
            ModelMetadataImpl.StructureInfoImpl structureInfo = this.metadata.getStructureInfo(type.getName());
            if (structureInfo == null) {
                structureInfo = new ModelMetadataImpl.StructureInfoImpl(type.getModelKeyFields() != null ? (String)type.getModelKeyFields().get(0) : null, Util.computeModelName(type.getBindingClass()));
            }
            for (String fieldName : type.getFieldNames()) {
                block9: {
                    try {
                        this.currentValue = BindingsUtil.getStructureFieldValue((StaticStructure)((StaticStructure)oldValue), (StructType)type, (String)fieldName);
                    }
                    catch (RuntimeException ex) {
                        if (!logger.isWarnEnabled()) break block9;
                        logger.warn(String.format("Can't extract field '%s' value for structure '%s'. Dynamic fields might not be serialized properly", fieldName, type.getName()), (Throwable)ex);
                    }
                }
                if (this.currentValue == null) continue;
                Type fieldType = type.getField(fieldName);
                try {
                    this.currentStructureName = type.getName();
                    this.currentFieldName = fieldName;
                    fieldType.accept((TypeVisitor)this);
                }
                catch (SerializationException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    throw new SerializationException(String.format("Could not serialize field '%s' of structure '%s'", fieldName, type.getName()), ex);
                }
                if (this.currentFieldInfo == null) continue;
                structureInfo.getFieldInfo().put(fieldName, this.currentFieldInfo);
                this.currentFieldInfo = null;
            }
            this.currentValue = oldValue;
            this.currentFieldName = oldFieldName;
            this.currentStructureName = oldStructureName;
            if (!structureInfo.getFieldInfo().isEmpty()) {
                this.metadata.setStructureInfo(type.getName(), structureInfo);
            }
        }

        public void visit(OpaqueType type) {
            throw new SerializationException("Cannot serialize opaque fields. Their bindings do nothave information about resources and resource identifiers.");
        }

        public void visit(SecretType type) {
        }

        public void visit(TypeReference<? extends Type> type) {
            type.resolve().accept((TypeVisitor)this);
        }

        public void visit(EnumType type) {
        }

        public void visit(ErrorType type) {
            this.visit((StructType)type);
        }

        public void visit(IdType idType) {
            if (idType.getResourceType() != null || idType.getResourceTypeFieldName() != null) {
                this.currentFieldInfo = new ModelMetadataImpl.FieldInfoImpl(idType.getResourceType(), idType.getResourceTypeFieldName());
            }
        }

        public void visit(SetType setType) {
            Object oldValue = this.currentValue;
            this.currentValue = null;
            setType.getElementType().accept((TypeVisitor)this);
            this.currentValue = oldValue;
        }

        public void visit(MapType mapType) {
            Object oldValue = this.currentValue;
            String oldMapPath = this.mapPath;
            String currentMapPath = null;
            boolean oldIsInMap = this.isInMap;
            HashMap<String, ModelMetadata.FieldInfo> fieldInfos = new HashMap<String, ModelMetadata.FieldInfo>();
            if (mapType.getKeyType() instanceof IdType) {
                mapType.getKeyType().accept((TypeVisitor)this);
                if (this.currentFieldInfo != null) {
                    fieldInfos.put("key", this.currentFieldInfo);
                }
            }
            if (mapType.getValueType() instanceof IdType) {
                mapType.getValueType().accept((TypeVisitor)this);
                if (this.currentFieldInfo != null) {
                    fieldInfos.put("value", this.currentFieldInfo);
                    this.currentFieldInfo = null;
                }
            }
            currentMapPath = String.format("%s-%s", this.isInMap ? this.mapPath : this.currentStructureName, this.isInMap ? "value" : this.currentFieldName);
            if (!fieldInfos.isEmpty()) {
                ModelMetadataImpl.StructureInfoImpl info = new ModelMetadataImpl.StructureInfoImpl(null, null);
                info.getFieldInfo().putAll(fieldInfos);
                this.metadata.setStructureInfo(currentMapPath, info);
            }
            if (this.currentValue != null && !((Map)this.currentValue).isEmpty()) {
                this.isInMap = true;
                this.mapPath = currentMapPath;
                this.visit(((Map)this.currentValue).values(), mapType.getValueType());
            }
            this.currentValue = oldValue;
            this.isInMap = oldIsInMap;
            this.mapPath = oldMapPath;
        }

        public void visit(DynamicStructType type) {
            this.isInMap = false;
            if (this.currentValue == null) {
                return;
            }
            if (!(this.currentValue instanceof StaticStructure)) {
                throw new SerializationException("Cannot serialize dynamic structure field. It is either used in unsupported location (List<Structure>, Map<String, Structure>) or the actual value is not a static structure (in which case there isn't information about resources types and identifiers.");
            }
            StructType runtimeType = ((StaticStructure)this.currentValue)._getType();
            runtimeType.accept((TypeVisitor)this);
        }

        public void visit(AnyErrorType type) {
            this.isInMap = false;
            this.visit(new DynamicStructType());
        }

        private void visit(Collection<?> items, Type type) {
            Object oldValue = this.currentValue;
            for (Object item : items) {
                this.currentValue = item;
                type.accept((TypeVisitor)this);
            }
            this.currentValue = oldValue;
        }
    }
}

