/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.is.Constants;
import com.vmware.vapi.is.XmlInputSource;
import com.vmware.vapi.is.exception.DeserializationException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueDeserializer
implements com.vmware.vapi.is.ValueDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(ValueDeserializer.class);

    @Override
    public DataValue deserialize(XmlInputSource inputSource) {
        DataValue result;
        block11: {
            if (inputSource.getEventType() != 1) {
                inputSource.nextTag();
            }
            String currentElementLocalName = inputSource.getName().getLocalPart();
            result = this.parseElement(inputSource, null, false);
            ListValue list = null;
            if (result instanceof ListValue) {
                list = (ListValue)result;
            } else if (result instanceof OptionalValue && ((OptionalValue)result).getValue() instanceof ListValue) {
                list = (ListValue)((OptionalValue)result).getValue();
            }
            if (list != null) {
                while (true) {
                    int next;
                    try {
                        next = inputSource.nextTag();
                    }
                    catch (RuntimeException e) {
                        logger.debug("Unexpected XML document content while reading list elements", (Throwable)e);
                        break block11;
                    }
                    if (next == 1 && currentElementLocalName.equals(inputSource.getName().getLocalPart())) {
                        this.parseElement(inputSource, (DataValue)list, false);
                        continue;
                    }
                    break block11;
                    break;
                }
            }
            try {
                inputSource.nextTag();
            }
            catch (RuntimeException e) {
                logger.debug("Unexpected XML document content while trying to set the stream position", (Throwable)e);
            }
        }
        return result;
    }

    private DataValue parseElement(XmlInputSource inputSource, DataValue current, boolean nested) {
        Map<QName, String> attributes = this.getCurrentElementAttributes(inputSource);
        boolean isOptional = Boolean.valueOf(attributes.get(nested ? Constants.VAPI_ELEMENT_OPTIONAL : Constants.VAPI_OPTIONAL));
        if (!attributes.containsKey(Constants.VAPI_TYPE)) {
            inputSource.next();
            if (inputSource.getEventType() == 2 && isOptional) {
                return OptionalValue.UNSET;
            }
            throw new DeserializationException("XML element has no vapi:type attribute, but is not optional and empty");
        }
        Constants.Type elementType = this.resolveElementType(nested, attributes);
        switch (elementType) {
            case STRING: {
                String value = this.getTextValue(inputSource);
                return this.wrapIfOptional((DataValue)new StringValue(value), isOptional);
            }
            case SECRET: {
                String value = this.getTextValue(inputSource);
                return this.wrapIfOptional((DataValue)new SecretValue(value.toCharArray()), isOptional);
            }
            case INTEGER: {
                String value = this.getTextValue(inputSource);
                return this.wrapIfOptional((DataValue)new IntegerValue(Long.parseLong(value)), isOptional);
            }
            case DOUBLE: {
                String value = this.getTextValue(inputSource);
                return this.wrapIfOptional((DataValue)new DoubleValue(Double.parseDouble(value)), isOptional);
            }
            case BOOLEAN: {
                String value = this.getTextValue(inputSource);
                return this.wrapIfOptional((DataValue)(Boolean.valueOf(value) != false ? BooleanValue.TRUE : BooleanValue.FALSE), isOptional);
            }
            case VOID: {
                inputSource.nextTag();
                return this.wrapIfOptional((DataValue)VoidValue.getInstance(), isOptional);
            }
            case BLOB: {
                String value = this.getTextValue(inputSource);
                return this.wrapIfOptional((DataValue)new BlobValue(Base64.decodeBase64((String)value)), isOptional);
            }
            case LIST: {
                ListValue listValue = this.parseList(inputSource, current, nested, attributes);
                return this.wrapIfOptional((DataValue)listValue, isOptional);
            }
            case STRUCT: 
            case ERROR: {
                StructValue structValue = this.parseStructure(inputSource, attributes, elementType);
                return this.wrapIfOptional((DataValue)structValue, isOptional);
            }
        }
        throw new DeserializationException("Unsupported element found:" + (Object)((Object)elementType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ListValue parseList(XmlInputSource inputSource, DataValue current, boolean nested, Map<QName, String> attributes) {
        ListValue listValue = null;
        if (current != null) {
            if (current instanceof ListValue) {
                listValue = (ListValue)current;
            } else {
                if (!(current instanceof OptionalValue) || !(((OptionalValue)current).getValue() instanceof ListValue)) throw new DeserializationException("Unexpected current DataValue (not a list)");
                listValue = (ListValue)((OptionalValue)current).getValue();
            }
        } else {
            listValue = new ListValue();
        }
        if (Boolean.valueOf(attributes.get(Constants.VAPI_EMPTY)).booleanValue()) {
            inputSource.nextTag();
            return listValue;
        } else if (nested) {
            while (inputSource.nextTag() != 2) {
                this.parseElement(inputSource, (DataValue)listValue, false);
            }
            return listValue;
        } else {
            listValue.add(this.parseElement(inputSource, null, true));
        }
        return listValue;
    }

    private StructValue parseStructure(XmlInputSource inputSource, Map<QName, String> attributes, Constants.Type elementType) {
        String structName = attributes.get(Constants.VAPI_STRUCTURE_NAME);
        if (structName == null) {
            throw new DeserializationException("Missing or empty structure name attribute");
        }
        Object structValue = Constants.Type.STRUCT.equals((Object)elementType) ? new StructValue(structName) : new ErrorValue(structName);
        while (inputSource.nextTag() != 2) {
            Map<QName, String> childAttributes = this.getCurrentElementAttributes(inputSource);
            String fieldName = childAttributes.get(Constants.VAPI_FIELD_NAME);
            if (fieldName == null) {
                fieldName = inputSource.getName().getLocalPart();
            }
            structValue.setField(fieldName, this.parseElement(inputSource, (DataValue)structValue.getFields().get(fieldName), false));
        }
        return structValue;
    }

    private Constants.Type resolveElementType(boolean nested, Map<QName, String> attributes) {
        QName attrName;
        QName qName = attrName = nested ? Constants.VAPI_ELEMENT_TYPE : Constants.VAPI_TYPE;
        if (!attributes.containsKey(attrName)) {
            throw new DeserializationException("Expected type attribute not found: " + attrName);
        }
        try {
            return Constants.Type.valueOf(attributes.get(attrName).toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            throw new DeserializationException("Invalid element type detected: " + attributes.get(attrName), ex);
        }
    }

    private DataValue wrapIfOptional(DataValue value, boolean isOptional) {
        if (isOptional) {
            return new OptionalValue(value);
        }
        return value;
    }

    private String getTextValue(XmlInputSource source) {
        if (source.getEventType() != 1) {
            throw new DeserializationException("stream must be on START_ELEMENT");
        }
        int eventType = source.next();
        if (eventType == 2) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        while (eventType == 4) {
            result.append(source.getText());
            eventType = source.next();
        }
        while (eventType != 2) {
            eventType = source.next();
        }
        return result.toString();
    }

    private Map<QName, String> getCurrentElementAttributes(XmlInputSource source) {
        HashMap<QName, String> result = new HashMap<QName, String>();
        for (int i = 0; i < source.getAttributeCount(); ++i) {
            result.put(source.getAttributeName(i), source.getAttributeValue(i));
        }
        return result;
    }
}

