/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.ValueVisitor;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.is.Constants;
import com.vmware.vapi.internal.is.FieldNameUtil;
import com.vmware.vapi.is.DefaultAttributeGenerator;
import com.vmware.vapi.is.DocumentConfig;
import com.vmware.vapi.is.IsAttributeGenerator;
import com.vmware.vapi.is.ModelMetadata;
import com.vmware.vapi.is.XmlOutputHandler;
import com.vmware.vapi.is.exception.SerializationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;

public final class ValueSerializer
implements com.vmware.vapi.is.ValueSerializer {
    private final IsAttributeGenerator idGenerator;

    public ValueSerializer() {
        this(null);
    }

    public ValueSerializer(IsAttributeGenerator idGenerator) {
        this.idGenerator = idGenerator == null ? new DefaultAttributeGenerator() : idGenerator;
    }

    public void serialize(DataValue value, ModelMetadata metadata, DocumentConfig documentConfig, XmlOutputHandler outputHandler) throws SerializationException {
        outputHandler.writeStartDocument();
        value.accept((ValueVisitor)new Visitor(outputHandler, metadata, documentConfig));
        outputHandler.writeEndDocument();
        outputHandler.flush();
    }

    @Override
    public void serialize(StructValue value, ModelMetadata metadata, DocumentConfig documentConfig, XmlOutputHandler outputHandler) throws SerializationException {
        outputHandler.writeStartDocument();
        value.accept((ValueVisitor)new Visitor(outputHandler, metadata, documentConfig));
        outputHandler.writeEndDocument();
        outputHandler.flush();
    }

    protected final class Visitor
    implements ValueVisitor {
        private String fieldName;
        private boolean isRootEmitted = false;
        private final XmlOutputHandler outputHandler;
        private final ModelMetadata metadata;
        private final DocumentConfig docConfig;
        private List<Constants.Type> fieldType = new ArrayList<Constants.Type>();
        private StructValue rootStructValue;
        private StructValue currentStructValue;
        private ModelMetadata.StructureInfo currentStructInfo;
        private boolean isInMap = false;
        private String mapPath;

        public Visitor(XmlOutputHandler outputHandler, ModelMetadata metadata, DocumentConfig docConfig) {
            this.metadata = metadata;
            this.outputHandler = outputHandler;
            this.docConfig = docConfig;
        }

        public void visit(VoidValue value) {
            this.emitElement(null, (DataValue)value);
        }

        public void visit(BooleanValue value) {
            this.emitElement(Boolean.valueOf(value.getValue()).toString(), (DataValue)value);
        }

        public void visit(IntegerValue value) {
            this.emitElement(Long.valueOf(value.getValue()).toString(), (DataValue)value);
        }

        public void visit(DoubleValue value) {
            if (Double.isInfinite(value.getValue()) || Double.isNaN(value.getValue())) {
                throw new SerializationException("Unsupported double value - NaN or INF.");
            }
            this.emitElement(Double.valueOf(value.getValue()).toString(), (DataValue)value);
        }

        public void visit(StringValue value) {
            ModelMetadata.FieldInfo fieldInfo;
            if (!(this.currentStructInfo == null || this.currentStructValue == this.rootStructValue && this.fieldName.equals(this.currentStructInfo.getModelIdField()) || (fieldInfo = this.currentStructInfo.getFieldInfo(this.fieldName)) == null)) {
                this.startElement((DataValue)value);
                this.emitXLinkAttributes(value, fieldInfo);
                if (value != null) {
                    this.getOutputHandler().writeCharacters(value.getValue());
                }
                this.endElement((DataValue)value);
                return;
            }
            this.emitElement(value.getValue(), (DataValue)value);
        }

        public void visit(SecretValue value) {
            this.emitElement(new String(value.getValue()), (DataValue)value);
        }

        public void visit(BlobValue value) {
            this.emitElement(new String(Base64.encodeBase64((byte[])value.getValue())), (DataValue)value);
        }

        public void visit(OptionalValue value) {
            if (!this.fieldType.isEmpty() && Constants.Type.OPTIONAL == this.fieldType.get(this.fieldType.size() - 1)) {
                throw new SerializationException("Nested Optional<Optional<...>>> composition is not supported yet.");
            }
            this.startElement((DataValue)value);
            if (value.getValue() != null) {
                value.getValue().accept((ValueVisitor)this);
            }
            this.endElement((DataValue)value);
        }

        public void visit(ListValue value) {
            String currentFieldName = this.getElementType(0, true) == Constants.Type.LIST ? "elem" : this.fieldName;
            StructValue oldStructValue = this.currentStructValue;
            this.startElement((DataValue)value);
            if (value.isEmpty()) {
                this.writeEmptyList();
            } else {
                for (DataValue listItem : value.getList()) {
                    this.fieldName = currentFieldName;
                    this.currentStructValue = oldStructValue;
                    listItem.accept((ValueVisitor)this);
                }
            }
            this.endElement((DataValue)value);
            this.fieldName = null;
        }

        private void writeEmptyList() {
            if (this.getElementType(1, true) == Constants.Type.LIST) {
                this.getOutputHandler().writeStartElement("urn:vim25", "elem");
                this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "type", Constants.Type.LIST.toString().toLowerCase(Locale.ENGLISH));
                this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isEmpty", Boolean.TRUE.toString());
                if (this.isOptionalType(0)) {
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isOptional", Boolean.TRUE.toString());
                }
                this.getOutputHandler().writeEndElement();
            } else {
                this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isEmpty", Boolean.TRUE.toString());
            }
        }

        public void visit(StructValue value) {
            boolean oldIsInMap = this.isInMap;
            boolean currentIsInMap = false;
            String oldMapPath = this.mapPath;
            String currentMapPath = null;
            if (this.rootStructValue == null) {
                this.rootStructValue = value;
            }
            ModelMetadata.StructureInfo thisStructureInfo = null;
            if (this.metadata != null) {
                String metadataKey = value.getName();
                if (metadataKey.equals("map-entry")) {
                    currentIsInMap = true;
                    metadataKey = currentMapPath = String.format("%s-%s", this.isInMap ? this.mapPath : this.currentStructValue.getName(), this.fieldName);
                }
                thisStructureInfo = this.metadata.getStructureInfo(metadataKey);
            }
            this.currentStructValue = value;
            this.currentStructInfo = thisStructureInfo;
            this.startElement((DataValue)value);
            this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "name", value.getName());
            for (String this.fieldName : value.getFieldNames()) {
                this.currentStructValue = value;
                this.currentStructInfo = thisStructureInfo;
                this.isInMap = currentIsInMap;
                this.mapPath = currentMapPath;
                value.getField(this.fieldName).accept((ValueVisitor)this);
            }
            this.endElement((DataValue)value);
            this.isInMap = oldIsInMap;
            this.mapPath = oldMapPath;
        }

        private Constants.Type getElementType(int depth, boolean ignoreOptional) {
            int index = this.fieldType.size();
            while (index > 0) {
                if (this.fieldType.get(--index) != Constants.Type.OPTIONAL || !ignoreOptional) {
                    --depth;
                }
                if (depth != -1) continue;
                return this.fieldType.get(index);
            }
            return null;
        }

        private boolean isOptionalType(int depth) {
            if (this.fieldType.size() == 1 && this.fieldType.get(0) == Constants.Type.OPTIONAL) {
                return true;
            }
            int index = this.fieldType.size() - 1;
            while (index > 0) {
                if (depth == 0) {
                    return this.fieldType.get(index - 1) == Constants.Type.OPTIONAL;
                }
                if (this.fieldType.get(--index) == Constants.Type.OPTIONAL) {
                    --index;
                }
                --depth;
            }
            return false;
        }

        private boolean shouldWriteElement(DataValue current) {
            if (this.getElementType(0, false) == Constants.Type.LIST && ((ListValue)current).isEmpty()) {
                return true;
            }
            if (this.getElementType(0, false) == Constants.Type.OPTIONAL) {
                return !((OptionalValue)current).isSet();
            }
            return this.getElementType(0, true) != Constants.Type.LIST || this.getElementType(1, true) == Constants.Type.LIST;
        }

        private void startElement(DataValue value) {
            Constants.Type current = Constants.DATATYPE_TYPES.get(value.getType());
            this.fieldType.add(current);
            if (!this.shouldWriteElement(value)) {
                return;
            }
            String fieldCanonicalName = this.fieldName;
            String localName = this.getElementName(value);
            this.getOutputHandler().writeStartElement("urn:vim25", localName);
            if (!this.isRootEmitted) {
                this.emitVapiNamespace();
                if (value instanceof StructValue) {
                    this.emitQsNamespace();
                    this.emitXLinkNamespace();
                    this.emitQsIdFields((StructValue)value);
                }
                this.emitQsRevision();
                this.isRootEmitted = true;
            }
            this.emitType(value);
            if (!localName.equals(fieldCanonicalName)) {
                this.emitField(fieldCanonicalName);
            }
        }

        private void endElement(DataValue value) {
            if (this.shouldWriteElement(value)) {
                this.outputHandler.writeEndElement();
            }
            this.fieldType.remove(this.fieldType.size() - 1);
        }

        private void emitType(DataValue value) {
            if (this.getElementType(0, false) == Constants.Type.OPTIONAL) {
                if (this.getElementType(0, true) == Constants.Type.LIST) {
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isElementOptional", Boolean.TRUE.toString());
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "type", Constants.Type.LIST.name().toLowerCase(Locale.ENGLISH));
                } else {
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isOptional", Boolean.TRUE.toString());
                }
                return;
            }
            String type = value.getClass().getSimpleName();
            type = type.substring(0, type.length() - 5).toLowerCase(Locale.ENGLISH);
            if (this.getElementType(1, true) == Constants.Type.LIST) {
                this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "type", Constants.Type.LIST.name().toLowerCase(Locale.ENGLISH));
                this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "elementType", type);
                if (this.isOptionalType(1)) {
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isOptional", Boolean.TRUE.toString());
                }
                if (this.isOptionalType(0)) {
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isElementOptional", Boolean.TRUE.toString());
                }
            } else {
                this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "type", type);
                if (this.isOptionalType(0)) {
                    this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "isOptional", Boolean.TRUE.toString());
                }
            }
        }

        private void emitField(String fieldCanonicalName) {
            if (fieldCanonicalName == null) {
                return;
            }
            this.getOutputHandler().writeAttribute("urn:vim25", "vapi", "field", fieldCanonicalName);
        }

        private String getElementName(DataValue value) {
            String name = this.fieldName;
            this.fieldName = null;
            if (name != null) {
                return FieldNameUtil.toMixedCase(name);
            }
            if (this.getElementType(1, true) == Constants.Type.LIST) {
                if (this.isOptionalType(1)) {
                    return "val";
                }
                return "elem";
            }
            if (this.getElementType(0, true) == Constants.Type.LIST && !this.isOptionalType(0)) {
                return "elem";
            }
            if (this.isOptionalType(0)) {
                return "val";
            }
            if (value instanceof StructValue) {
                name = ((StructValue)value).getName();
                return FieldNameUtil.toMixedCase(name.substring(name.lastIndexOf(46) + 1));
            }
            return "value";
        }

        private void emitElement(String value, DataValue dataValue) {
            this.startElement(dataValue);
            if (value != null) {
                this.getOutputHandler().writeCharacters(value);
            }
            this.endElement(dataValue);
        }

        private void emitQsIdFields(StructValue value) {
            if (this.currentStructInfo == null) {
                throw new SerializationException("No metadata for the serialized model");
            }
            String idFieldName = this.currentStructInfo.getModelIdField();
            String idFieldValue = this.extractIdFieldValue(value, idFieldName);
            ModelMetadata.FieldInfo fieldInfo = this.currentStructInfo.getFieldInfo(idFieldName);
            if (fieldInfo == null) {
                throw new SerializationException("No metadata for the serialized model primary keyfield");
            }
            String modelId = value.getName();
            this.outputHandler.writeAttribute("urn:vmware:queryservice", "qs", "resource", this.generateXlinkValue(idFieldValue, fieldInfo));
            this.outputHandler.writeAttribute("urn:vmware:queryservice", "qs", "resourceType", this.extractIdFieldResourceType(fieldInfo));
            this.outputHandler.writeAttribute("urn:vmware:queryservice", "qs", "id", this.generateQsId(idFieldValue, fieldInfo, modelId));
            this.outputHandler.writeAttribute("urn:vmware:queryservice", "qs", "model", this.currentStructInfo.getModelName());
            this.outputHandler.writeAttribute("urn:vmware:queryservice", "qs", "modelKey", idFieldValue);
        }

        private String extractIdFieldValue(StructValue struct, String fieldName) {
            DataValue val = struct.getField(fieldName);
            if (val instanceof OptionalValue) {
                val = ((OptionalValue)val).getValue();
            }
            if (val == null || !(val instanceof StringValue)) {
                throw new SerializationException("Model key is required for model serialization");
            }
            return ((StringValue)val).getValue();
        }

        private String generateXlinkValue(String value, ModelMetadata.FieldInfo fieldInfo) {
            String result = ValueSerializer.this.idGenerator.generateXlinkHrefValue(new IdDetailsImpl(value, this.extractIdFieldResourceType(fieldInfo), this.docConfig != null ? this.docConfig.getServerId() : null, null));
            if (result == null) {
                throw new SerializationException("Can't get 'xlink' value from generator: " + ValueSerializer.this.idGenerator);
            }
            return result;
        }

        private String generateQsId(String value, ModelMetadata.FieldInfo fieldInfo, String modelId) {
            String result = ValueSerializer.this.idGenerator.generateQsIdValue(new IdDetailsImpl(value, this.extractIdFieldResourceType(fieldInfo), this.docConfig != null ? this.docConfig.getServerId() : null, modelId));
            if (result == null) {
                throw new SerializationException("Can't get 'qs:id' value from generator: " + ValueSerializer.this.idGenerator);
            }
            return result;
        }

        private String extractIdFieldResourceType(ModelMetadata.FieldInfo fieldInfo) {
            if (fieldInfo.getResourceType() != null) {
                return fieldInfo.getResourceType();
            }
            String resourceField = fieldInfo.getResourceTypeFieldName();
            DataValue resourceValue = this.currentStructValue.getField(resourceField);
            if (resourceValue instanceof OptionalValue) {
                resourceValue = ((OptionalValue)resourceValue).getValue();
            }
            if (resourceValue instanceof StringValue) {
                return ((StringValue)resourceValue).getValue();
            }
            throw new SerializationException("Invalid structure, unable to extract resource type for field " + this.fieldName + " of " + this.currentStructValue.getName());
        }

        private void emitVapiNamespace() {
            this.outputHandler.writeNamespace("urn:vim25", "");
            this.outputHandler.writeNamespace("urn:vim25", "vapi");
        }

        private void emitQsNamespace() {
            this.outputHandler.writeNamespace("urn:vmware:queryservice", "qs");
        }

        private void emitXLinkNamespace() {
            this.outputHandler.writeNamespace("http://www.w3.org/1999/xlink", "xlink");
        }

        private void emitQsRevision() {
            if (this.docConfig == null || this.docConfig.getRevision() == null) {
                return;
            }
            this.getOutputHandler().writeAttribute("urn:vmware:queryservice", "qs", "revision", this.docConfig.getRevision().toString());
        }

        private void emitXLinkAttributes(StringValue value, ModelMetadata.FieldInfo fieldInfo) {
            if (fieldInfo != null && (fieldInfo.getResourceType() != null || fieldInfo.getResourceTypeFieldName() != null)) {
                this.getOutputHandler().writeAttribute("http://www.w3.org/1999/xlink", "xlink", "type", "simple");
                this.getOutputHandler().writeAttribute("http://www.w3.org/1999/xlink", "xlink", "href", this.generateXlinkValue(value.getValue(), fieldInfo));
            }
        }

        private XmlOutputHandler getOutputHandler() {
            return this.outputHandler;
        }
    }

    static class IdDetailsImpl
    implements IsAttributeGenerator.IdDetails {
        private String resourceId;
        private String resourceType;
        private String serverGuid;
        private String modelType;

        IdDetailsImpl(String resourceId, String resourceType, String serverGuid, String modelType) {
            assert (resourceId != null);
            assert (resourceType != null);
            this.resourceId = resourceId;
            this.resourceType = resourceType;
            this.serverGuid = serverGuid;
            this.modelType = modelType;
        }

        @Override
        public String getIdValue() {
            return this.resourceId;
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String getServerGuid() {
            return this.serverGuid;
        }

        @Override
        public String getModelType() {
            return this.modelType;
        }
    }
}

