/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.vm.api.DatastoreMirrorsInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VmHostMigrateFilterBuilder
implements QueryFilterBuilder {
    private static final String VM_DATASTORES_PROPERTY = "vmDatastoresInfo";
    private static final String DATASTORE_HOSTS_PROPERTY = "hostKey";
    private static final String CLUSTER_HOSTS_PROPERTY = "host";
    private static final String CLUSTER_DRS_ENABLED_PROPERTY = "configurationEx/drsConfig/enabled";
    private final QueryService _queryService;
    private final ObjectReferenceService _objectReferenceService;
    private static final ManagedObjectReference NO_SUCH_MOR = new ManagedObjectReference("HostSystem", "noID", "noGUID");

    public VmHostMigrateFilterBuilder(QueryServiceFactory factory, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{factory, objectReferenceService});
        this._queryService = factory.getQueryService();
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="vmMigrationHostFilter")
    public Filter vmMigrationHostFilter(String vmId, String[] allVms) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        List<Object> vmRefs = ArrayUtil.isNullOrEmpty((Object[])allVms) ? this.toRefs(vmId) : this.toRefs(allVms);
        Set<ManagedObjectReference> hostRefs = this.fetchRelevantHosts(vmRefs);
        if (hostRefs.isEmpty()) {
            hostRefs.add(NO_SUCH_MOR);
        }
        PropertyPredicate predicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, hostRefs);
        return new Filter(Collections.singletonList(predicate));
    }

    @QueryFilter(value="vmMigrationClusterFilter")
    public Filter vmMigrationClusterFilter(String vmId, String[] allVms) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        List<Object> vmRefs = ArrayUtil.isNullOrEmpty((Object[])allVms) ? this.toRefs(vmId) : this.toRefs(allVms);
        Set<ManagedObjectReference> hostRefs = this.fetchRelevantHosts(vmRefs);
        if (hostRefs.isEmpty()) {
            hostRefs.add(NO_SUCH_MOR);
        }
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        criteria.add(new PropertyPredicate(CLUSTER_HOSTS_PROPERTY, PropertyPredicate.ComparisonOperator.IN, hostRefs));
        criteria.add(new PropertyPredicate(CLUSTER_DRS_ENABLED_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true));
        return new Filter(criteria);
    }

    @QueryFilter(value="vmMigrationResourcePoolFilter")
    public Filter vmMigrationResourcePoolFilter(String vmId, String[] allVms) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        List<Object> vmRefs = ArrayUtil.isNullOrEmpty((Object[])allVms) ? this.toRefs(vmId) : this.toRefs(allVms);
        Set<ManagedObjectReference> hostRefs = this.fetchRelevantHosts(vmRefs);
        if (hostRefs.isEmpty()) {
            hostRefs.add(NO_SUCH_MOR);
        }
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        criteria.add(new PropertyPredicate("allHosts", PropertyPredicate.ComparisonOperator.IN, hostRefs));
        criteria.add(new PropertyPredicate("isRootRP", PropertyPredicate.ComparisonOperator.EQUAL, (Object)false));
        return new Filter(criteria);
    }

    @QueryFilter(value="vmMigrationVirtualAppFilter")
    public Filter vmMigrationVirtualAppFilter(String vmId, String[] allVms) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        List<Object> vmRefs = ArrayUtil.isNullOrEmpty((Object[])allVms) ? this.toRefs(vmId) : this.toRefs(allVms);
        Set<ManagedObjectReference> hostRefs = this.fetchRelevantHosts(vmRefs);
        if (hostRefs.isEmpty()) {
            hostRefs.add(NO_SUCH_MOR);
        }
        PropertyPredicate predicate = new PropertyPredicate("allHosts", PropertyPredicate.ComparisonOperator.IN, hostRefs);
        return new Filter(Collections.singletonList(predicate));
    }

    private Set<ManagedObjectReference> fetchRelevantHosts(List<Object> refs) {
        List<DatastoreMirrorsInfo> distinctDsInfos = this.fetchDatastores(refs);
        ArrayList<ManagedObjectReference> dsRefs = new ArrayList<ManagedObjectReference>();
        for (DatastoreMirrorsInfo dmi : distinctDsInfos) {
            dsRefs.add(dmi.ref);
            if (ArrayUtil.isNullOrEmpty((Object[])dmi.mirrors)) continue;
            dsRefs.addAll(Arrays.asList(dmi.mirrors));
        }
        if (dsRefs.isEmpty()) {
            return new LinkedHashSet<ManagedObjectReference>();
        }
        ResultSet result = this._queryService.select(new String[]{DATASTORE_HOSTS_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, dsRefs).fetch();
        HashMap<ManagedObjectReference, Set> dsToHostsMap = new HashMap<ManagedObjectReference, Set>();
        for (ResourceItem rsItem : result.getItems()) {
            Object[] hosts = (ManagedObjectReference[])rsItem.get(DATASTORE_HOSTS_PROPERTY);
            if (ArrayUtil.isNullOrEmpty((Object[])hosts)) continue;
            dsToHostsMap.put((ManagedObjectReference)rsItem.getKey(), ArrayUtil.toSet((Object[])hosts));
        }
        LinkedHashSet intersection = null;
        for (DatastoreMirrorsInfo dmi : distinctDsInfos) {
            Set hostsForDsRef;
            LinkedHashSet allHosts = new LinkedHashSet();
            if (dmi.ref != null && (hostsForDsRef = (Set)dsToHostsMap.get(dmi.ref)) != null && !hostsForDsRef.isEmpty()) {
                allHosts.addAll(hostsForDsRef);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])dmi.mirrors)) {
                for (ManagedObjectReference ds : dmi.mirrors) {
                    Set hostsForDsMirrors;
                    if (ds == null || (hostsForDsMirrors = (Set)dsToHostsMap.get(ds)) == null || hostsForDsMirrors.isEmpty()) continue;
                    allHosts.addAll(hostsForDsMirrors);
                }
            }
            if (intersection == null) {
                intersection = new LinkedHashSet();
                intersection.addAll(allHosts);
                continue;
            }
            intersection.retainAll(allHosts);
            if (!intersection.isEmpty()) continue;
            break;
        }
        return intersection == null ? new LinkedHashSet() : intersection;
    }

    private List<DatastoreMirrorsInfo> fetchDatastores(List<Object> vmRefs) {
        if (ArrayUtil.isNullOrEmpty(vmRefs)) {
            return Collections.emptyList();
        }
        ResultSet result = this._queryService.select(new String[]{VM_DATASTORES_PROPERTY}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmRefs).fetch();
        List resultItems = result.getItems();
        if (resultItems.isEmpty()) {
            return new LinkedList<DatastoreMirrorsInfo>();
        }
        LinkedList<DatastoreMirrorsInfo> mergedResult = new LinkedList<DatastoreMirrorsInfo>();
        for (ResourceItem item : resultItems) {
            Object[] dsMirrorsInfo = (DatastoreMirrorsInfo[])item.get(VM_DATASTORES_PROPERTY);
            if (ArrayUtil.isNullOrEmpty((Object[])dsMirrorsInfo)) continue;
            mergedResult.addAll(Arrays.asList(dsMirrorsInfo));
        }
        return this.getDistinctMirrorsInfos(mergedResult);
    }

    private List<DatastoreMirrorsInfo> getDistinctMirrorsInfos(List<DatastoreMirrorsInfo> sourceMirrorsInfos) {
        LinkedHashSet<ManagedObjectReference> dsRefs = new LinkedHashSet<ManagedObjectReference>();
        LinkedList<DatastoreMirrorsInfo> distinctDsInfos = new LinkedList<DatastoreMirrorsInfo>();
        for (DatastoreMirrorsInfo sourceMirrorsInfo : sourceMirrorsInfos) {
            if (sourceMirrorsInfo == null || sourceMirrorsInfo.ref == null || dsRefs.contains(sourceMirrorsInfo.ref)) continue;
            dsRefs.add(sourceMirrorsInfo.ref);
            distinctDsInfos.add(sourceMirrorsInfo);
        }
        return distinctDsInfos;
    }

    private List<Object> toRefs(String ... vmIds) {
        if (ArrayUtil.isNullOrEmpty((Object[])vmIds)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(vmIds.length);
        for (String id : vmIds) {
            result.add(this._objectReferenceService.getReference(id, true));
        }
        return result;
    }
}

