/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.devsetup.registration;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;

public class ServerRegistration {
    private static final String WINDOWS_CFG_DIR = "C:/ProgramData/VMware/vCenterServer/cfg";
    private static final String MAC_CFG_DIR = "/var/lib/vmware/vsphere-client";
    private static final String TEMPORARY_DIR = "temp";
    private static boolean _verbose = false;

    public static void main(String[] stringArray) {
        Options options = ServerRegistration.createOptions();
        String string = "root";
        String string2 = null;
        String string3 = null;
        int n = 22;
        CommandLine commandLine = null;
        DefaultParser defaultParser = new DefaultParser();
        try {
            String string4;
            block9: {
                commandLine = defaultParser.parse(options, stringArray, true);
                _verbose = commandLine.hasOption("v");
                string = commandLine.getOptionValue("u");
                string = string != null ? string : "root";
                string2 = commandLine.getOptionValue("pw");
                string3 = commandLine.getOptionValue("vcip");
                try {
                    string4 = commandLine.getOptionValue("p");
                    n = string4 != null ? Integer.parseInt(string4) : 22;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!_verbose) break block9;
                    numberFormatException.printStackTrace();
                }
            }
            if (commandLine.hasOption("cfg")) {
                string4 = commandLine.getOptionValue("cfg");
            } else {
                string4 = System.getenv("VMWARE_CFG_DIR");
                if (string4 == null) {
                    boolean bl = System.getProperty("os.name").toLowerCase().contains("mac os");
                    string4 = WINDOWS_CFG_DIR;
                    if (bl) {
                        string4 = MAC_CFG_DIR;
                    }
                }
            }
            if (_verbose) {
                System.out.println("VMWARE_CFG_DIR is chosen to be: " + string4);
            }
            ServerRegistration.setupConfiguration(string3, n, string, string2, string4);
        }
        catch (ParseException parseException) {
            ServerRegistration.printHelp(options, parseException.getMessage());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder("vcip").longOpt("vCenterIP").hasArg().argName("vc server ip").desc("vCenter server IP address").required().build());
        options.addOption(Option.builder("pw").longOpt("password").hasArg().argName("SSH Password").desc("vCenter server ssh password").required().build());
        options.addOption(Option.builder("u").longOpt("user").hasArg().argName("SSH User").desc("vCenter server ssh user, by default 'root'").required(false).build());
        options.addOption(Option.builder("p").longOpt("port").hasArg().argName("vc server ssh port").desc("vCenter server ssh port, by default 22").required(false).build());
        options.addOption(Option.builder("v").longOpt("verbose").argName("verbose error message").desc("Print stack trace in case of an exception").required(false).build());
        options.addOption(Option.builder("cfg").hasArg().argName("path to the configuration folder").desc("Used to specify the folder where to setup the VC files").required(false).build());
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupConfiguration(String string, int n, String string2, String string3, String string4) {
        Session session = null;
        try {
            JSch jSch = new JSch();
            session = jSch.getSession(string2, string, n);
            session.setPassword(string3);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            ServerRegistration.generateConfigFiles(session, string4);
            ServerRegistration.downloadConfigFilesInDir(session, TEMPORARY_DIR);
            try {
                ServerRegistration.deleteOldFiles(string4);
                ServerRegistration.copyOrderedConfigFilesInCfg(TEMPORARY_DIR, string4);
            }
            finally {
                ServerRegistration.deleteFile(TEMPORARY_DIR);
            }
            ServerRegistration.editTomcatConfig(string4);
        }
        catch (JSchException | SftpException exception) {
            System.err.println("Has connection problem with vCenter server IP: " + string + ". Please check vCenter server and authentication.\n " + exception.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateConfigFiles(Session session, String string) throws JSchException, IOException {
        Channel channel = null;
        try {
            String string2;
            int n = -1;
            File file = new File("dev-setup.sh");
            Path path = Paths.get(file.getPath(), new String[0]);
            byte[] byArray = Files.readAllBytes(path);
            byte[] byArray2 = new byte[]{};
            byte[] byArray3 = ("export KEYSTORE=" + string.replace("\\", "/") + "/store.jks; ").getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray3.length + byArray.length);
            byteBuffer.put(byArray3);
            byteBuffer.put(byArray);
            byArray2 = byteBuffer.array();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(byArray2);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream(System.err);
            InputStream inputStream = channel.getInputStream();
            channel.connect();
            while (true) {
                if (channel.isClosed()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            n = channel.getExitStatus();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            System.out.println(stringBuffer);
            if (n != 0) {
                System.err.println("Found error when generate store.jks, webclient.properties and ds.properties files. ");
                System.exit(-1);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    private static void downloadConfigFilesInDir(Session session, String string) throws JSchException, IOException, SftpException {
        ChannelSftp channelSftp = null;
        try {
            channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect();
            ServerRegistration.downloadFile(channelSftp, string, "ds.properties");
            ServerRegistration.downloadFile(channelSftp, string, "webclient.properties");
            ServerRegistration.downloadFile(channelSftp, string, "store.jks");
        }
        finally {
            if (channelSftp != null) {
                channelSftp.disconnect();
            }
        }
    }

    private static void downloadFile(ChannelSftp channelSftp, String string, String string2) throws SftpException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            fileOutputStream = new FileOutputStream(new File(string + File.separator + string2));
            channelSftp.get(string2, fileOutputStream);
            fileOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException);
        }
        finally {
            block13: {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (!_verbose) break block13;
                    iOException.printStackTrace();
                }
            }
        }
        if (_verbose) {
            System.out.println("Downloaded file: \"" + string2 + "\" in \"" + string + "\"");
        }
    }

    private static void deleteOldFiles(String string) {
        if (_verbose) {
            System.out.println("Delete old files.");
        }
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(string, "store.jks"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(string, "vsphere-webclient.p12"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(string, "vsphere-webclient-cert.txt"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(string, "vsphere-webclient-key.txt"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(string, "vsphere-client" + File.separator + "cmCatalog"));
    }

    private static void copyOrderedConfigFilesInCfg(String string, String string2) throws IOException {
        String string3 = string2 + File.separator + "vsphere-client" + File.separator + "config";
        String string4 = string2 + File.separator + "vsphere-client";
        FileUtils.copyFileToDirectory(new File(string, "ds.properties"), new File(string3));
        FileUtils.copyFileToDirectory(new File(string, "webclient.properties"), new File(string4));
        FileUtils.copyFileToDirectory(new File(string, "store.jks"), new File(string2));
    }

    private static void deleteFile(String string) {
        block3: {
            File file = new File(string);
            try {
                FileUtils.forceDelete(file);
                if (_verbose) {
                    System.out.println("File: " + string + " was deleted.");
                }
            }
            catch (IOException iOException) {
                if (!_verbose) break block3;
                iOException.printStackTrace();
            }
        }
    }

    private static void editTomcatConfig(String string) throws IOException {
        String string2 = "../../vsphere-ui/server/configuration/tomcat-server.xml";
        Path path = Paths.get(string2, new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String string3 = new String(Files.readAllBytes(path), charset);
        String[] stringArray = string3.split("port=\"9443\"");
        String string4 = stringArray[stringArray.length - 1].replaceFirst("compression=\"on\"", "compression=\"off\"");
        string3 = string3.replaceFirst(stringArray[stringArray.length - 1], string4);
        string3 = string3.replaceFirst("certificateKeystoreFile=\".*store[.]jks\"", "certificateKeystoreFile=\"" + string.replace("\\", "/") + "/store.jks\"");
        Files.write(path, string3.getBytes(charset), new OpenOption[0]);
    }

    private static void printHelp(Options options, String string) {
        new HelpFormatter().printHelp("server-registration", "Register client to vCenter server", options, "\n" + string, true);
    }

    private static String joinPaths(String string, String string2) {
        String string3 = "%s" + File.separator + "%s";
        return String.format(string3, string, string2);
    }
}

