/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.capacity.util;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.capacity.data.util.CapacityObjectTypeConstants;
import com.vmware.vsphere.client.capacity.data.util.CapacityPropertyConstants;
import com.vmware.vsphere.client.data.util.DataUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapacityQueryBuilder {
    private static final ManagedObjectReference AGGREGATED_VC_OBJ = new ManagedObjectReference(CapacityObjectTypeConstants.FOLDER, "aggregatedData", "serverGUID");
    public static final String QUERY_NAME_PREFIX = "CapacityQueryBuilder";
    public static final String QUERY_NAME_SEPARATOR = ":";
    private static final Log _logger = LogFactory.getLog(CapacityQueryBuilder.class);

    public static QuerySpec[] buildQueries(List<ManagedObjectReference> moRefs, PropertySpec[] propSpecs) {
        if (ArrayUtil.isNullOrEmpty(moRefs)) {
            _logger.error((Object)"Required parameter moRefs is empty!");
            return null;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propSpecs)) {
            _logger.error((Object)"Required parameter propSpecs is empty!");
            return null;
        }
        ArrayList<QuerySpec> queries = new ArrayList<QuerySpec>();
        for (ManagedObjectReference ref : moRefs) {
            queries.add(CapacityQueryBuilder.buildQuerySpec(ref, propSpecs));
        }
        return queries.toArray(new QuerySpec[queries.size()]);
    }

    private static QuerySpec buildQuerySpec(ManagedObjectReference ref, PropertySpec[] propSpecs) {
        String[] requestedProps = DataUtil.extractSupportedProperties((PropertySpec[])propSpecs, (String[])CapacityPropertyConstants.SUPPORTED_PROPERTIES, (ManagedObjectReference)ref);
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = ConstraintBuilder.buildConstraint(ref, requestedProps);
        resourceSpec.propertySpecs = CapacityQueryBuilder.createHostAndDsPropertySpecs(requestedProps);
        QuerySpec query = new QuerySpec();
        query.resourceSpec = resourceSpec;
        query.name = "CapacityQueryBuilder:" + ref.toString();
        return query;
    }

    public static QuerySpec buildHostQuerySpec(ManagedObjectReference ref, PropertySpec[] propSpecs) {
        ValidationUtil.notNull((Object)ref, (String)"ref cannot be null");
        ValidationUtil.notNull((Object)propSpecs, (String)"propSpecs cannot be null");
        String[] requestedProps = DataUtil.extractSupportedProperties((PropertySpec[])propSpecs, (String[])CapacityPropertyConstants.SUPPORTED_PROPERTIES, (ManagedObjectReference)ref);
        if (!CapacityQueryBuilder.hasIntersection(CapacityPropertyConstants.SUPPORTED_COMPUTE_PROPERTIES, requestedProps)) {
            return null;
        }
        PropertySpec propSpec = CapacityQueryBuilder.createHostPropertySpec(requestedProps);
        Constraint constraint = ConstraintBuilder.buildHostsConstraint(ref);
        return CapacityQueryBuilder.buildQuerySpec(ref, constraint, propSpec);
    }

    public static QuerySpec buildDatastoreQuerySpec(ManagedObjectReference ref, PropertySpec[] propSpecs) {
        ValidationUtil.notNull((Object)ref, (String)"ref cannot be null");
        ValidationUtil.notNull((Object)propSpecs, (String)"propSpecs cannot be null");
        String[] requestedProps = DataUtil.extractSupportedProperties((PropertySpec[])propSpecs, (String[])CapacityPropertyConstants.SUPPORTED_PROPERTIES, (ManagedObjectReference)ref);
        if (!CapacityQueryBuilder.hasIntersection(CapacityPropertyConstants.SUPPORTED_STORAGE_PROPERTIES, requestedProps)) {
            return null;
        }
        PropertySpec propSpec = CapacityQueryBuilder.createDatastorePropertySpec(requestedProps);
        Constraint constraint = ConstraintBuilder.buildDatastoresConstraint(ref);
        return CapacityQueryBuilder.buildQuerySpec(ref, constraint, propSpec);
    }

    private static QuerySpec buildQuerySpec(ManagedObjectReference ref, Constraint constraint, PropertySpec propSpec) {
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        querySpec.name = "CapacityQueryBuilder:" + ref.toString();
        return querySpec;
    }

    private static PropertySpec createHostPropertySpec(String[] requestedProps) {
        ArrayList<String> hostPropsToRetrieve = new ArrayList<String>();
        if (CapacityQueryBuilder.hasIntersection(new String[]{"totalCpuCapacity", "freeCpuCapacity"}, requestedProps)) {
            hostPropsToRetrieve.add("summary.hardware.cpuMhz");
            hostPropsToRetrieve.add("summary.hardware.numCpuCores");
        }
        if (CapacityQueryBuilder.hasIntersection(new String[]{"usedCpuCapacity", "freeCpuCapacity"}, requestedProps)) {
            hostPropsToRetrieve.add("summary.quickStats.overallCpuUsage");
        }
        if (CapacityQueryBuilder.hasIntersection(new String[]{"totalMemoryCapacity", "freeMemoryCapacity"}, requestedProps)) {
            hostPropsToRetrieve.add("hardware.memorySize");
        }
        if (CapacityQueryBuilder.hasIntersection(new String[]{"usedMemoryCapacity", "freeMemoryCapacity"}, requestedProps)) {
            hostPropsToRetrieve.add("summary.quickStats.overallMemoryUsage");
        }
        if (hostPropsToRetrieve.isEmpty()) {
            return null;
        }
        return CapacityQueryBuilder.buildPropSpec(hostPropsToRetrieve, CapacityObjectTypeConstants.HOST_SYSTEM);
    }

    private static PropertySpec createDatastorePropertySpec(String[] requestedProps) {
        ArrayList<String> dsPropsToRetrieve = new ArrayList<String>();
        if (CapacityQueryBuilder.hasIntersection(new String[]{"totalStorageCapacity", "usedStorageCapacity"}, requestedProps)) {
            dsPropsToRetrieve.add("summary.capacity");
        }
        if (CapacityQueryBuilder.hasIntersection(new String[]{"usedStorageCapacity", "freeStorageCapacity"}, requestedProps)) {
            dsPropsToRetrieve.add("info.freeSpace");
        }
        if (dsPropsToRetrieve.isEmpty()) {
            return null;
        }
        return CapacityQueryBuilder.buildPropSpec(dsPropsToRetrieve, CapacityObjectTypeConstants.DATASTORE);
    }

    private static PropertySpec[] createHostAndDsPropertySpecs(String[] requestedProps) {
        PropertySpec datastorePropSpec;
        ArrayList<PropertySpec> specs = new ArrayList<PropertySpec>();
        PropertySpec hostPropSpec = CapacityQueryBuilder.createHostPropertySpec(requestedProps);
        if (hostPropSpec != null) {
            specs.add(hostPropSpec);
        }
        if ((datastorePropSpec = CapacityQueryBuilder.createDatastorePropertySpec(requestedProps)) != null) {
            specs.add(datastorePropSpec);
        }
        return specs.toArray(new PropertySpec[specs.size()]);
    }

    private static PropertySpec buildPropSpec(List<String> props, String type) {
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = type;
        propSpec.propertyNames = props.toArray(new String[props.size()]);
        return propSpec;
    }

    private static boolean hasIntersection(String[] arr1, String[] arr2) {
        for (String obj1 : arr1) {
            for (String obj2 : arr2) {
                if (!obj1.equals(obj2)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ConstraintBuilder {
        private ConstraintBuilder() {
        }

        private static Constraint buildConstraint(ManagedObjectReference ref, String[] requestedProps) {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            if (CapacityQueryBuilder.hasIntersection(CapacityPropertyConstants.SUPPORTED_COMPUTE_PROPERTIES, requestedProps)) {
                constraints.add(ConstraintBuilder.buildHostsConstraint(ref));
            }
            if (CapacityQueryBuilder.hasIntersection(CapacityPropertyConstants.SUPPORTED_STORAGE_PROPERTIES, requestedProps)) {
                constraints.add(ConstraintBuilder.buildDatastoresConstraint(ref));
            }
            return QueryUtil.combineIntoSingleConstraint((Constraint[])constraints.toArray(new Constraint[constraints.size()]), (Conjoiner)Conjoiner.OR);
        }

        private static Constraint buildHostsConstraint(ManagedObjectReference targetObjectRef) {
            if (ConstraintBuilder.requiresAggregatedCapacity(targetObjectRef)) {
                return ConstraintBuilder.getConnectedHostsConstraint();
            }
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, (String)CapacityObjectTypeConstants.HOST_SYSTEM)) {
                return ConstraintBuilder.getConnectedHostOic(targetObjectRef);
            }
            return ConstraintBuilder.getConnectedHostsConstraint(targetObjectRef);
        }

        private static boolean requiresAggregatedCapacity(ManagedObjectReference ref) {
            return ManagedObjectUtil.isOfType((ManagedObjectReference)ref, (String)CapacityObjectTypeConstants.FOLDER) && ref.getValue() == null || AGGREGATED_VC_OBJ.equals((Object)ref);
        }

        private static Constraint getConnectedHostsConstraint() {
            return QueryUtil.createPropertyConstraint((String)CapacityObjectTypeConstants.HOST_SYSTEM, (String)"connectionState", (Comparator)Comparator.EQUALS, (Object)HostSystem.ConnectionState.connected.toString());
        }

        private static Constraint getConnectedHostOic(ManagedObjectReference hostRef) {
            ObjectIdentityConstraint hostOic = QueryUtil.createObjectIdentityConstraint((Object)hostRef);
            Constraint connectedHostsConstraint = ConstraintBuilder.getConnectedHostsConstraint();
            Constraint[] hostConstraints = new Constraint[]{hostOic, connectedHostsConstraint};
            Constraint intersectionConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])hostConstraints, (Conjoiner)Conjoiner.AND);
            return intersectionConstraint;
        }

        private static Constraint getConnectedHostsConstraint(ManagedObjectReference targetObjectRef) {
            Constraint relatedHostsConstraint = QueryUtil.createConstraintForRelationship((Object)targetObjectRef, (String)"host", (String)CapacityObjectTypeConstants.HOST_SYSTEM);
            Constraint connectedHostsConstraint = ConstraintBuilder.getConnectedHostsConstraint();
            Constraint[] hostConstraints = new Constraint[]{relatedHostsConstraint, connectedHostsConstraint};
            Constraint intersectionConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])hostConstraints, (Conjoiner)Conjoiner.AND);
            return intersectionConstraint;
        }

        private static Constraint buildDatastoresConstraint(ManagedObjectReference targetObjectRef) {
            boolean requireHostConstraintFirst;
            if (ConstraintBuilder.requiresAggregatedCapacity(targetObjectRef)) {
                return ConstraintBuilder.getAccessibleDsConstraint();
            }
            boolean bl = requireHostConstraintFirst = ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, (String)CapacityObjectTypeConstants.HOST_SYSTEM) || ManagedObjectUtil.isHostFolder((ManagedObjectReference)targetObjectRef) || ManagedObjectUtil.isDatacenterFolder((ManagedObjectReference)targetObjectRef);
            if (requireHostConstraintFirst) {
                return ConstraintBuilder.getDsForHostsConstraint(targetObjectRef);
            }
            return ConstraintBuilder.getAccessibleDsConstraint(targetObjectRef);
        }

        private static Constraint getDsForHostsConstraint(ManagedObjectReference ref) {
            return QueryUtil.createRelationalConstraint((String)"datastore", (Constraint)ConstraintBuilder.buildHostsConstraint(ref), (Boolean)true, (String)CapacityObjectTypeConstants.DATASTORE);
        }

        private static Constraint getAccessibleDsConstraint(ManagedObjectReference ref) {
            String relation = ManagedObjectUtil.isStorageFolder((ManagedObjectReference)ref) ? "allDs" : "datastore";
            Constraint relatedDatastoresConstraint = QueryUtil.createConstraintForRelationship((Object)ref, (String)relation, (String)CapacityObjectTypeConstants.DATASTORE);
            PropertyConstraint onlyAccessibleDatastoresConstraint = ConstraintBuilder.getAccessibleDsConstraint();
            Constraint[] dsConstraints = new Constraint[]{relatedDatastoresConstraint, onlyAccessibleDatastoresConstraint};
            return QueryUtil.combineIntoSingleConstraint((Constraint[])dsConstraints, (Conjoiner)Conjoiner.AND);
        }

        private static PropertyConstraint getAccessibleDsConstraint() {
            return QueryUtil.createPropertyConstraint((String)CapacityObjectTypeConstants.DATASTORE, (String)"summary.accessible", (Comparator)Comparator.EQUALS, (Object)true);
        }
    }
}

