/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vapi.bindings.Structure;
import com.vmware.vcenter.ovf.ExportSession;
import com.vmware.vcenter.ovf.ExportSessionTypes;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.provisioning.util.OvfExportSessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OvfExportSessionPropertyAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(OvfExportSessionPropertyAdapter.class);
    private static final String PROPERTY_EXPORT_PREVIEW = "ovfExportPreview";
    private final ExportSession _exportSession;

    public OvfExportSessionPropertyAdapter(ExportSession ovfExportService, DataServiceExtensionRegistry registry) {
        Validate.notNull((Object)ovfExportService, (String)"ExportSession null");
        Validate.notNull((Object)registry, (String)"DataServiceExtensionRegistry null");
        this._exportSession = ovfExportService;
        TypeInfo[] providedProperties = new TypeInfo[]{this.createTypeInfo(VirtualMachine.class, PROPERTY_EXPORT_PREVIEW), this.createTypeInfo(VirtualApp.class, PROPERTY_EXPORT_PREVIEW)};
        registry.registerDataAdapter((PropertyProviderAdapter)this, providedProperties);
    }

    private TypeInfo createTypeInfo(Class<?> type2, String propertyName) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = type2.getSimpleName();
        typeInfo.properties = new String[]{propertyName};
        return typeInfo;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest, (String)"null request");
        ArrayList<ResultItem> results = new ArrayList<ResultItem>();
        List<String> exportFlags = Collections.emptyList();
        List errors = Collections.emptyList();
        for (Object obj : propertyRequest.objects) {
            if (obj instanceof ManagedObjectReference) {
                ManagedObjectReference moref = (ManagedObjectReference)obj;
                try {
                    ResultItem result = this.getExportPreviewResult(moref, exportFlags);
                    results.add(result);
                }
                catch (Exception ex) {
                    _logger.error((Object)("Exception getting export preview for " + moref.toString()), (Throwable)ex);
                    errors.add(ex);
                }
                continue;
            }
            _logger.error((Object)("Invalid target class " + obj.getClass().getCanonicalName()));
        }
        ResultSet resultSet = new ResultSet();
        if (errors.size() == 1) {
            resultSet.error = (Exception)errors.get(0);
        } else if (errors.size() > 1) {
            resultSet.error = new CompositeException(errors);
        }
        resultSet.items = (ResultItem[])ArrayUtil.toArray(results, ResultItem.class);
        return resultSet;
    }

    private ResultItem getExportPreviewResult(ManagedObjectReference obj, List<String> exportFlags) {
        ResultItem result = new ResultItem();
        result.resourceObject = obj;
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)obj, VirtualMachine.class) && !ManagedObjectUtil.isOfType((ManagedObjectReference)obj, VirtualApp.class)) {
            _logger.error((Object)("Invaild target moref type " + obj.getType()));
            return result;
        }
        ExportSessionTypes.SourceInfo sourceInfo = OvfExportSessionUtil.getSourceInfo(obj);
        ExportSessionTypes.PreviewSpec previewSpec = new ExportSessionTypes.PreviewSpec();
        previewSpec.setExportFlags(exportFlags);
        ExportSessionTypes.Preview exportPreview = this._exportSession.preview(sourceInfo, (Structure)previewSpec);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ExportSessionTypes.PreviewFile file : exportPreview.getFiles()) {
            fileNames.add(file.getName());
        }
        PropertyValue property = ResultUtil.newProperty((String)PROPERTY_EXPORT_PREVIEW, fileNames);
        result.properties = new PropertyValue[]{property};
        return result;
    }
}

