/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vcenter.ovf.DeploymentOptionParams;
import com.vmware.vcenter.ovf.EulaParams;
import com.vmware.vcenter.ovf.IpAllocationParams;
import com.vmware.vcenter.ovf.NetworkMappingParams;
import com.vmware.vcenter.ovf.PropertyParams;
import com.vmware.vcenter.ovf.ScaleOutParams;
import com.vmware.vcenter.ovf.SourceNetwork;
import com.vmware.vcenter.ovf.VServiceDependency;
import com.vmware.vcenter.ovf.VServiceParams;
import com.vmware.vim.binding.vim.fault.MissingIpPool;
import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.provisioning.ovf.OvfDeployService;
import com.vmware.vsphere.client.provisioning.ovf.OvfErrorFormatter;
import com.vmware.vsphere.client.provisioning.ovf.OvfQueryResult;
import com.vmware.vsphere.client.provisioning.ovf.spec.ScaleOutValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.DeploymentOptionValidationData;
import com.vmware.vsphere.client.provisioning.spec.DeploymentOptionValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.EulaValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.IpAllocationValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.NetworkConfigValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.NetworkMapping;
import com.vmware.vsphere.client.provisioning.spec.NetworkMappingsValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.PropertiesValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.VServiceValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.VirtualServiceDependency;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import com.vmware.vsphere.client.provisioning.util.network.ProvisioningNetworkUtil;
import com.vmware.vsphere.client.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ProvisioningMutationProvider
implements MutationProvider {
    private static final String IP_POOL_PROPERTY = "ipPool";
    private final OvfDeployService _deployService;
    private final DataService _dataService;
    private final OvfErrorFormatter _ovfErrorFormatter;

    public ProvisioningMutationProvider(OvfDeployService deployService, OvfErrorFormatter ovfErrorFormatter, DataService dataService) {
        this._deployService = deployService;
        this._ovfErrorFormatter = ovfErrorFormatter;
        this._dataService = dataService;
    }

    public ValidationResult validate(EulaValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        EulaParams eulaParams = (EulaParams)CollectionUtil.getObjectByType((Object[])spec.commonContext, EulaParams.class);
        if (eulaParams == null) {
            validationResult.result = spec.commonContext;
            return validationResult;
        }
        eulaParams.setEulas(Collections.emptyList());
        eulaParams.setAllEULAAccepted(Boolean.valueOf(spec.eulaAccepted));
        validationResult.result = spec.commonContext;
        return validationResult;
    }

    public ValidationResult validate(DeploymentOptionValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        try {
            PropertyParams propertyParams;
            DeploymentOptionParams deploymentOptionParams = (DeploymentOptionParams)CollectionUtil.getObjectByType(spec.commonContext, DeploymentOptionParams.class);
            if (deploymentOptionParams == null) {
                throw new IllegalArgumentException("spec.commonContext does not contain OvfDeploymentOptionParams.");
            }
            DeploymentOptionValidationData data2 = new DeploymentOptionValidationData();
            if (ObjectUtil.objectsEqual((Object)deploymentOptionParams.getSelectedKey(), (Object)spec.selectedOptionKey)) {
                data2.newContext = new ArrayList<Object>(spec.commonContext);
                data2.newWorkflowPath = ProvisioningServiceUtil.getWorkflowPath(data2.newContext, this._dataService);
                validationResult.result = data2;
                return validationResult;
            }
            ScaleOutParams scaleOutParams = (ScaleOutParams)CollectionUtil.getObjectByType(spec.commonContext, ScaleOutParams.class);
            if (scaleOutParams != null) {
                spec.commonContext.remove(scaleOutParams);
            }
            if ((propertyParams = (PropertyParams)CollectionUtil.getObjectByType(spec.commonContext, PropertyParams.class)) != null) {
                spec.commonContext.remove(propertyParams);
            }
            deploymentOptionParams.setSelectedKey(spec.selectedOptionKey);
            OvfQueryResult result = this._deployService.queryOvf(spec.commonContext);
            if (!ArrayUtil.isNullOrEmpty((List)result.errors)) {
                throw new MethodFault(this._ovfErrorFormatter.format(result.errors));
            }
            data2.newContext = new ArrayList<Object>(result.newContext);
            data2.newWorkflowPath = ProvisioningServiceUtil.getWorkflowPath(data2.newContext, this._dataService);
            validationResult.result = data2;
            ProvisioningServiceUtil.addNonConfigurableProperties(result, data2.newContext);
        }
        catch (Exception e) {
            validationResult.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return validationResult;
    }

    public ValidationResult validate(Object target, NetworkConfigValidationSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = target;
        ValidationResult networkMappingsValidationResult = this.validate(target, spec.networkMappingsValidationSpec);
        ValidationResult ipAllocationValidationResult = this.validate(target, spec.ipAllocationValidationSpec);
        Object object = validationResult.result = networkMappingsValidationResult.result != null ? networkMappingsValidationResult.result : ipAllocationValidationResult.result;
        validationResult.error = networkMappingsValidationResult.error != null ? networkMappingsValidationResult.error : (ipAllocationValidationResult.error != null ? ipAllocationValidationResult.error : (this.isIpPoolConfigurationValid(spec) ? null : new MissingIpPool()));
        return validationResult;
    }

    private boolean isIpPoolConfigurationValid(NetworkConfigValidationSpec spec) throws Exception {
        Object[] networkIpPools;
        if (spec == null || spec.networkMappingsValidationSpec == null || spec.networkMappingsValidationSpec.mappingSpec == null || ArrayUtil.isNullOrEmpty((Object[])spec.networkMappingsValidationSpec.mappingSpec.networkMappings) || spec.ipAllocationValidationSpec == null || spec.ipAllocationValidationSpec.ovfIpAllocationParams == null || !spec.ipAllocationValidationSpec.ovfIpAllocationParams.getIpAllocationPolicy().equals((Object)IpAllocationParams.IpAllocationPolicy.STATIC_IPPOOL) && !spec.ipAllocationValidationSpec.ovfIpAllocationParams.getIpAllocationPolicy().equals((Object)IpAllocationParams.IpAllocationPolicy.TRANSIENT_IPPOOL)) {
            return true;
        }
        IpAllocationParams.IpProtocol ipProtocol = spec.ipAllocationValidationSpec.ovfIpAllocationParams.getIpProtocol();
        Object[] uniqueNetworks = this.getUniqueNetworkRefs(spec.networkMappingsValidationSpec.mappingSpec.networkMappings);
        if (!ArrayUtil.isNullOrEmpty((Object[])uniqueNetworks) && !ArrayUtil.isNullOrEmpty((Object[])(networkIpPools = QueryUtil.getProperty((DataService)this._dataService, (Object[])uniqueNetworks, (String)IP_POOL_PROPERTY)))) {
            for (Object pv : networkIpPools) {
                if (((PropertyValue)pv).value == null || !(((PropertyValue)pv).value instanceof IpPool)) {
                    return false;
                }
                IpPool ipPool = (IpPool)((PropertyValue)pv).value;
                if (ProvisioningNetworkUtil.isProtocolSupportedByIpPool(ipPool, ipProtocol)) continue;
                return false;
            }
        }
        return true;
    }

    private ManagedObjectReference[] getUniqueNetworkRefs(NetworkMapping[] networkMappings) {
        if (ArrayUtil.isNullOrEmpty((Object[])networkMappings)) {
            return new ManagedObjectReference[0];
        }
        HashSet<ManagedObjectReference> uniqueTargetNetworks = new HashSet<ManagedObjectReference>();
        for (NetworkMapping mapping : networkMappings) {
            if (mapping == null || mapping.targetNetworkRef == null) continue;
            uniqueTargetNetworks.add(mapping.targetNetworkRef);
        }
        return uniqueTargetNetworks.toArray(new ManagedObjectReference[uniqueTargetNetworks.size()]);
    }

    public ValidationResult validate(Object target, IpAllocationValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = target;
        IpAllocationParams ipAllocationParams = (IpAllocationParams)CollectionUtil.getObjectByType((Object[])spec.commonContext, IpAllocationParams.class);
        if (ipAllocationParams == null) {
            validationResult.result = spec.commonContext;
            return validationResult;
        }
        if (spec.ovfIpAllocationParams != null) {
            ipAllocationParams.setIpProtocol(spec.ovfIpAllocationParams.getIpProtocol());
            ipAllocationParams.setIpAllocationPolicy(spec.ovfIpAllocationParams.getIpAllocationPolicy());
        }
        validationResult.result = spec.commonContext;
        return validationResult;
    }

    public ValidationResult validate(Object target, NetworkMappingsValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = target;
        NetworkMappingParams networkParams = (NetworkMappingParams)CollectionUtil.getObjectByType((Object[])spec.commonContext, NetworkMappingParams.class);
        if (networkParams == null) {
            validationResult.result = spec.commonContext;
            return validationResult;
        }
        ArrayList<SourceNetwork> newNetworkMapping = new ArrayList<SourceNetwork>();
        for (NetworkMapping mapping : spec.mappingSpec.networkMappings) {
            SourceNetwork network = new SourceNetwork();
            network.setName(mapping.sourceNetworkName);
            network.setDescription(mapping.sourceNetworkDescription);
            network.setTarget(CisIdConverter.toGlobalCisId((ManagedObjectReference)mapping.targetNetworkRef, (String)mapping.targetNetworkRef.getServerGuid()));
            newNetworkMapping.add(network);
        }
        networkParams.setSourceNetworks(newNetworkMapping);
        validationResult.result = spec.commonContext;
        return validationResult;
    }

    public ValidationResult validate(PropertiesValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        PropertyParams propertyParams = (PropertyParams)CollectionUtil.getObjectByType((Object[])spec.commonContext, PropertyParams.class);
        if (propertyParams == null) {
            validationResult.result = spec.commonContext;
            return validationResult;
        }
        PropertyParams userInput = spec.dataToValidate;
        propertyParams.setProperties(userInput.getProperties());
        validationResult.result = spec.commonContext;
        return validationResult;
    }

    public ValidationResult validate(ScaleOutValidationSpec spec) {
        ScaleOutParams params = (ScaleOutParams)CollectionUtil.getObjectByType((List)spec.commonContext, ScaleOutParams.class);
        if (params != null) {
            spec.commonContext.remove(params);
        }
        spec.commonContext.add(spec.params);
        ValidationResult result = new ValidationResult();
        result.result = spec.commonContext;
        return result;
    }

    public ValidationResult validate(Object objRef, VServiceValidationSpec spec) {
        VServiceParams params = (VServiceParams)CollectionUtil.getObjectByType((Object[])spec.commonContext, VServiceParams.class);
        this.applyVServiceProviderChanges(params, spec);
        ValidationResult result = new ValidationResult();
        result.result = spec.commonContext;
        return result;
    }

    private void applyVServiceProviderChanges(VServiceParams params, VServiceValidationSpec spec) {
        if (params == null || spec == null || ArrayUtil.isNullOrEmpty((Object[])spec.dependencies)) {
            return;
        }
        HashMap<String, String> dependencyToProviderMap = new HashMap<String, String>();
        for (VirtualServiceDependency dependency : spec.dependencies) {
            dependencyToProviderMap.put(dependency.id, dependency.providerKey);
        }
        List configuredDependencies = params.getDependencies();
        for (VServiceDependency dependencyParam : configuredDependencies) {
            String dependencyId = dependencyParam.getId();
            if (!dependencyToProviderMap.containsKey(dependencyId)) continue;
            String selectedProviderKey = (String)dependencyToProviderMap.get(dependencyId);
            dependencyParam.setSelectedProviderKey(selectedProviderKey);
        }
    }
}

