/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common.testhelper;

import com.vmware.cis.cm.common.endpoint.HealthStatusEndPoint;
import com.vmware.cis.cm.common.testhelper.TestHelperRequest;
import com.vmware.vim.binding.cis.cm.monitor.HealthStatus;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;

public class SetHealthStatusRequest
extends TestHelperRequest {
    private Arguments _args;

    public SetHealthStatusRequest() {
    }

    public SetHealthStatusRequest(Arguments args) {
        this.setArguments(args);
    }

    public void setArguments(Arguments args) {
        this._args = args;
    }

    public Arguments getArguments() {
        return this._args;
    }

    @Override
    public void serializeArguments(JsonGenerator jg) throws IOException {
        _jsonMapper.writeValue(jg, (Object)this.getArguments());
    }

    @Override
    public void deserializeArguments(JsonParser jp) throws IOException {
        this.setArguments((Arguments)_jsonMapper.readValue(jp, Arguments.class));
    }

    @Override
    public void execute() {
        HealthStatusEndPoint.updateStatus(this._args.getStatusCode(), Message.toLocalizable(this._args.getMessages()));
    }

    public static class Arguments {
        private HealthStatus.Code _statusCode;
        private Message[] _messages;

        public Arguments() {
        }

        public Arguments(HealthStatus.Code statusCode, Message[] messages) {
            this();
            this.setStatusCode(statusCode);
            this.setMessages(messages);
        }

        public void setStatusCode(HealthStatus.Code statusCode) {
            this._statusCode = statusCode;
        }

        public HealthStatus.Code getStatusCode() {
            return this._statusCode;
        }

        public void setMessages(Message[] messages) {
            this._messages = messages == null ? null : Arrays.copyOf(messages, messages.length);
        }

        public Message[] getMessages() {
            return this._messages == null ? null : Arrays.copyOf(this._messages, this._messages.length);
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && (this._statusCode != null ? this._statusCode.equals((Object)((Arguments)obj).getStatusCode()) : ((Arguments)obj).getStatusCode() == null) && Arrays.equals(this._messages, ((Arguments)obj).getMessages());
        }

        public int hashCode() {
            int hc = this._statusCode.hashCode();
            if (this._messages != null) {
                for (Message m : this._messages) {
                    hc += m.hashCode();
                }
            }
            return hc;
        }
    }

    public static class Message {
        private String _key;
        private Object[] _args;
        private String _defText;

        public Message() {
        }

        public Message(String key, Object[] args, String defText) {
            this();
            this.setKey(key);
            this.setArgs(args);
            this.setDefText(defText);
        }

        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public Object[] getArgs() {
            return this._args == null ? null : Arrays.copyOf(this._args, this._args.length);
        }

        public void setArgs(Object[] args) {
            this._args = args == null ? null : Arrays.copyOf(args, args.length);
        }

        public String getDefText() {
            return this._defText;
        }

        public void setDefText(String defText) {
            this._defText = defText;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && (this._key != null ? this._key.equals(((Message)obj).getKey()) : ((Message)obj).getKey() == null) && Arrays.equals(this._args, ((Message)obj).getArgs()) && (this._defText != null ? this._defText.equals(((Message)obj).getDefText()) : ((Message)obj).getDefText() == null);
        }

        public int hashCode() {
            return this._key.hashCode();
        }

        public static LocalizableMessage toLocalizable(Message m) {
            LocalizableMessageImpl lm = new LocalizableMessageImpl();
            lm.setKey(m.getKey());
            lm.setMessage(m.getDefText());
            if (m.getArgs() != null) {
                ArrayList<KeyAnyValueImpl> l = new ArrayList<KeyAnyValueImpl>();
                for (Object arg : m.getArgs()) {
                    KeyAnyValueImpl kv = new KeyAnyValueImpl();
                    kv.setKey("");
                    kv.setValue(arg);
                    l.add(kv);
                }
                lm.setArg(l.toArray(new KeyAnyValue[l.size()]));
            }
            return lm;
        }

        public static LocalizableMessage[] toLocalizable(Message[] a) {
            ArrayList<LocalizableMessage> l = new ArrayList<LocalizableMessage>();
            if (a != null) {
                for (Message m : a) {
                    l.add(Message.toLocalizable(m));
                }
            }
            return l.toArray(new LocalizableMessage[l.size()]);
        }

        public static Message fromLocalizable(LocalizableMessage lm) {
            Message m = new Message();
            m.setKey(lm.getKey());
            m.setDefText(lm.getMessage());
            if (lm.getArg() != null) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (KeyAnyValue kv : lm.getArg()) {
                    l.add(kv.getValue());
                }
                m.setArgs(l.toArray(new Object[l.size()]));
            }
            return m;
        }

        public static Message[] fromLocalizable(LocalizableMessage[] a) {
            ArrayList<Message> l = new ArrayList<Message>();
            if (a != null) {
                for (LocalizableMessage lm : a) {
                    l.add(Message.fromLocalizable(lm));
                }
            }
            return l.toArray(new Message[l.size()]);
        }
    }
}

