/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension;

import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.extension.PluginConstants;
import com.vmware.vise.vim.extension.ScriptPluginUtil;
import com.vmware.vise.vim.scriptPlugin.ScriptPluginService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptPluginXmlTransformer {
    private static final Log _logger = LogFactory.getLog(ScriptPluginXmlTransformer.class);
    private FileWriter _plugin;
    private ScriptPluginService _scriptPluginService;
    private FileWriter _pluginPackageFile;
    private ArrayList<ScriptPluginUtil.ActionSetInfo> _actionSetInfos = new ArrayList();
    private VcService _vcService = null;
    private double _uniqueIdentifier = 0.0;
    private Map<String, String> xml = new HashMap<String, String>();
    private Map<String, String> extensionPtByLegacyExtensionPt = new HashMap<String, String>();
    private Map<String, ArrayList<ScriptPluginUtil.InventoryMenuInfo>> inventoryMenus = new HashMap<String, ArrayList<ScriptPluginUtil.InventoryMenuInfo>>();

    public ScriptPluginXmlTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.xml.put("HomeView", "<extension id='$id'>\n\t<extendedPoint>vise.global.views</extendedPoint>\n\t<object>\n\t\t<name>$name</name>\n\t\t<componentClass className='com.vmware.vsphere.client.views.WebPluginView'>\n\t\t\t<object>\n\t\t\t\t<root>\n\t\t\t\t\t<multiVCsupported>$multiVCsupported</multiVCsupported>\n<useContextObject>false</useContextObject>\n\t\t\t\t\t<scriptUrl>$url</scriptUrl><extensionId>$extensionId</extensionId>\n\t\t\t\t</root>\n\t\t\t</object>\n\t\t</componentClass>\n\t</object>\n</extension>\n<extension id='$id.shortcut'>\n\t<extendedPoint>vise.home.shortcuts</extendedPoint>\n\t<object>\n\t\t<name>$name</name>\n\t\t<categoryUid>vsphere.core.controlcenter.legacyCategory</categoryUid>\n\t\t<targetViewUid>$id</targetViewUid>\n\t</object>\n");
        this.xml.put("InventoryView", "<extension id='$id'>\n\t<extendedPoint>$extensionPoint</extendedPoint>\n\t<object>\n\t\t<name>$name</name>\n\t\t<componentClass className='com.vmware.vsphere.client.views.WebPluginView'>\n\t\t\t<object>\n\t\t\t\t<root>\n\t\t\t\t\t<multiVCsupported>$multiVCsupported</multiVCsupported>\n<useContextObject>true</useContextObject>\n\t\t\t\t\t<scriptUrl>$url</scriptUrl><extensionId>$extensionId</extensionId>\n\t\t\t\t</root>\n\t\t\t</object>\n\t\t</componentClass>\n\t</object>\n");
        this.xml.put("plugin-package", "<?xml version='1.0'?><pluginPackage id='$id' version='$version' name='$name' description='$description' vendor='$vendor'>\n\t<dependencies>\n\t\t<pluginPackage id='com.vmware.vsphere.client' version='5.1.0'/>\n\t</dependencies>\n</pluginPackage>");
        this.xml.put("MainMenus", "<extension id='$id'><extendedPoint>vsphere.core.toolbarUserMenu.actions</extendedPoint><object><actions><com.vmware.actionsfw.ActionSpec><uid>$uid</uid><label>$label</label><category>vsphere.core.scriptPlugins</category><delegate><className>com.vmware.vsphere.client.commands.ScriptPluginActionDelegate</className><object><root><scriptUrl>$url</scriptUrl><useContextObject>false</useContextObject><display>$display</display></root></object></delegate></com.vmware.actionsfw.ActionSpec></actions></object></extension>");
        this.xml.put("Folder", "<objectType>Folder</objectType><propertyConditions><com.vmware.data.query.CompositeConstraint><nestedConstraints><com.vmware.data.query.PropertyConstraint><propertyName>childType</propertyName><comparator>CONTAINS</comparator><comparableValue><String>$folderType</String></comparableValue></com.vmware.data.query.PropertyConstraint></nestedConstraints><conjoiner>AND</conjoiner></com.vmware.data.query.CompositeConstraint></propertyConditions>");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.HostSystem", "vsphere.core.host.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.Cluster", "vsphere.core.cluster.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.Datacenter", "vsphere.core.datacenter.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.DatacenterFolder", "vsphere.core.folder.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.Datastore", "vsphere.core.datastore.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.DatastoreFolder", "vsphere.core.folder.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.DistributedVirtualSwitch", "vsphere.core.dvs.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.Host", "vsphere.core.host.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.ComputeResourceFolder", "vsphere.core.folder.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.Network", "vsphere.core.network.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.NetworkFolder", "vsphere.core.folder.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.ResourcePool", "vsphere.core.rp.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.Template", "vsphere.core.template.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.VirtualMachine", "vsphere.core.vm.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.VirtualMachineFolder", "vsphere.core.folder.legacyViews");
        this.extensionPtByLegacyExtensionPt.put("InventoryView.VirtualApp", "vsphere.core.vApp.legacyViews");
    }

    public void processXml(Document document, VcService vcService, File file, File file2, ScriptPluginService scriptPluginService, String string) throws Exception {
        this._scriptPluginService = scriptPluginService;
        this._plugin = new FileWriter(file);
        this._pluginPackageFile = new FileWriter(file2);
        this._vcService = vcService;
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("scriptConfiguration");
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        String string2 = ScriptPluginUtil.getNodeFromDoc(document, "key");
        String string3 = ScriptPluginUtil.getNodeFromDoc(document, "description");
        String string4 = ScriptPluginUtil.getNodeFromDoc(document, "multiVCsupported");
        if (string4 == null) {
            string4 = "false";
        }
        String string5 = element.getAttributeNode("version").getNodeValue();
        this.createPluginPackageFile(string2, string5, string3, document);
        this._plugin.write("<?xml version='1.0'?>");
        this._plugin.write("<plugin id='" + string2 + "'>");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("extension")) continue;
            Element element2 = (Element)node;
            String string6 = element2.getAttributeNode("parent").getNodeValue();
            if (element2.hasAttribute("treestyle")) {
                _logger.warn((Object)("treeStyle attribute ignored in extension point: " + string6 + ", found in script plugin: " + string));
            }
            if (string6.split("\\.").length <= 0) {
                ScriptPluginUtil.logInvalidExtension(string6, string);
                continue;
            }
            String string7 = string6.split("\\.")[0];
            String string8 = string6.split("\\.")[1];
            string8 = PluginConstants.getLegacyType(string8);
            NodeList nodeList3 = element2.getElementsByTagName("url");
            Element element3 = (Element)nodeList3.item(0);
            String string9 = ScriptPluginUtil.getNodeValue(element2, "url");
            String string10 = "browser";
            if (element3.hasAttribute("display")) {
                string10 = element3.getAttributeNode("display").getNodeValue();
            }
            if (string7.equals("InventoryMenus")) {
                this.addToInventoryMenusList(string2, i, string3, element2, node, string8, string10);
            } else {
                if (string7.equals("Toolbars")) {
                    _logger.warn((Object)("The toolbar extension found in script plugin " + string + " is not supported in vSphere Web Client!"));
                    continue;
                }
                if (string7.equals("HomeView")) {
                    this.processHomeView(string2, i, element2, string9, string4);
                } else if (string7.equals("MainMenus")) {
                    this.processMainMenu(string2, i, string8, element2, node, string8, true);
                } else if (string7.equals("InventoryView")) {
                    this.processInventoryView(string9, i, string2, element2, string4);
                } else {
                    ScriptPluginUtil.logInvalidExtension(string6, string);
                    continue;
                }
            }
            if (string7.equals("InventoryMenus")) continue;
            this.processMetaData(node.getChildNodes(), string7, string8, element2);
        }
        this.processInventoryMenus(string2, string3);
        this._plugin.append("</plugin>");
        this._plugin.close();
        this._uniqueIdentifier = 0.0;
    }

    private void addActionSets(Node node, String string, Element element, String string2, String string3, String string4) throws IOException {
        ScriptPluginUtil.ActionSetInfo actionSetInfo = null;
        for (int i = 0; i < this._actionSetInfos.size(); ++i) {
            this._uniqueIdentifier += 1.0;
            this._plugin.append("<extension id='" + string3 + "." + this._uniqueIdentifier + ".actionSets'>");
            this._plugin.append("<extendedPoint>vise.actions.sets</extendedPoint>");
            this._plugin.append("<object><actions>");
            actionSetInfo = this._actionSetInfos.get(i);
            this.createActionSet(actionSetInfo.uid, actionSetInfo.url, actionSetInfo.label, actionSetInfo.display, "true");
            this._plugin.append("</actions></object>");
            this.processMetaData(actionSetInfo.node.getChildNodes(), string2, string, actionSetInfo.element);
            this._plugin.append("</extension>");
        }
        this._actionSetInfos.clear();
    }

    private void createPluginPackageFile(String string, String string2, String string3, Document document) throws IOException {
        String string4 = "";
        String string5 = "";
        if (ScriptPluginUtil.getNodeFromDoc(document, "vendor") != null) {
            string4 = ScriptPluginUtil.getNodeFromDoc(document, "vendor");
        }
        if (ScriptPluginUtil.getNodeFromDoc(document, "name") != null) {
            string5 = ScriptPluginUtil.getNodeFromDoc(document, "name");
        }
        if (string5 == null || string5.length() == 0) {
            string5 = string;
        }
        String string6 = this.convertXml("plugin-package");
        string6 = ScriptPluginUtil.replace(string6, "$id", string);
        string6 = ScriptPluginUtil.replace(string6, "$version", string2);
        string6 = ScriptPluginUtil.replace(string6, "$description", string3);
        string6 = ScriptPluginUtil.replace(string6, "$vendor", string4);
        string6 = ScriptPluginUtil.replace(string6, "$name", string5);
        this._pluginPackageFile.write(string6);
        this._pluginPackageFile.close();
    }

    private void processInventoryView(String string, int n, String string2, Element element, String string3) throws IOException {
        String string4 = ScriptPluginUtil.getNodeValue(element, "title");
        String string5 = this.convertXml("InventoryView");
        String string6 = ScriptPluginUtil.generateUrl(string, this._vcService);
        string5 = ScriptPluginUtil.replace(string5, "$url", string6);
        this._uniqueIdentifier += 1.0;
        String string7 = ScriptPluginUtil.createUniqueKey(null, this._uniqueIdentifier, string2);
        string5 = ScriptPluginUtil.replace(string5, "$id", string7);
        string5 = ScriptPluginUtil.replace(string5, "$extensionId", string7);
        string5 = ScriptPluginUtil.replace(string5, "$name", string4);
        string5 = ScriptPluginUtil.replace(string5, "$multiVCsupported", "true");
        String string8 = this.convertExtensionPoint(element.getAttributeNode("parent").getNodeValue());
        string5 = ScriptPluginUtil.replace(string5, "$extensionPoint", string8);
        ScriptPluginUtil.createExtensionToUrlMap(this._scriptPluginService, this._vcService, string7, string6);
        this._plugin.append(string5);
    }

    private void processHomeView(String string, int n, Element element, String string2, String string3) throws IOException {
        String string4 = ScriptPluginUtil.getEnglishTitle(element);
        String string5 = this.convertXml("HomeView");
        this._uniqueIdentifier += 1.0;
        String string6 = ScriptPluginUtil.createUniqueKey(null, this._uniqueIdentifier, string);
        string5 = ScriptPluginUtil.replace(string5, "$id", string6);
        string5 = ScriptPluginUtil.replace(string5, "$extensionId", string6);
        string5 = ScriptPluginUtil.replace(string5, "$name", string4);
        string5 = ScriptPluginUtil.replace(string5, "$multiVCsupported", string3);
        String string7 = ScriptPluginUtil.generateUrl(string2, this._vcService);
        string5 = ScriptPluginUtil.replace(string5, "$url", string7);
        ScriptPluginUtil.createExtensionToUrlMap(this._scriptPluginService, this._vcService, string6, string7);
        this._plugin.append(string5);
    }

    private void processMetaData(NodeList nodeList, String string, String string2, Element element) throws IOException {
        if ((nodeList != null && nodeList.getLength() != 0 || element.getAttributeNode("privilege") != null || string.equals("InventoryMenus")) && !string.equals("Toolbars") && !string.equals("MainMenus")) {
            this._plugin.append("<metadata>");
            if (PluginConstants.folderTypeContains(string2)) {
                String string3 = this.convertXml("Folder");
                string3 = ScriptPluginUtil.replace(string3, "$folderType", PluginConstants.getFolderType(string2));
                this._plugin.append(string3);
            }
            if (string.equals("InventoryMenus") && !PluginConstants.folderTypeContains(string2)) {
                this._plugin.append("<objectType>" + string2 + "</objectType>");
            }
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (!nodeList.item(i).getNodeName().equals("customAttribute")) continue;
                    String string4 = ScriptPluginUtil.getNodeValue(element, "customAttribute");
                    String string5 = nodeList.item(i).getNodeName();
                    String string6 = ((Element)nodeList.item(i)).getAttributeNode("name").getNodeValue();
                    this._plugin.append(this.getCustomAttributeMetadata(string5, string6, string4));
                    break;
                }
            }
            if (element.getAttributeNode("privilege") != null) {
                this._plugin.append("<privilege>" + element.getAttributeNode("privilege").getNodeValue() + "</privilege>");
            }
            this._plugin.append("</metadata>");
            if (string.equals("HomeView") || string.equals("InventoryView")) {
                this._plugin.append("</extension>");
            }
        }
    }

    private void processInventoryMenus(String string, String string2) throws IOException {
        int n = 0;
        for (Map.Entry<String, ArrayList<ScriptPluginUtil.InventoryMenuInfo>> entry : this.inventoryMenus.entrySet()) {
            int n2;
            String string3 = entry.getKey();
            ArrayList<ScriptPluginUtil.InventoryMenuInfo> arrayList = entry.getValue();
            this._uniqueIdentifier += 1.0;
            String string4 = ScriptPluginUtil.createUniqueKey(null, this._uniqueIdentifier, string);
            this._plugin.append("<extension id='" + string4 + "'>\n");
            this._plugin.append("<extendedPoint>vsphere.core.menus.solutionMenus</extendedPoint>\n");
            this._plugin.append("<object><label>" + string2 + "</label>\n");
            this._plugin.append("<uid>com.vmware.scriptPlugins.inventoryMenus." + string + "." + n + "</uid><children><Array>\n");
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                String string5 = ScriptPluginUtil.getEnglishTitle(arrayList.get((int)n2).element);
                this._uniqueIdentifier += 1.0;
                this.processNestedMenus("com.vmware.plugins." + string5.replaceAll(" ", "") + this._uniqueIdentifier, string5, arrayList.get((int)n2).node);
            }
            this._plugin.append("</Array></children>\n");
            this._plugin.append("</object>\n");
            this._plugin.append("<metadata>");
            if (PluginConstants.folderTypeContains(string3)) {
                String string6 = this.convertXml("Folder");
                string6 = ScriptPluginUtil.replace(string6, "$folderType", PluginConstants.getFolderType(string3));
                this._plugin.append(string6);
            }
            if (!PluginConstants.folderTypeContains(string3)) {
                this._plugin.append("<objectType>" + string3 + "</objectType>");
            }
            this._plugin.append("</metadata>");
            this._plugin.append("</extension>");
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.addActionSets(arrayList.get((int)n2).node, string3, arrayList.get((int)n2).element, "InventoryMenus", arrayList.get((int)n2).key, arrayList.get((int)n2).display);
            }
            ++n;
        }
    }

    private void addToInventoryMenusList(String string, int n, String string2, Element element, Node node, String string3, String string4) throws IOException {
        ScriptPluginUtil.InventoryMenuInfo inventoryMenuInfo = new ScriptPluginUtil.InventoryMenuInfo();
        inventoryMenuInfo.element = element;
        inventoryMenuInfo.key = string;
        inventoryMenuInfo.node = node;
        inventoryMenuInfo.display = string4;
        if (this.inventoryMenus.containsKey(string3)) {
            ArrayList<ScriptPluginUtil.InventoryMenuInfo> arrayList = this.inventoryMenus.get(string3);
            arrayList.add(inventoryMenuInfo);
        } else {
            ArrayList<ScriptPluginUtil.InventoryMenuInfo> arrayList = new ArrayList<ScriptPluginUtil.InventoryMenuInfo>();
            arrayList.add(inventoryMenuInfo);
            this.inventoryMenus.put(string3, arrayList);
        }
    }

    private void createActionSet(String string, String string2, String string3, String string4, String string5) throws IOException {
        this._plugin.append("<com.vmware.actionsfw.ActionSpec>");
        this._plugin.append("<uid>" + string + "</uid>\n");
        this._plugin.append("<label>" + string3 + "</label>");
        this._plugin.append("<delegate><className>com.vmware.vsphere.client.commands.ScriptPluginActionDelegate</className><object><root><scriptUrl>");
        this._plugin.append(string2);
        this._plugin.append("</scriptUrl><useContextObject>");
        this._plugin.append(string5);
        this._plugin.append("</useContextObject><display>");
        this._plugin.append(string4);
        this._plugin.append("</display></root></object>");
        this._plugin.append("</delegate>");
        this._plugin.append("</com.vmware.actionsfw.ActionSpec>");
    }

    private void processMainMenu(String string, int n, String string2, Element element, Node node, String string3, boolean bl) throws IOException {
        int n2;
        boolean bl2 = false;
        NodeList nodeList = node.getChildNodes();
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            if (!nodeList.item(n2).getNodeName().equals("extension")) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                if (!nodeList.item(n2).getNodeName().equals("extension")) continue;
                Element element2 = (Element)nodeList.item(n2);
                String string4 = ScriptPluginUtil.getEnglishTitle(element2);
                this.processMainMenu(string, n2, string2 + " &gt; " + string4, element2, nodeList.item(n2), string3, false);
            }
        } else {
            NodeList nodeList2 = element.getElementsByTagName("url");
            Element element3 = (Element)nodeList2.item(0);
            String string5 = "browser";
            if (element3.hasAttribute("display")) {
                string5 = element3.getAttributeNode("display").getNodeValue();
            }
            String string6 = ScriptPluginUtil.getNodeValue(element, "url");
            String string7 = this.xml.get("MainMenus");
            this._uniqueIdentifier += 1.0;
            String string8 = ScriptPluginUtil.createUniqueKey("com.vmware.plugin.mainMenus", this._uniqueIdentifier, string);
            string7 = ScriptPluginUtil.replace(string7, "$id", string8);
            string7 = ScriptPluginUtil.replace(string7, "$uid", ScriptPluginUtil.createUniqueKey("com.vmware.plugin.mainMenu.actions", n, string));
            String string9 = ScriptPluginUtil.getEnglishTitle(element);
            ScriptPluginUtil.createExtensionToUrlMap(this._scriptPluginService, this._vcService, string8, string6);
            if (bl) {
                string2 = string2 + " &gt; " + string9;
            }
            if (string2.length() > 60) {
                string2 = string3 + " &gt; " + string9;
            }
            string7 = ScriptPluginUtil.replace(string7, "$label", string2);
            string7 = ScriptPluginUtil.replace(string7, "$url", string6);
            string7 = ScriptPluginUtil.replace(string7, "$display", string5);
            this._plugin.append(string7);
        }
    }

    private void processNestedMenus(String string, String string2, Node node) throws IOException {
        int n;
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        this._plugin.append("<com.vmware.actionsfw.ActionMenuItemSpec>");
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!nodeList.item(n).getNodeName().equals("extension")) continue;
            bl = true;
            break;
        }
        if (bl) {
            this._plugin.append("<label>" + string2 + "</label>\n");
            this._plugin.append("<uid>" + string + "</uid>\n");
            this._plugin.append("<children><Array>\n");
            for (n = 0; n < nodeList.getLength(); ++n) {
                if (!nodeList.item(n).getNodeName().equals("extension")) continue;
                Element element = (Element)nodeList.item(n);
                String string3 = ScriptPluginUtil.getEnglishTitle(element);
                this._uniqueIdentifier += 1.0;
                this.processNestedMenus("com.vmware.plugins." + string3.replaceAll(" ", "") + this._uniqueIdentifier, string3, nodeList.item(n));
            }
            this._plugin.append("</Array></children>");
        } else {
            this._plugin.append("<type>action</type>\n");
            this._plugin.append("<label>" + string2 + "</label>\n");
            this._plugin.append("<uid>" + string + "</uid>\n");
            Element element = (Element)node;
            String string4 = ScriptPluginUtil.getNodeValue(element, "url");
            NodeList nodeList2 = element.getElementsByTagName("url");
            Element element2 = (Element)nodeList2.item(0);
            String string5 = "browser";
            if (element2.hasAttribute("display")) {
                string5 = element2.getAttributeNode("display").getNodeValue();
            }
            ScriptPluginUtil.createExtensionToUrlMap(this._scriptPluginService, this._vcService, string, string4);
            ScriptPluginUtil.ActionSetInfo actionSetInfo = new ScriptPluginUtil.ActionSetInfo();
            actionSetInfo.uid = string;
            actionSetInfo.url = string4;
            actionSetInfo.display = string5;
            actionSetInfo.label = string2;
            actionSetInfo.node = node;
            actionSetInfo.element = element;
            this._actionSetInfos.add(actionSetInfo);
        }
        this._plugin.append("</com.vmware.actionsfw.ActionMenuItemSpec>");
    }

    private String convertXml(String string) {
        return this.xml.get(string);
    }

    private String convertExtensionPoint(String string) {
        return this.extensionPtByLegacyExtensionPt.get(string);
    }

    private String getCustomAttributeMetadata(String string, String string2, String string3) {
        return "<attributeKey>" + string2 + "</attributeKey><attributeValue>" + string3 + "</attributeValue>";
    }
}

