/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension;

import com.vmware.vim.binding.vim.Description;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PluginSignatureService;
import com.vmware.vise.extensionfw.signing.PluginSignatureException;
import com.vmware.vise.extensionfw.signing.PluginSignatureGeneralException;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.ZipUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.extension.VcPluginPackageManager;
import com.vmware.vise.vim.extension.util.VcExtensionUtil;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.vsphere.internal.Config;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;

public class VcExtensionManager
extends VcPluginPackageManager
implements ExtensionListener {
    private static final String POOL_NAME = "vc-extensionmanager-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)30, (ThreadFactory)new WorkerThreadFactory("vc-extensionmanager-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private static final String METADATA_KEY_SERVER_GUIDS = "vcServerGuids";
    private static final long DEFAULT_DEPLOYMENT_TIMEOUT_MINUTES = 10L;
    protected static final String DEPLOYMENT_TIMEOUT_PROP_NAME = "newPlugins.deployTimeout";
    protected static final String RETRY_PLUGIN_DEPLOYMENT_ENABLED_PROP = "newPlugins.retryFailedPluginDeployment.enabled";
    protected static final String INCOMPLETE_STATUS_FILE_NAME = ".incomplete";
    protected ExtensionService _extensionService;
    protected String _localExtensionType;
    protected String _remoteExtensionType;
    protected ConfigurationService _configurationService;
    protected SSLConfigurationProvider _sslConfigurationProvider;
    protected PluginSignatureService _pluginSignatureService;
    private final CopyOnWriteArraySet<IdVersionPair> _packageRefs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IdVersionPair> _allPackageRefs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IdVersionPair> _downloadFailedPackageRefs = new CopyOnWriteArraySet();
    private final boolean _deployRemotePlugins;
    private final boolean _retryFailedPluginPackages;

    public VcExtensionManager(@Nonnull ExtensionService extensionService, @Nonnull String string, @Nonnull String string2, @Nonnull ConfigurationService configurationService, @Nonnull FeatureStateService featureStateService, @Nonnull VcSource vcSource, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nonnull VcServiceCompatibilityChecker vcServiceCompatibilityChecker, @Nonnull PluginSignatureService pluginSignatureService) {
        super(vcSource, vcServiceCompatibilityChecker, sSLConfigurationProvider);
        ValidationUtil.notNull((Object)extensionService, (String)"extensionService is null");
        ValidationUtil.notNull((Object)string, (String)"localExtensionType is null");
        ValidationUtil.notNull((Object)string2, (String)"remoteExtensionType is null");
        ValidationUtil.notNull((Object)configurationService, (String)"configurationService is null");
        ValidationUtil.notNull((Object)featureStateService, (String)"featureStateService is null");
        ValidationUtil.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null");
        ValidationUtil.notNull((Object)pluginSignatureService, (String)"pluginSignatureService is null");
        this._extensionService = extensionService;
        this._localExtensionType = string;
        this._remoteExtensionType = string2;
        this._configurationService = configurationService;
        this._deployRemotePlugins = featureStateService.isEnabled(Feature.h5uiRemotePlugins);
        this._sslConfigurationProvider = sSLConfigurationProvider;
        this._pluginSignatureService = pluginSignatureService;
        this._retryFailedPluginPackages = Boolean.parseBoolean(configurationService.getProperty(RETRY_PLUGIN_DEPLOYMENT_ENABLED_PROP));
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (!pluginPackageEvent.getType().equals("pluginPackageUndeployed")) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageEvent.getPluginPackageInfos()) {
            this.packageUndeployed(pluginPackageInfo.getPackageRef());
        }
    }

    protected boolean isPackageAlreadyDeployed(IdVersionPair idVersionPair) {
        try {
            return this._packageRefs.contains(idVersionPair) || this._extensionService.getPluginPackageInfo(idVersionPair) != null;
        }
        catch (Exception exception) {
            this._logger.error((Object)("Could not get the plugin package info for " + idVersionPair), (Throwable)exception);
            return false;
        }
    }

    protected List<VcPackageInfo> getVcPackages(ExtensionManager extensionManager) {
        ArrayList<VcPackageInfo> arrayList = new ArrayList<VcPackageInfo>();
        Extension[] extensionArray = extensionManager.getExtensionList();
        if (extensionArray == null) {
            return arrayList;
        }
        for (Extension extension : extensionArray) {
            VcPackageInfo vcPackageInfo = this.getVcPackageInfo(extension);
            if (vcPackageInfo == null) continue;
            arrayList.add(vcPackageInfo);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Set<IdVersionPair> addPackages(Collection<? extends VcService> collection) {
        void var7_12;
        ExecutorUtil.TaskResult taskResult;
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        VcService[] vcServiceArray = new VcService[collection.size()];
        ArrayList<1> arrayList = new ArrayList<1>();
        int n = 0;
        for (final VcService vcService : collection) {
            taskResult = new Callable<List<VcPackageInfo>>(){

                @Override
                public List<VcPackageInfo> call() {
                    if (VcExtensionManager.this._logger.isDebugEnabled()) {
                        VcExtensionManager.this._logger.debug((Object)("Checking for new plugin packages in VC " + vcService.getServiceUrl()));
                    }
                    return VcExtensionManager.this.getVcPackages(vcService);
                }

                public String toString() {
                    return "getVcPackages:" + vcService.getServiceUrl();
                }
            };
            vcServiceArray[n++] = vcService;
            arrayList.add(taskResult);
        }
        Object object = null;
        try {
            object = ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR, (long)30L, (TimeUnit)TimeUnit.SECONDS, (boolean)true);
        }
        catch (InterruptedException interruptedException) {
            this._logger.error((Object)"The thread was interrupted while retrieving extensions", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
            return hashSet;
        }
        catch (TimeoutException timeoutException) {
            this._logger.error((Object)"Retrieving all the VC extensions timed out. Proceeding with installing the extensions that were retrieved on time", (Throwable)timeoutException);
        }
        boolean bl = false;
        while (var7_12 < vcServiceArray.length) {
            taskResult = (ExecutorUtil.TaskResult)object.get((int)var7_12);
            Exception exception = taskResult.getException();
            if (exception != null) {
                this._logger.error((Object)("Retrieving vc packages for VC " + vcServiceArray[var7_12].getServiceUrl() + " failed"), (Throwable)exception);
            } else {
                List list = (List)taskResult.getResult();
                if (list != null) {
                    Set<IdVersionPair> set = this.addPackages(list, vcServiceArray[var7_12], true);
                    hashSet.addAll(set);
                }
            }
            ++var7_12;
        }
        return hashSet;
    }

    private List<VcPackageInfo> getVcPackages(VcService vcService) {
        List<VcPackageInfo> list = this.getLocalVcPackages(vcService.getServiceGuid());
        if (list != null) {
            return list;
        }
        try {
            ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().extensionManager;
            ExtensionManager extensionManager = (ExtensionManager)vcService.getManagedObject(managedObjectReference);
            list = this.getVcPackages(extensionManager);
        }
        catch (Exception exception) {
            list = new ArrayList<VcPackageInfo>();
            this._logger.error((Object)"Couldn't retrieve ExtensionManager: ", (Throwable)exception);
        }
        return list;
    }

    private VcPackageInfo getVcPackageInfo(Extension extension) {
        Object object2;
        Extension.ClientInfo[] clientInfoArray = extension.client;
        if (clientInfoArray == null) {
            return null;
        }
        Extension.ClientInfo clientInfo = null;
        boolean bl = false;
        for (Object object2 : clientInfoArray) {
            if (this._localExtensionType.equals(object2.type)) {
                clientInfo = object2;
                break;
            }
            if (!this._deployRemotePlugins || !this._remoteExtensionType.equals(object2.type)) continue;
            clientInfo = object2;
            bl = true;
            break;
        }
        if (clientInfo == null) {
            return null;
        }
        String string2 = extension.getKey();
        string2 = VcExtensionUtil.filterExtensionSpecificContent((String)string2);
        String string3 = clientInfo.getVersion();
        String string4 = clientInfo.getUrl();
        if (StringUtil.isNullOrEmpty((String)string2) || StringUtil.isNullOrEmpty((String)string3) || StringUtil.isNullOrEmpty((String)string4)) {
            this._logger.error((Object)("Invalid VC extension data, none of these attributes can be null:\n   Extension.key = " + string2 + "\n   Extension.ClientInfo.version = " + string3 + "\n   Extension.ClientInfo.url = " + string4));
            return null;
        }
        object2 = new VcPackageInfo();
        object2.setId(string2);
        object2.setVersion(string3);
        Description description = clientInfo.getDescription();
        if (description != null) {
            object2.setName(description.getLabel());
            object2.setDescription(description.getSummary());
        }
        object2.setVendor(clientInfo.getCompany());
        object2.url = string4;
        object2.setSslThumbprints(this.getExtensionServerThumbprints(extension));
        object2.setRemotePlugin(bl);
        return object2;
    }

    private String[] getExtensionServerThumbprints(Extension extension) {
        HashSet<String> hashSet = new HashSet<String>();
        Extension.ServerInfo[] serverInfoArray = extension.server;
        if (serverInfoArray != null) {
            for (Extension.ServerInfo serverInfo : serverInfoArray) {
                String string = serverInfo.getServerThumbprint();
                if (string == null) continue;
                hashSet.add(string);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    protected Set<IdVersionPair> addPackages(Collection<VcPackageInfo> collection, VcService vcService, boolean bl) {
        Object object;
        Object object3;
        HashMap<IdVersionPair, String> hashMap = new HashMap<IdVersionPair, String>();
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>(collection.size());
        ArrayList<DownloadContext> arrayList = new ArrayList<DownloadContext>();
        ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().eventManager;
        EventManager eventManager = (EventManager)vcService.getManagedObject(managedObjectReference);
        HashSet<IdVersionPair> hashSet2 = new HashSet<IdVersionPair>(collection.size());
        for (VcPackageInfo vcPackageInfo : collection) {
            object3 = vcPackageInfo.getPackageRef();
            hashMap.put((IdVersionPair)object3, vcPackageInfo.url);
            try {
                if (this.isPackageAlreadyDeployed((IdVersionPair)object3)) {
                    if (!bl) {
                        hashSet.add((IdVersionPair)object3);
                    }
                    hashSet2.add((IdVersionPair)object3);
                    continue;
                }
                if (!this.shouldDeployPackage((IdVersionPair)object3)) continue;
                SessionUtil.ThreadContext exception = SessionUtil.getThreadContext((boolean)true);
                Callable<Set<IdVersionPair>> callable = this.createDeployPluginPackageTask(eventManager, vcPackageInfo, (IdVersionPair)object3, exception);
                object = EXECUTOR.submit(callable);
                arrayList.add(new DownloadContext(vcPackageInfo, (Future<Set<IdVersionPair>>)object));
            }
            catch (Exception exception) {
                this._logger.error((Object)("Adding VC extension " + object3 + " failed"), (Throwable)exception);
                this.postVcEvent(eventManager, Event.EventSeverity.error, "PluginDeployment.failure", vcPackageInfo.getName(), vcPackageInfo.getVersion(), exception.getMessage());
            }
        }
        long l = this.getPluginDeployTimeout();
        for (DownloadContext downloadContext : arrayList) {
            String string = downloadContext.packageInfo.getName();
            object = downloadContext.packageInfo.getVersion();
            try {
                this.postVcEvent(eventManager, Event.EventSeverity.info, "PluginDeployment.started", string, object);
                Set set = (Set)BlockingUtil.get(downloadContext.future, (long)l, (TimeUnit)TimeUnit.MINUTES);
                this.postVcEvent(eventManager, Event.EventSeverity.info, "PluginDeployment.success", string, object);
                hashSet.addAll(set);
                hashSet2.addAll(set);
            }
            catch (Exception exception) {
                String string2 = exception instanceof TimeoutException ? String.format("Timeout (%d mns) while downloading or deploying package %s from %s. Check the URL and network if the download could not complete in time, check your initialization code if bundles are too slow to deploy.", l, downloadContext.packageInfo.getId(), downloadContext.packageInfo.url) : String.format("Error while downloading or deploying package %s from %s, check the URL and the root exception.", downloadContext.packageInfo.getId(), downloadContext.packageInfo.url);
                this.postVcEvent(eventManager, Event.EventSeverity.error, "PluginDeployment.failure", string, object, exception.getMessage());
                this._logger.error((Object)string2, (Throwable)exception);
            }
        }
        object3 = vcService.getServiceGuid();
        for (IdVersionPair idVersionPair : hashSet2) {
            object = (String)hashMap.get(idVersionPair);
            this.updatePackageMetadata(idVersionPair, (String)object3, (String)object);
        }
        this._packageRefs.addAll(hashSet);
        return hashSet;
    }

    private boolean shouldDeployPackage(IdVersionPair idVersionPair) {
        boolean bl = this._allPackageRefs.add(idVersionPair);
        if (!bl && this._downloadFailedPackageRefs.contains(idVersionPair)) {
            bl = this._retryFailedPluginPackages;
        }
        return bl;
    }

    protected Callable<Set<IdVersionPair>> createDeployPluginPackageTask(final EventManager eventManager, final VcPackageInfo vcPackageInfo, final IdVersionPair idVersionPair, final SessionUtil.ThreadContext threadContext) {
        return new Callable<Set<IdVersionPair>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<IdVersionPair> call() throws Exception {
                SessionUtil.ThreadContext threadContext2 = SessionUtil.getThreadContext((boolean)false);
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                try {
                    Thread.currentThread().setPriority(1);
                    Thread.currentThread().setContextClassLoader(ExtensionService.class.getClassLoader());
                    File file = VcExtensionManager.this.downloadPackage(vcPackageInfo);
                    if (file == null) {
                        VcExtensionManager.this._downloadFailedPackageRefs.add(idVersionPair);
                        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
                        return hashSet;
                    }
                    VcExtensionManager.this._downloadFailedPackageRefs.remove(idVersionPair);
                    vcPackageInfo.setDirectory(file);
                    try {
                        Set set = VcExtensionManager.this._extensionService.addPluginPackages(new PluginPackageInfo[]{vcPackageInfo});
                        return set;
                    }
                    catch (Exception exception) {
                        VcExtensionManager.this._logger.error((Object)("Adding VC extension " + idVersionPair + " failed"), (Throwable)exception);
                        VcExtensionManager.this.postVcEvent(eventManager, Event.EventSeverity.error, "PluginDeployment.failure", new Object[]{vcPackageInfo.getName(), vcPackageInfo.getVersion(), exception.getMessage()});
                        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
                        SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext2);
                        return hashSet;
                    }
                }
                finally {
                    SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext2);
                }
            }

            public String toString() {
                return "DownloadPackage:" + vcPackageInfo.url;
            }
        };
    }

    private void postVcEvent(EventManager eventManager, Event.EventSeverity eventSeverity, String string, Object ... objectArray) {
        Event event = this.createDynamicEvent(eventSeverity, string, objectArray);
        try {
            eventManager.postEvent(event, null);
        }
        catch (NoPermission noPermission) {
        }
        catch (Exception exception) {
            this._logger.error((Object)("Failed to post event " + event), (Throwable)exception);
        }
    }

    private Event createDynamicEvent(Event.EventSeverity eventSeverity, String string, Object ... objectArray) {
        String string2;
        EventEx eventEx = new EventEx();
        eventEx.chainId = 0;
        eventEx.createdTime = Calendar.getInstance();
        eventEx.key = 0;
        eventEx.userName = VimServicesVsphereUtil.getLocalizedString("System.userName");
        String string3 = VimServicesVsphereUtil.getLocalizedString(string);
        eventEx.eventTypeId = string2 = String.format(string3, objectArray);
        eventEx.fullFormattedMessage = string2;
        eventEx.severity = eventSeverity.name();
        return eventEx;
    }

    private void updatePackageMetadata(IdVersionPair idVersionPair, String string, String string2) {
        PluginPackageInfo pluginPackageInfo;
        try {
            pluginPackageInfo = this._extensionService.getPluginPackageInfo(idVersionPair);
        }
        catch (Exception exception) {
            this._logger.error((Object)("ExtensionService.getPluginPackageInfo for " + idVersionPair + " failed"), (Throwable)exception);
            return;
        }
        if (pluginPackageInfo == null) {
            return;
        }
        ConcurrentMap concurrentMap = pluginPackageInfo.getMetadata();
        this.updateServerGuids(string, concurrentMap);
        this.updateRegistrationUrls(idVersionPair, string, string2, concurrentMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerGuids(String string, ConcurrentMap<String, Object> concurrentMap) {
        ConcurrentMap<String, Object> concurrentMap2 = concurrentMap;
        synchronized (concurrentMap2) {
            HashSet<Object> hashSet;
            String[] stringArray = (String[])concurrentMap.get(METADATA_KEY_SERVER_GUIDS);
            if (stringArray != null) {
                hashSet = new HashSet<String>(Arrays.asList(stringArray));
                if (hashSet.contains(string)) {
                    return;
                }
            } else {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
            concurrentMap.put(METADATA_KEY_SERVER_GUIDS, hashSet.toArray(new String[0]));
        }
    }

    private void updateRegistrationUrls(IdVersionPair idVersionPair, String string, String string2, ConcurrentMap<String, Object> concurrentMap) {
        String string3;
        try {
            string3 = VcExtensionManager.extractBaseUrl(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this._logger.warn((Object)String.format("Could not determine the base URL for the instance of %s serving VC %s.", idVersionPair, string));
            return;
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> concurrentHashMap2 = concurrentMap.putIfAbsent("pluginRegistrationUrlByServer", concurrentHashMap);
        if (concurrentHashMap2 == null) {
            concurrentHashMap2 = concurrentHashMap;
        }
        concurrentHashMap2.put(string, string3);
    }

    public static String extractBaseUrl(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        String string2 = uRL.getPath();
        int n = string2.lastIndexOf(47);
        String string3 = n == -1 ? string2 : string2.substring(0, n);
        return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadPackage(VcPackageInfo vcPackageInfo) {
        IdVersionPair idVersionPair = vcPackageInfo.getPackageRef();
        String string = this.getPackageDirName(idVersionPair);
        File file = this.getPackageDir(string);
        File file2 = new File(file, INCOMPLETE_STATUS_FILE_NAME);
        if (file2.exists()) {
            this._logger.info((Object)"Found invalid cached plugin package. Will retry the download.");
            FileUtil.deleteDir((File)file);
        } else if (file.isDirectory()) {
            if (!vcPackageInfo.isRemotePlugin()) {
                String string2 = string + ".zip";
                this.performPluginSignatureCheckIfNecessary(vcPackageInfo, new File(file, string2));
            }
            return file;
        }
        File file3 = null;
        try {
            file3 = File.createTempFile("vmw-pckg", ".tmp");
        }
        catch (IOException iOException) {
            String string3 = System.getProperty("java.io.tmpdir");
            String string4 = String.format("Error creating temporary file %s/vmw-pckg*.tmp, while downloading %s.", string3, vcPackageInfo.url);
            this._logger.error((Object)string4, (Throwable)iOException);
            return null;
        }
        try {
            this._logger.debug((Object)("Start writePackageToFile : " + vcPackageInfo.getId()));
            this.writePackageToFile(vcPackageInfo, file3);
        }
        catch (IOException iOException) {
            String string5 = String.format("Package %s was not installed. Error downloading %s. Make sure that the URL is reachable then logout/login to force another download.", vcPackageInfo.getId(), vcPackageInfo.url);
            file3.delete();
            if (this._logger.isDebugEnabled()) {
                this._logger.warn((Object)string5, (Throwable)iOException);
            } else {
                this._logger.warn((Object)string5);
            }
            return null;
        }
        try {
            FileUtil.writeTextFile((File)file2, (String)"");
        }
        catch (IOException iOException) {
            this._logger.warn((Object)("Failed to create the plugin download status file" + file2.getPath()));
        }
        if (vcPackageInfo.isRemotePlugin()) {
            Path path = Paths.get(file.getAbsolutePath(), "plugin.xml");
            try {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)String.format("Moving %s to %s.", file3, path));
                }
                Files.move(file3.toPath(), path, new CopyOption[0]);
                this._logger.info((Object)String.format("%s copied to %s.", file3, path));
            }
            catch (IOException iOException) {
                String string6 = String.format("Package %s was not installed. Error error copying %s to %s. Make sure the user running the service has write privileges for the parent directory then logout/login to force another download.", vcPackageInfo.getId(), file3, path);
                this._logger.error((Object)string6, (Throwable)iOException);
                FileUtil.deleteDir((File)file);
                file3.delete();
                return null;
            }
        }
        this.performPluginSignatureCheckIfNecessary(vcPackageInfo, file3);
        this.copyZipLocally(file3, file, idVersionPair);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file3);
            ZipUtil.unzip((ZipFile)zipFile, (File)file);
        }
        catch (IOException iOException) {
            File file4;
            try {
                String string7 = String.format("Package %s was not installed. Error expanding zip file found at %s. Make sure it is a valid zip file then logout/login to force another download.", vcPackageInfo.getId(), vcPackageInfo.url);
                this._logger.error((Object)string7, (Throwable)iOException);
                FileUtil.deleteDir((File)file);
                file4 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.close(zipFile);
                if (file3 != null) {
                    file3.delete();
                }
                throw throwable;
            }
            StreamUtil.close((ZipFile)zipFile);
            if (file3 != null) {
                file3.delete();
            }
            return file4;
        }
        StreamUtil.close((ZipFile)zipFile);
        if (file3 != null) {
            file3.delete();
        }
        this._logger.info((Object)("Done expanding plugin package to " + file.getAbsolutePath()));
        file2.delete();
        return file;
    }

    private void copyZipLocally(File file, File file2, IdVersionPair idVersionPair) {
        Path path = file.toPath();
        Path path2 = file2.toPath();
        String string = this.getPackageDirName(idVersionPair) + ".zip";
        Path path3 = Paths.get(path2.toString(), string);
        try {
            Files.copy(path, path3, new CopyOption[0]);
        }
        catch (Exception exception) {
            this._logger.error((Object)("Failed to create a local copy of the zip for plugin " + idVersionPair.toString() + ". The plugin signing state of this plugin may be incorrect."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePackageToFile(VcPackageInfo vcPackageInfo, File file) throws IOException {
        InputStream inputStream;
        String[] stringArray = vcPackageInfo.getSslThumbprints();
        URL uRL = new URL(vcPackageInfo.url);
        String string = uRL.getProtocol();
        Proxy proxy = VcExtensionUtil.getHttpProxy((ConfigurationService)this._configurationService);
        String string2 = "Downloading plugin package from " + uRL;
        string2 = proxy == null ? string2 + " (no proxy defined)" : string2 + ", using proxy " + proxy.address().toString();
        this._logger.info((Object)string2);
        if ("https".equals(string) && stringArray != null && stringArray.length != 0) {
            SSLBuilder sSLBuilder = new SSLBuilder();
            if (this._sslConfigurationProvider != null) {
                sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
            }
            sSLBuilder.socketReadTimeout(Config.VC_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT.toIntMillis());
            sSLBuilder.socketConnectionTimeout(Config.VC_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT.toIntMillis());
            HttpClient httpClient = sSLBuilder.thumbprints(stringArray).buildHttpClientIgnoreErrors();
            inputStream = httpClient.executeMethodResponseAsStream(vcPackageInfo.url, null, null, proxy);
        } else {
            Boolean bl = VcExtensionUtil.isHttpDownloadAllowed((ConfigurationService)this._configurationService);
            if (!bl.booleanValue()) {
                this._logger.error((Object)"The plugin package download was blocked because the URL isnot secure.  To allow http URLs add allowHttp=true to webclient.properties");
                return;
            }
            inputStream = proxy != null ? uRL.openConnection(proxy).getInputStream() : uRL.openStream();
        }
        try {
            FileUtil.writeFile((InputStream)inputStream, (File)file);
        }
        finally {
            StreamUtil.close((Closeable)inputStream);
        }
        this._logger.info((Object)("Done downloading plugin package from " + uRL));
    }

    private void performPluginSignatureCheckIfNecessary(VcPackageInfo vcPackageInfo, File file) {
        boolean bl = PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)"plugin.signature.check.enabled", (boolean)true);
        if (!bl) {
            this._logger.debug((Object)("The plugin signature for " + vcPackageInfo.getPackageRef() + " will not be verified since the plugin signature service is disabled"));
            return;
        }
        try (JarFile jarFile = new JarFile(file);){
            try {
                this._pluginSignatureService.verifySignature(jarFile);
                vcPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.SIGNED);
            }
            catch (PluginSignatureException pluginSignatureException) {
                this._logger.warn((Object)("Detected an invalid signature for plugin: " + vcPackageInfo.getPackageRef() + " - " + pluginSignatureException.toString()));
                vcPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.UNSIGNED);
            }
            catch (PluginSignatureGeneralException pluginSignatureGeneralException) {
                this._logger.error((Object)("Unable to verify the signature for plugin: " + vcPackageInfo.getPackageRef()), (Throwable)pluginSignatureGeneralException);
                vcPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.UNKNOWN);
            }
        }
        catch (IOException iOException) {
            this._logger.error((Object)("Couldn't open plugin zip file when trying to verifythe signature of plugin " + vcPackageInfo.getPackageRef()), (Throwable)iOException);
            vcPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.UNKNOWN);
        }
    }

    private String getPackageDirName(IdVersionPair idVersionPair) {
        return idVersionPair.getId() + "-" + idVersionPair.getVersion();
    }

    protected File getPackageDir(String string) {
        File file = new File(Environment.clientAppDataFolder());
        File file2 = new File(new File(file, "vc-packages"), this._localExtensionType);
        File file3 = new File(file2, string);
        return file3;
    }

    protected synchronized void packageUndeployed(IdVersionPair idVersionPair) {
        this._packageRefs.remove(idVersionPair);
        this._allPackageRefs.remove(idVersionPair);
        File file = this.getPackageDir(this.getPackageDirName(idVersionPair));
        if (file.exists()) {
            this._logger.info((Object)("Delete vc package directory '" + file + "' because the package is undeployed."));
            FileUtil.deleteDir((File)file);
        }
    }

    private List<VcPackageInfo> getLocalVcPackages(String string) {
        String string2 = System.getProperty("localVcPackagesPath");
        if (string2 == null) {
            return null;
        }
        File file = new File(string2, string);
        if (!file.exists()) {
            return null;
        }
        File file2 = null;
        for (File stringArray2 : file.listFiles()) {
            if (!stringArray2.getName().endsWith(".zip")) continue;
            file2 = stringArray2;
            break;
        }
        if (file2 == null) {
            this._logger.info((Object)("Package zip file not found in " + file));
            return null;
        }
        ArrayList arrayList = new ArrayList();
        String string3 = file2.getName();
        int n = string3.indexOf(".zip");
        String[] stringArray = (string3 = string3.substring(0, n)).split("-");
        if (stringArray.length != 2) {
            this._logger.error((Object)"Invalid package zip file name.");
            return arrayList;
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        VcPackageInfo vcPackageInfo = new VcPackageInfo();
        vcPackageInfo.setId(string4);
        vcPackageInfo.setVersion(string5);
        vcPackageInfo.url = file2.toURI().toString();
        arrayList.add(vcPackageInfo);
        return arrayList;
    }

    private long getPluginDeployTimeout() {
        try {
            long l;
            String string = this._configurationService.getProperty(DEPLOYMENT_TIMEOUT_PROP_NAME);
            if (!StringUtil.isNullOrEmpty((String)string) && (l = Long.parseLong(string)) >= 1L) {
                return l;
            }
        }
        catch (Exception exception) {
            this._logger.error((Object)"Invalid newPlugins.deployTimeout value in webclient.properties ", (Throwable)exception);
        }
        return 10L;
    }

    private static class DownloadContext {
        public final VcPackageInfo packageInfo;
        public final Future<Set<IdVersionPair>> future;

        public DownloadContext(VcPackageInfo vcPackageInfo, Future<Set<IdVersionPair>> future) {
            this.packageInfo = vcPackageInfo;
            this.future = future;
        }
    }

    public static class VcPackageInfo
    extends PluginPackageInfo {
        public String url;
    }
}

