/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.sso.tokenmgmt.impl.NonAcquiringTokenManager;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.extensionfw.PluginPackageSource;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityResult;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.commons.vcservice.impl.LinkedVcGroupImpl;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceImpl;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class VcPluginPackageManager
implements PluginPackageSource {
    protected final Log _logger = LogFactory.getLog(this.getClass());
    protected final VcSource _vcSource;
    protected final VcServiceCompatibilityChecker _vcCompatibilityChecker;
    protected final SSLConfigurationProvider _sslConfigurationProvider;

    public VcPluginPackageManager(@Nonnull VcSource vcSource, @Nonnull VcServiceCompatibilityChecker vcServiceCompatibilityChecker, @Nonnull SSLConfigurationProvider sSLConfigurationProvider) {
        this._vcSource = vcSource;
        this._vcCompatibilityChecker = vcServiceCompatibilityChecker;
        this._sslConfigurationProvider = sSLConfigurationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IdVersionPair> deployNewPackages() throws Exception {
        if (!this.isEnabled()) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"VcPluginPackageManager is not enabled.");
            }
            return Collections.emptySet();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(VcPluginPackageManager.class.getClassLoader());
            HttpSession httpSession = this.getCurrentUserSession();
            if (httpSession != null) {
                Set<IdVersionPair> set = this.deployAsWebUser(httpSession);
                return set;
            }
            Set<IdVersionPair> set = this.deployAsSolutionUser();
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected abstract Set<IdVersionPair> addPackages(Collection<? extends VcService> var1);

    protected boolean isEnabled() {
        return true;
    }

    protected HttpSession getCurrentUserSession() {
        return SessionUtil.getHttpSession((boolean)false);
    }

    protected Set<IdVersionPair> deployAsWebUser(@Nonnull HttpSession httpSession) {
        LinkedVcGroup[] linkedVcGroupArray = this.getStartupLinkedVcGroups(httpSession);
        LinkedList linkedList = new LinkedList();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            linkedList.addAll(linkedVcGroup.getVcServices());
        }
        return this.addPackages(linkedList);
    }

    protected LinkedVcGroup[] getStartupLinkedVcGroups(HttpSession httpSession) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSession);
        return linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<IdVersionPair> deployAsSolutionUser() {
        List<VcServiceImpl> list = this.loginToVcs(this._vcSource.getVcs());
        try {
            Set<IdVersionPair> set;
            Set<IdVersionPair> set2 = set = this.addPackages(list);
            return set2;
        }
        finally {
            this.logoutFromVcs(list);
        }
    }

    protected List<VcServiceImpl> loginToVcs(List<ServerInfoEx> list) {
        ArrayList<VcServiceImpl> arrayList = new ArrayList<VcServiceImpl>();
        for (ServerInfoEx serverInfoEx : list) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Logging in to VC " + serverInfoEx.serviceUrl));
            }
            VcServiceImpl vcServiceImpl = null;
            try {
                LoginSpec loginSpec = this.createSolutionUserLoginSpec(serverInfoEx);
                vcServiceImpl = LinkedVcGroupImpl.createVcService((LoginSpec)loginSpec, null, null, null, null);
                if (!this.isVcServiceCompatible((VcService)vcServiceImpl)) continue;
                vcServiceImpl.login();
            }
            catch (Exception exception) {
                this._logger.error((Object)("Error creating VcService for " + serverInfoEx.serviceUrl), (Throwable)exception);
            }
            if (vcServiceImpl == null) continue;
            arrayList.add(vcServiceImpl);
        }
        return arrayList;
    }

    protected void logoutFromVcs(List<VcServiceImpl> list) {
        for (VcServiceImpl vcServiceImpl : list) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Logging out from VC " + vcServiceImpl.getServiceUrl()));
            }
            try {
                vcServiceImpl.logout();
            }
            catch (Exception exception) {
                this._logger.error((Object)("Could not log out from VC " + vcServiceImpl.getServiceUrl()));
            }
        }
    }

    private LoginSpec createSolutionUserLoginSpec(ServerInfoEx serverInfoEx) {
        SsoSolutionUser ssoSolutionUser = SsoUtil.getSolutionUser();
        LoginSpec loginSpec = VcServiceUtil.createVcLoginSpec((ServerInfoEx)serverInfoEx, (SSLConfigurationProvider)this._sslConfigurationProvider);
        SsoDomain ssoDomain = loginSpec.ssoDomain;
        TokenEx tokenEx = ssoSolutionUser.getLoggedInTokenEx(ssoDomain);
        SamlToken samlToken = tokenEx.getToken();
        SsoDomain ssoDomain2 = tokenEx.getIssuerSsoDomain();
        loginSpec.tokenProvider = new NonAcquiringTokenManager(ssoDomain, ssoDomain2, samlToken);
        loginSpec.privateKey = ssoSolutionUser.getPrivateKey();
        return loginSpec;
    }

    private boolean isVcServiceCompatible(VcService vcService) {
        if (this._vcCompatibilityChecker == null) {
            return true;
        }
        VcServiceCompatibilityResult vcServiceCompatibilityResult = this._vcCompatibilityChecker.verify(vcService);
        if (!vcServiceCompatibilityResult.isCompatible()) {
            this._logger.warn((Object)("VcService " + vcService.getServiceUrl() + " is incompatible: " + vcServiceCompatibilityResult.getFailure().toString()));
            return false;
        }
        return true;
    }
}

