/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension;

import com.vmware.vim.binding.vim.Description;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.extension.ScriptPluginUtil;
import com.vmware.vise.vim.extension.ScriptPluginXmlTransformer;
import com.vmware.vise.vim.extension.VcPluginPackageManager;
import com.vmware.vise.vim.extension.util.VcExtensionUtil;
import com.vmware.vise.vim.scriptPlugin.ScriptPluginService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;

public class VcScriptPluginManager
extends VcPluginPackageManager
implements ExtensionListener {
    private static final String SERVER_GUIDS = "vcServerGuids";
    private ExtensionService _extensionService;
    private String _extensionType;
    protected File pluginFile;
    protected File pluginPackage;
    private static final String IGNORE_LIST = "scriptPlugin.ignoreList";
    private static final String SCRIPT_PLUGINS_ENABLED = "scriptPlugin.enabled";
    private static final String IGNORED_BY_DEFAULT = "cim-ui,health-ui,com.vmware.rbd,com.vmware.netdump,com.vmware.syslog,";
    private static final String PLUGIN = "plugin.xml";
    private static final String PLUGINS = "plugins";
    private static final String PLUGIN_PACKAGE = "plugin-package.xml";
    protected ScriptPluginService _scriptPluginService;
    private final ConfigurationService _configurationService;
    private final KeystoreService _ksService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final boolean _isEnabled;
    private Set<IdVersionPair> _packageRefs = new HashSet<IdVersionPair>();

    public VcScriptPluginManager(@Nonnull ExtensionService extensionService, @Nonnull String string, @Nonnull ConfigurationService configurationService, @Nonnull ScriptPluginService scriptPluginService, @Nonnull KeystoreService keystoreService, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nonnull VcSource vcSource, @Nonnull VcServiceCompatibilityChecker vcServiceCompatibilityChecker) {
        super(vcSource, vcServiceCompatibilityChecker, sSLConfigurationProvider);
        ValidationUtil.notNull((Object)extensionService, (String)"extensionService is null");
        ValidationUtil.notNull((Object)string, (String)"extensionType is null");
        ValidationUtil.notNull((Object)configurationService, (String)"configurationService is null");
        ValidationUtil.notNull((Object)scriptPluginService, (String)"scriptPluginService is null");
        ValidationUtil.notNull((Object)keystoreService, (String)"ksService is null");
        ValidationUtil.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null");
        ValidationUtil.notNull((Object)vcSource, (String)"vcSource is null");
        ValidationUtil.notNull((Object)vcServiceCompatibilityChecker, (String)"vcCompatibilityChecker is null");
        this._extensionService = extensionService;
        this._extensionType = string;
        this._configurationService = configurationService;
        this._scriptPluginService = scriptPluginService;
        this._ksService = keystoreService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        if (configurationService.getProperty(SCRIPT_PLUGINS_ENABLED) != null) {
            String string2 = configurationService.getProperty(SCRIPT_PLUGINS_ENABLED);
            this._isEnabled = Boolean.parseBoolean(string2);
        } else {
            this._isEnabled = false;
        }
    }

    @Override
    protected boolean isEnabled() {
        return this._isEnabled;
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (!pluginPackageEvent.getType().equals("pluginPackageUndeployed")) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageEvent.getPluginPackageInfos()) {
            this.packageUndeployed(pluginPackageInfo.getPackageRef());
        }
    }

    @Override
    protected Set<IdVersionPair> addPackages(Collection<? extends VcService> collection) {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (VcService vcService : collection) {
            ExtensionManager extensionManager;
            String string = vcService.getServiceGuid();
            ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().extensionManager;
            try {
                extensionManager = (ExtensionManager)vcService.getManagedObject(managedObjectReference);
            }
            catch (Exception exception) {
                this._logger.error((Object)"Couldn't retrieve ExtensionManager: ", (Throwable)exception);
                continue;
            }
            List<VcPackageInfo> list = this.getVcPackages(extensionManager, vcService);
            Set<IdVersionPair> set = this.addPackages(list, string);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private List<VcPackageInfo> getVcPackages(ExtensionManager extensionManager, VcService vcService) {
        ArrayList<VcPackageInfo> arrayList = new ArrayList<VcPackageInfo>();
        Extension[] extensionArray = extensionManager.getExtensionList();
        if (extensionArray == null) {
            return arrayList;
        }
        for (Extension extension : extensionArray) {
            VcPackageInfo vcPackageInfo = null;
            try {
                vcPackageInfo = this.getVcPackageInfo(extension, vcService);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (vcPackageInfo == null) continue;
            arrayList.add(vcPackageInfo);
        }
        return arrayList;
    }

    private VcPackageInfo getVcPackageInfo(Extension extension, VcService vcService) throws Exception {
        Object object2;
        Extension.ServerInfo[] serverInfoArray = extension.server;
        if (serverInfoArray == null) {
            return null;
        }
        Extension.ServerInfo serverInfo = null;
        for (Object object2 : serverInfoArray) {
            if (!this._extensionType.equals(object2.type) || this.isOnIgnoreList(extension.getKey())) continue;
            serverInfo = object2;
            break;
        }
        if (serverInfo == null) {
            return null;
        }
        String string = extension.getKey();
        String string2 = extension.getVersion();
        String string3 = serverInfo.getUrl();
        if (StringUtil.isNullOrEmpty((String)string) || StringUtil.isNullOrEmpty((String)string2) || StringUtil.isNullOrEmpty((String)string3)) {
            this._logger.error((Object)("Missing key, version or url in vCenter script plugin extension: Extension.id = " + string + ", Extension.ClientInfo.version = " + string2 + ", Extension.ClientInfo.url = " + string3));
            return null;
        }
        object2 = new VcPackageInfo();
        object2.setId(string);
        object2.setVersion(string2);
        Description description = serverInfo.getDescription();
        if (description != null) {
            object2.setName(description.getLabel());
            object2.setDescription(description.getSummary());
        }
        object2.setVendor(serverInfo.getCompany());
        object2.vcService = vcService;
        object2.serverInfo = serverInfo;
        return object2;
    }

    private void prepareFilesAndFolders(String string) {
        File file = new File(string, PLUGINS);
        this.pluginFile = new File(file, PLUGIN);
        this.pluginPackage = new File(string, PLUGIN_PACKAGE);
        file.mkdirs();
    }

    private boolean isOnIgnoreList(String string) {
        String string2 = IGNORED_BY_DEFAULT;
        if (this._configurationService.getProperty(IGNORE_LIST) != null) {
            string2 = string2 + this._configurationService.getProperty(IGNORE_LIST);
        }
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i].trim())) continue;
            return true;
        }
        return false;
    }

    private synchronized Set<IdVersionPair> addPackages(Collection<VcPackageInfo> collection, String string) {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>(collection.size());
        for (VcPackageInfo vcPackageInfo : collection) {
            IdVersionPair idVersionPair = vcPackageInfo.getPackageRef();
            try {
                boolean bl = this._packageRefs.contains(idVersionPair);
                if (!bl) {
                    boolean bl2 = bl = this._extensionService.getPluginPackageInfo(idVersionPair) != null;
                }
                if (bl && this.packageHasBeenProcessedBefore(idVersionPair, string)) {
                    hashSet.add(idVersionPair);
                    continue;
                }
                File file = this.downloadPackage(vcPackageInfo);
                if (file == null) continue;
                vcPackageInfo.setDirectory(file);
                Set set = this._extensionService.addPluginPackages(new PluginPackageInfo[]{vcPackageInfo});
                hashSet.addAll(set);
            }
            catch (Exception exception) {
                this._logger.error((Object)("Adding vc extension " + idVersionPair + " failed"), (Throwable)exception);
            }
        }
        for (IdVersionPair idVersionPair : hashSet) {
            this.updatePackageMetadata(idVersionPair, string);
        }
        this._packageRefs.addAll(hashSet);
        return hashSet;
    }

    private void updatePackageMetadata(IdVersionPair idVersionPair, String string) {
        HashSet<Object> hashSet;
        PluginPackageInfo pluginPackageInfo;
        try {
            pluginPackageInfo = this._extensionService.getPluginPackageInfo(idVersionPair);
        }
        catch (Exception exception) {
            this._logger.error((Object)("ExtensionService.getPluginPackageInfo for " + idVersionPair + " failed"), (Throwable)exception);
            return;
        }
        if (pluginPackageInfo == null) {
            return;
        }
        ConcurrentMap concurrentMap = pluginPackageInfo.getMetadata();
        String[] stringArray = (String[])concurrentMap.get(SERVER_GUIDS);
        if (stringArray != null) {
            hashSet = new HashSet<String>(Arrays.asList(stringArray));
            if (hashSet.contains(string)) {
                return;
            }
        } else {
            hashSet = new HashSet<String>();
        }
        hashSet.add(string);
        concurrentMap.put(SERVER_GUIDS, hashSet.toArray(new String[0]));
    }

    private boolean packageHasBeenProcessedBefore(IdVersionPair idVersionPair, String string) {
        PluginPackageInfo pluginPackageInfo;
        try {
            pluginPackageInfo = this._extensionService.getPluginPackageInfo(idVersionPair);
        }
        catch (Exception exception) {
            this._logger.error((Object)("ExtensionService.getPluginPackageInfo for " + idVersionPair + " failed"), (Throwable)exception);
            return false;
        }
        if (pluginPackageInfo == null) {
            return false;
        }
        ConcurrentMap concurrentMap = pluginPackageInfo.getMetadata();
        String[] stringArray = (String[])concurrentMap.get(SERVER_GUIDS);
        if (stringArray != null) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
            return hashSet.contains(string);
        }
        return false;
    }

    private File downloadPackage(VcPackageInfo vcPackageInfo) {
        Object object;
        Boolean bl;
        String string = ScriptPluginUtil.generateUrl(vcPackageInfo.serverInfo.url, vcPackageInfo.vcService);
        Proxy proxy = VcExtensionUtil.getHttpProxy((ConfigurationService)this._configurationService);
        if (!string.startsWith("https://") && !(bl = VcExtensionUtil.isHttpDownloadAllowed((ConfigurationService)this._configurationService)).booleanValue()) {
            this._logger.info((Object)("Cannot process script plugin URL " + string + " because it is not secure.\nTo support http URLs you need to add the flag allowHttp=true to webclient.properties."));
            return null;
        }
        bl = null;
        SSLBuilder sSLBuilder = new SSLBuilder();
        sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
        if (StringUtil.isNullOrEmpty((String)vcPackageInfo.serverInfo.getServerThumbprint())) {
            if (VcServiceUtil.is60VcOrLater((String)vcPackageInfo.vcService.getServiceGuid())) {
                object = this._ksService.getKeyStore();
                bl = sSLBuilder.addTrustStore((KeyStore)object).buildHttpClientIgnoreErrors();
            } else {
                object = vcPackageInfo.vcService.getThumbprint();
                bl = sSLBuilder.thumbprint((String)object).buildHttpClientIgnoreErrors();
            }
        } else {
            object = vcPackageInfo.serverInfo.getServerThumbprint();
            bl = sSLBuilder.thumbprint((String)object).buildHttpClientIgnoreErrors();
        }
        object = null;
        try {
            object = bl.executeMethodResponseAsStream(string, null, null, proxy);
        }
        catch (IOException iOException) {
            this._logger.error((Object)("Cannot download script plugin configuration at URL " + string), (Throwable)iOException);
            return null;
        }
        File file = this.getPackageDir(vcPackageInfo.getPackageRef());
        if (object != null && (!file.exists() || file.exists() && !this.packageHasBeenProcessedBefore(vcPackageInfo.getPackageRef(), vcPackageInfo.vcService.getServiceGuid()))) {
            if (file.exists()) {
                FileUtil.deleteDir((File)file);
            }
            this.prepareFilesAndFolders(file.toString());
            String string2 = "";
            try {
                string2 = new Scanner((InputStream)object, "UTF-8").useDelimiter("\\A").next();
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            Document document = XMLUtil.parseXml((String)string2);
            this.transform(document, vcPackageInfo.vcService, string);
        }
        return file;
    }

    protected void transform(Document document, VcService vcService, String string) {
        try {
            ScriptPluginXmlTransformer scriptPluginXmlTransformer = new ScriptPluginXmlTransformer();
            scriptPluginXmlTransformer.processXml(document, vcService, this.pluginFile, this.pluginPackage, this._scriptPluginService, string);
        }
        catch (Exception exception) {
            this._logger.error((Object)("An exception occured in the xml transformer for script plugin: " + string), (Throwable)exception);
        }
    }

    private File getPackageDir(IdVersionPair idVersionPair) {
        String string = idVersionPair.getId() + "-" + idVersionPair.getVersion();
        File file = new File(Environment.clientAppDataFolder());
        File file2 = new File(new File(file, "script-plugin-packages"), this._extensionType);
        File file3 = new File(file2, string);
        return file3;
    }

    private synchronized void packageUndeployed(IdVersionPair idVersionPair) {
        this._packageRefs.remove(idVersionPair);
        File file = this.getPackageDir(idVersionPair);
        if (file.exists()) {
            this._logger.info((Object)("Delete vc package directory '" + file + "' because the package is undeployed."));
            FileUtil.deleteDir((File)file);
        }
    }

    private static class VcPackageInfo
    extends PluginPackageInfo {
        public VcService vcService;
        public Extension.ServerInfo serverInfo;

        private VcPackageInfo() {
        }
    }
}

