/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.http.transport.urlResolver.DatastoreFileDownloadUrlResolver;
import com.vmware.vise.vim.http.transport.urlResolver.DatastoreFileLocation;
import com.vmware.vise.vim.http.transport.util.FileRequestHandlerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.HttpRequestHandler;

public class FileDownloadRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(FileDownloadRequestHandler.class);
    private static final int ONE_MB = 0x100000;
    private static final String RESULT_FILE_NAME_PARAM = "resultFileName";
    private static final String BASE_DATASTORE_PATH_PARAM = "baseDatastorePath";
    private static final String DEFAULT_RESULT_FILE_NAME = "files.zip";
    private static final String ERROR_LOG_FILE_NAME = "Error report.log";
    private static final String REQUEST_TOKEN_PARAM = "requestToken";
    private static final String TOKEN_PARAM = "token";
    private KeystoreService _keystoreService;
    private final Cache<String, RequestData> _cache;
    private final Object _tokenCacheLock = new Object();
    private DatastoreFileDownloadUrlResolver _datastoreFileDownloadUrlResolver;
    private ImmutableList<String> supportedMethods = ImmutableList.of((Object)HttpMethod.GET.toString(), (Object)HttpMethod.POST.toString());

    public FileDownloadRequestHandler() {
        this._cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setDatastoreFileDownloadUrlResolver(DatastoreFileDownloadUrlResolver datastoreFileDownloadUrlResolver) {
        this._datastoreFileDownloadUrlResolver = datastoreFileDownloadUrlResolver;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.supportedMethods.contains((Object)string)) {
            RequestData requestData;
            if (httpServletRequest.getParameter(TOKEN_PARAM) != null) {
                requestData = this.readFromCache(httpServletRequest.getParameter(TOKEN_PARAM));
            } else {
                requestData = this.createRequestData(httpServletRequest, httpServletResponse);
                if (httpServletRequest.getParameter(REQUEST_TOKEN_PARAM) != null) {
                    String string2 = this.putInCache(requestData);
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    servletOutputStream.print(string2);
                    servletOutputStream.flush();
                    return;
                }
            }
            if (requestData == null) {
                _logger.error((Object)"Invalid request.");
                FileRequestHandlerUtil.returnError(httpServletResponse, "Invalid request.");
                return;
            }
            this.doRequest(requestData, httpServletResponse);
        } else {
            FileRequestHandlerUtil.returnResponse(httpServletResponse, 405, string + " request method is not supported.");
        }
    }

    private void doRequest(RequestData requestData, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = requestData.getZipFileName();
        string = URLEncoder.encode(string, "UTF-8").replace("+", "%20");
        httpServletResponse.setContentType("application/octet-stream");
        String string2 = String.format("attachment; filename*=UTF-8''%s", string);
        httpServletResponse.addHeader("Content-Disposition", string2);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)servletOutputStream);
        zipOutputStream.setLevel(0);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = requestData.getBaseDatastorePath();
        List<DatastoreFileLocation> list = requestData.getDsFileLocations();
        String string4 = requestData.getVcGuid();
        try {
            for (DatastoreFileLocation datastoreFileLocation : list) {
                HttpsURLConnection httpsURLConnection = FileDownloadRequestHandler.createConnection(datastoreFileLocation.getFileUrl(), FileRequestHandlerUtil.getSSLSocketFactory(this._keystoreService), string4);
                String string5 = null;
                if (string3 != null && !string3.isEmpty()) {
                    string5 = datastoreFileLocation.getRelativePath(string3);
                }
                if (string5 == null) {
                    string5 = FileRequestHandlerUtil.generateUniqueFileName(datastoreFileLocation.getFileName(), hashSet);
                    hashSet.add(string5);
                }
                try {
                    InputStream inputStream = httpsURLConnection.getInputStream();
                    Throwable throwable = null;
                    try {
                        FileDownloadRequestHandler.addFileToZip(string5, inputStream, zipOutputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    arrayList.add(String.format("Failed to download \"%s\": %s", datastoreFileLocation.getDatastorePath(), iOException.toString()));
                }
            }
            if (!arrayList.isEmpty()) {
                String string6 = FileRequestHandlerUtil.generateUniqueFileName(ERROR_LOG_FILE_NAME, hashSet);
                hashSet.add(string6);
                this.writeErrorsToLog(arrayList, zipOutputStream, string6);
            }
            zipOutputStream.close();
        }
        catch (IOException | GeneralSecurityException exception) {
            _logger.error((Object)"Failed to download and generate zip file.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String putInCache(RequestData requestData) {
        String string = UUID.randomUUID().toString();
        Object object = this._tokenCacheLock;
        synchronized (object) {
            this._cache.put((Object)string, (Object)requestData);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestData readFromCache(String string) {
        if (string == null) {
            return null;
        }
        Object object = this._tokenCacheLock;
        synchronized (object) {
            RequestData requestData = (RequestData)this._cache.getIfPresent((Object)string);
            if (requestData != null) {
                this._cache.invalidate((Object)string);
            }
            return requestData;
        }
    }

    private void writeErrorsToLog(List<String> list, ZipOutputStream zipOutputStream, String string) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(string));
        PrintWriter printWriter = new PrintWriter(zipOutputStream);
        for (String string2 : list) {
            printWriter.write(string2);
            printWriter.write("\n");
            printWriter.flush();
        }
        zipOutputStream.closeEntry();
        zipOutputStream.flush();
    }

    private List<DatastoreFileLocation> resolveFilePaths(HttpServletRequest httpServletRequest) {
        if (this._datastoreFileDownloadUrlResolver.canResolveUrl(httpServletRequest)) {
            return this._datastoreFileDownloadUrlResolver.resolveFileLocations(httpServletRequest);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(String string, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[0x100000];
        zipOutputStream.putNextEntry(new ZipEntry(string));
        try {
            int n;
            while ((n = inputStream.read(byArray)) > -1) {
                zipOutputStream.write(byArray, 0, n);
                zipOutputStream.flush();
            }
        }
        finally {
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
        }
    }

    private static HttpsURLConnection createConnection(URL uRL, SSLSocketFactory sSLSocketFactory, String string) throws IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        httpsURLConnection.setRequestMethod(HttpMethod.GET.name());
        httpsURLConnection.setDoInput(true);
        FileRequestHandlerUtil.setVcSessionCookie(httpsURLConnection, string);
        return httpsURLConnection;
    }

    private RequestData createRequestData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        List<DatastoreFileLocation> list = this.resolveFilePaths(httpServletRequest);
        if (list == null || list.isEmpty()) {
            _logger.error((Object)"Failed to parse datastore file locations");
            FileRequestHandlerUtil.returnError(httpServletResponse, "Failed to parse file locations.");
            return null;
        }
        String string = httpServletRequest.getParameter("vcServerGuid");
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.error((Object)"Missing vcGuid");
            FileRequestHandlerUtil.returnError(httpServletResponse, "Invalid request. Missing vcGuid parameter.");
            return null;
        }
        String string2 = httpServletRequest.getParameter(RESULT_FILE_NAME_PARAM);
        String string3 = httpServletRequest.getParameter(BASE_DATASTORE_PATH_PARAM);
        return new RequestData(string, list, string2, string3);
    }

    private static class RequestData {
        private String _vcGuid;
        private List<DatastoreFileLocation> _dsFileLocations;
        private String _zipFileName;
        private String _baseDatastorePath;

        RequestData(String string, List<DatastoreFileLocation> list, String string2, String string3) {
            this._vcGuid = string;
            this._dsFileLocations = list;
            this._zipFileName = !StringUtil.isNullOrEmpty((String)string2) ? string2 : FileDownloadRequestHandler.DEFAULT_RESULT_FILE_NAME;
            this._baseDatastorePath = string3;
        }

        public String getVcGuid() {
            return this._vcGuid;
        }

        public List<DatastoreFileLocation> getDsFileLocations() {
            return this._dsFileLocations;
        }

        public String getZipFileName() {
            return this._zipFileName;
        }

        public String getBaseDatastorePath() {
            return this._baseDatastorePath;
        }
    }
}

