/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport.util;

import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.conn.ssl.SSLContexts;
import org.springframework.web.util.HtmlUtils;

public class FileRequestHandlerUtil {
    public static final String VC_SERVICE_GUID_PARAM = "vcServerGuid";
    private static final String SESSION_COOKIE_NAME = "vmware_soap_session";

    public static void returnError(HttpServletResponse httpServletResponse, String string) throws IOException {
        FileRequestHandlerUtil.returnResponse(httpServletResponse, 500, string);
    }

    public static void returnResponse(HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        httpServletResponse.setStatus(n);
        httpServletResponse.setContentType("text/plain");
        string = HtmlUtils.htmlEscape((String)string);
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            printWriter.print(string);
        }
    }

    public static SSLSocketFactory getSSLSocketFactory(KeystoreService keystoreService) throws GeneralSecurityException {
        SSLContext sSLContext = SSLContexts.custom().loadTrustMaterial(keystoreService.getKeyStore()).build();
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }

    public static void setVcSessionCookie(HttpsURLConnection httpsURLConnection, String string) {
        String string2 = VimSessionUtil.getService((String)string).getConnectionInfo().getSessionCookie();
        httpsURLConnection.setRequestProperty("Cookie", "vmware_soap_session=" + string2);
    }

    public static String generateUniqueFileName(String string, Set<String> set) {
        if (!set.contains(string)) {
            return string;
        }
        int n = string.lastIndexOf(".");
        String string2 = "";
        String string3 = string;
        if (n >= 0) {
            string2 = string.substring(n);
            string3 = string.substring(0, n);
        }
        int n2 = 1;
        String string4 = String.format("%s (%s)%s", string3, n2, string2).trim();
        while (set.contains(string4)) {
            string4 = String.format("%s (%s)%s", string3, ++n2, string2).trim();
        }
        return string4;
    }
}

