/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.accesscontrol;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.vise.util.session.SessionUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;

public class PrivilegeCache {
    private static final long MAXIMUM_CACHE_SIZE = 100L;
    private static final long MAXIMUM_CACHE_AGE_IN_MINUTES = 30L;
    private static final String GRANTED_PRIVILEGES_CACHE_KEY = "granted.privileges.cache.key";
    private static final String HAS_PRIVILEGES_CACHE_KEY = "has.privileges.cache.key";

    private <K, V> Cache<K, V> createCacheInstance(String string) {
        Cache cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
        Object object = SessionUtil.setDataIfAbsent((String)string, (Object)cache);
        if (object != null) {
            cache = (Cache)object;
        }
        return cache;
    }

    private <K, V> Cache<K, V> getCacheFromSession(String string) {
        Cache cache = (Cache)SessionUtil.getData((String)string);
        if (cache == null) {
            return this.createCacheInstance(string);
        }
        return cache;
    }

    public String[][] get(Object[] objectArray) {
        String[][] stringArray = new String[objectArray.length][];
        Cache cache = this.getCacheFromSession(GRANTED_PRIVILEGES_CACHE_KEY);
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String[])cache.getIfPresent(objectArray[i]);
            if (stringArray[i] != null) continue;
            return null;
        }
        return stringArray;
    }

    public Boolean[] get(Object[] objectArray, String[] stringArray) {
        Boolean[] booleanArray = new Boolean[objectArray.length];
        Cache cache = this.getCacheFromSession(HAS_PRIVILEGES_CACHE_KEY);
        for (int i = 0; i < objectArray.length; ++i) {
            HasPrivilegeKey hasPrivilegeKey = new HasPrivilegeKey(objectArray[i], stringArray);
            booleanArray[i] = (Boolean)cache.getIfPresent((Object)hasPrivilegeKey);
            if (booleanArray[i] != null) continue;
            return null;
        }
        return booleanArray;
    }

    public void put(Object[] objectArray, String[][] stringArray) {
        if (objectArray.length != stringArray.length) {
            throw new IllegalArgumentException("objectIds.length must be equal to privileges.length");
        }
        Cache cache = this.getCacheFromSession(GRANTED_PRIVILEGES_CACHE_KEY);
        for (int i = 0; i < objectArray.length; ++i) {
            cache.put(objectArray[i], (Object)stringArray[i]);
        }
    }

    public void put(Object[] objectArray, String[] stringArray, Boolean[] booleanArray) {
        if (objectArray.length != booleanArray.length) {
            throw new IllegalArgumentException("objectIds.length must be equal to hasPrivileges.length");
        }
        Cache cache = this.getCacheFromSession(HAS_PRIVILEGES_CACHE_KEY);
        for (int i = 0; i < objectArray.length; ++i) {
            cache.put((Object)new HasPrivilegeKey(objectArray[i], stringArray), (Object)booleanArray[i]);
        }
    }

    private void invalidate(String string) {
        Cache cache = this.getCacheFromSession(string);
        cache.invalidateAll();
    }

    public void invalidate() {
        this.invalidate(GRANTED_PRIVILEGES_CACHE_KEY);
        this.invalidate(HAS_PRIVILEGES_CACHE_KEY);
    }

    private class HasPrivilegeKey {
        private final Object _object;
        private final String[] _privileges;

        public HasPrivilegeKey(Object object, String[] stringArray) {
            if (object == null) {
                throw new IllegalArgumentException("object must not be null.");
            }
            if (ArrayUtils.isEmpty((Object[])stringArray)) {
                throw new IllegalArgumentException("privileges must not be null or empty.");
            }
            this._object = object;
            this._privileges = stringArray;
        }

        public int hashCode() {
            int n = Objects.hash(this._object);
            return n + Objects.hash(this._privileges);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HasPrivilegeKey)) {
                return false;
            }
            HasPrivilegeKey hasPrivilegeKey = (HasPrivilegeKey)object;
            if (this._object.equals(hasPrivilegeKey._object)) {
                return Arrays.equals(this._privileges, hasPrivilegeKey._privileges);
            }
            return false;
        }
    }
}

