/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.impl;

import com.vmware.cis.authz.Role;
import com.vmware.cis.authz.RoleTypes;
import com.vmware.vapi.std.errors.AlreadyExists;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vapi.std.errors.Unauthorized;
import com.vmware.vapi.std.errors.Unsupported;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.security.AuthorizationObjectUtil;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationServiceManager;
import com.vmware.vise.vim.security.data.CreateRoleSpec;
import com.vmware.vise.vim.security.data.EditRoleSpec;
import com.vmware.vise.vim.security.data.RemoveRoleSpec;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RolesMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(RolesMutationProvider.class);
    private final AuthorizationServiceManager _authzMgr;

    public RolesMutationProvider(AuthorizationServiceManager authorizationServiceManager) {
        this._authzMgr = authorizationServiceManager;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, RemoveRoleSpec removeRoleSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            Role role = this._authzMgr.getService(AuthorizationObjectUtil.ROOT_NODE_URI).getRoleManager();
            role.delete(removeRoleSpec.roleId);
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)("Failed to remove role with id " + removeRoleSpec.roleId), (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        catch (Unsupported unsupported) {
            _logger.error((Object)("Failed to remove role with id " + removeRoleSpec.roleId), (Throwable)unsupported);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unsupported", (Exception)((Object)unsupported));
        }
        catch (NotFound notFound) {
            _logger.error((Object)("Failed to remove role with id " + removeRoleSpec.roleId), (Throwable)notFound);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.NotFound.role", (Exception)((Object)notFound));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, CreateRoleSpec createRoleSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            Role role = this._authzMgr.getService(AuthorizationObjectUtil.ROOT_NODE_URI).getRoleManager();
            RoleTypes.CreateSpec createSpec = new RoleTypes.CreateSpec();
            createSpec.setName(createRoleSpec.roleName);
            createSpec.setPrivilegeId(Arrays.asList(createRoleSpec.privileges));
            if (createRoleSpec.description == null) {
                createSpec.setDescription("");
            } else {
                createSpec.setDescription(createRoleSpec.description);
            }
            role.create(createSpec);
        }
        catch (AlreadyExists alreadyExists) {
            _logger.error((Object)("Failed to remove role with id " + createRoleSpec.roleName), (Throwable)alreadyExists);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.AlreadyExists.role", (Exception)((Object)alreadyExists));
        }
        catch (InvalidArgument invalidArgument) {
            _logger.error((Object)("Failed to remove role with id " + createRoleSpec.roleName), (Throwable)invalidArgument);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.InvalidArgument", (Exception)((Object)invalidArgument));
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)("Failed to remove role with id " + createRoleSpec.roleName), (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, EditRoleSpec editRoleSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            RoleTypes.UpdateSpec updateSpec = new RoleTypes.UpdateSpec();
            updateSpec.setName(editRoleSpec.roleName);
            updateSpec.setDescription(editRoleSpec.roleDescription);
            updateSpec.setPrivilegeId(Arrays.asList(editRoleSpec.privileges));
            Role role = this._authzMgr.getService(AuthorizationObjectUtil.ROOT_NODE_URI).getRoleManager();
            role.update(editRoleSpec.roleId, updateSpec);
        }
        catch (NotFound notFound) {
            _logger.error((Object)("Failed to modify role with id " + editRoleSpec.roleId), (Throwable)notFound);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.NotFound.role", (Exception)((Object)notFound));
        }
        catch (AlreadyExists alreadyExists) {
            _logger.error((Object)("Failed to modify role with id " + editRoleSpec.roleName), (Throwable)alreadyExists);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.AlreadyExists.role", (Exception)((Object)alreadyExists));
        }
        catch (Unsupported unsupported) {
            _logger.error((Object)("Failed to modify role with id " + editRoleSpec.roleName), (Throwable)unsupported);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unsupported", (Exception)((Object)unsupported));
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)("Failed to modify role with id " + editRoleSpec.roleName), (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        return operationResult;
    }
}

