/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.impl;

import com.vmware.cis.authz.Permission;
import com.vmware.cis.authz.PermissionTypes;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationService;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationServiceManager;
import com.vmware.vise.vim.security.data.PermissionData;
import com.vmware.vise.vim.security.data.PermissionForRoleData;
import com.vmware.vise.vim.security.util.VCAuthorizationUtil;
import flex.messaging.io.amf.ASObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RolesPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(RolesPropertyProviderAdapter.class);
    private static String PERM_FOR_ROLE = "vsphere:permissionForRole";
    private static String NAME_PROPERTY = "name";
    private final DataServiceExtensionRegistry _extensionRegistry;
    private final AuthorizationServiceManager _authzMgr;
    private final QueryExecutor _queryExecutor;
    private final ObjectReferenceService _objectReferenceService;

    public RolesPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, AuthorizationServiceManager authorizationServiceManager, QueryExecutor queryExecutor, ObjectReferenceService objectReferenceService) {
        this._extensionRegistry = dataServiceExtensionRegistry;
        this._authzMgr = authorizationServiceManager;
        this._queryExecutor = queryExecutor;
        this._objectReferenceService = objectReferenceService;
    }

    public void initialize() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "*";
        typeInfo.properties = new String[]{PERM_FOR_ROLE};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        if (objectArray == null || objectArray.length < 1) {
            _logger.error((Object)"permissionForRole Expects atleast one object");
            return null;
        }
        if (propertySpecArray == null || propertySpecArray.length < 1) {
            _logger.error((Object)"permissionForRole Expects atleast one property");
            return null;
        }
        PropertySpec propertySpec = propertySpecArray[0];
        ParameterSpec[] parameterSpecArray = propertySpec.parameters;
        if (parameterSpecArray == null || parameterSpecArray.length < 1) {
            _logger.error((Object)"permissionForRole Expects needs one role id parameter");
            return null;
        }
        ParameterSpec parameterSpec = propertySpec.parameters[0];
        ASObject aSObject = (ASObject)parameterSpec.parameter;
        String string = (String)aSObject.get((Object)"roleId");
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>(objectArray.length);
        for (Object object : objectArray) {
            try {
                ResultItem resultItem = this.getResultItemFromVc(object, Integer.parseInt(string));
                arrayList.add(resultItem);
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to get role info: ", (Throwable)exception);
                resultSet.error = exception;
            }
        }
        resultSet.items = (ResultItem[])ArrayUtil.toArray(arrayList, ResultItem.class);
        return resultSet;
    }

    private ResultItem getResultItemFromVc(Object object, int n) throws Exception {
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = managedObjectReference;
        AuthorizationManager authorizationManager = VCAuthorizationUtil.getAuthorizationManager(managedObjectReference.getServerGuid());
        PermissionForRoleData permissionForRoleData = authorizationManager.retrieveRolePermissions(n);
        if (permissionForRoleData == null || ((AuthorizationManager.Permission[])permissionForRoleData).length == 0) {
            return resultItem;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AuthorizationManager.Permission permission : permissionForRoleData) {
            arrayList.add(this.remapProviderIfNeeded(permission.entity));
        }
        PermissionForRoleData permissionForRoleData2 = new PermissionForRoleData();
        permissionForRoleData2.names = this.getNames(ArrayUtil.toArray(arrayList, Object.class));
        permissionForRoleData2.permissions = VCAuthorizationUtil.toPermissionData((AuthorizationManager.Permission[])permissionForRoleData);
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = PERM_FOR_ROLE;
        propertyValue.value = permissionForRoleData2;
        resultItem.properties = new PropertyValue[]{propertyValue};
        return resultItem;
    }

    private String getVCName(ManagedObjectReference managedObjectReference) {
        String string = VcServiceUtil.getServiceName((String)managedObjectReference.getServerGuid());
        return string;
    }

    private ResultItem getResultItemFromAuthz(Object object, String string) throws Exception {
        PermissionTypes.Info info2;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = object;
        AuthorizationService authorizationService = this._authzMgr.getSolutionService(object);
        Permission permission = authorizationService.getPermissionManger();
        List list = permission.listDetail();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<PermissionData> arrayList2 = new ArrayList<PermissionData>();
        for (PermissionTypes.Info info2 : list) {
            for (String string2 : info2.getRoleId()) {
                if (string2 == null || !string2.equals(string)) continue;
                Object object2 = this.remapProviderIfNeeded(authorizationService.getReference(info2.getResourceId()));
                arrayList.add(object2);
                PermissionData permissionData = VCAuthorizationUtil.toPermissionData(info2, authorizationService);
                permissionData.entity = object2;
                arrayList2.add(permissionData);
            }
        }
        PermissionForRoleData permissionForRoleData = new PermissionForRoleData();
        permissionForRoleData.names = this.getNames(ArrayUtil.toArray(arrayList, Object.class));
        permissionForRoleData.permissions = (PermissionData[])ArrayUtil.toArray(arrayList2, PermissionData.class);
        info2 = new PropertyValue();
        info2.propertyName = PERM_FOR_ROLE;
        info2.value = permissionForRoleData;
        resultItem.properties = new PropertyValue[]{info2};
        return resultItem;
    }

    private Object remapProviderIfNeeded(Object object) {
        ManagedObjectReference managedObjectReference;
        if (object instanceof ManagedObjectReference && ManagedObjectUtil.isOfType((ManagedObjectReference)(managedObjectReference = (ManagedObjectReference)object), ComputeResource.class)) {
            object = this.getHostEntityFromResource(managedObjectReference);
        }
        return object;
    }

    private ManagedObjectReference getHostEntityFromResource(ManagedObjectReference managedObjectReference) {
        try {
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            Object[] objectArray = computeResource.getHost();
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                _logger.debug((Object)"Could not find host ref");
                return managedObjectReference;
            }
            return objectArray[0];
        }
        catch (Exception exception) {
            _logger.debug((Object)"Provided compute resource couldn't be converted to host");
            return managedObjectReference;
        }
    }

    private NameValuePair[] getNames(Object[] objectArray) throws Exception {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            ManagedObjectReference managedObjectReference;
            Object object2 = objectArray2[i];
            if (object2 instanceof ManagedObjectReference && ManagedObjectUtil.isRootFolder((ManagedObjectReference)(managedObjectReference = (ManagedObjectReference)object2))) {
                arrayList.add(new NameValuePair(this.getVCName(managedObjectReference), (Object)managedObjectReference));
                continue;
            }
            String string = this._objectReferenceService.getUid(object2);
            hashMap.put(string, object2);
        }
        if (hashMap.size() == 0) {
            return arrayList.toArray(new NameValuePair[arrayList.size()]);
        }
        for (Object object : objectArray2 = this._queryExecutor.getProperty(hashMap.values().toArray(), NAME_PROPERTY)) {
            if (((PropertyValue)object).value != null) {
                arrayList.add(new NameValuePair(((PropertyValue)object).value.toString(), ((PropertyValue)object).resourceObject));
                continue;
            }
            arrayList.add(new NameValuePair("null", ((PropertyValue)object).resourceObject));
        }
        return arrayList.toArray(new NameValuePair[arrayList.size()]);
    }
}

