/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.tasks.impl;

import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TaskMonitorImpl
implements TaskMonitor {
    private DataService _dataService;

    public TaskMonitorImpl(DataService dataService) {
        this._dataService = dataService;
    }

    @Override
    public List<TaskInfo> monitorTasks(List<ManagedObjectReference> list) throws Exception {
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        arrayList = this.monitorTasksCompletion(list, this._dataService);
        return arrayList;
    }

    @Override
    public TaskInfo monitorTask(ManagedObjectReference managedObjectReference) throws Exception {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        arrayList.add(managedObjectReference);
        List<TaskInfo> list = this.monitorTasks(arrayList);
        return list.get(0);
    }

    private ArrayList<TaskInfo> monitorTasksCompletion(List<ManagedObjectReference> list, DataService dataService) throws Exception {
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>();
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>(list);
        while (!hashSet.isEmpty()) {
            PropertyValue[] propertyValueArray;
            boolean bl = false;
            Object[] objectArray = hashSet.toArray(new ManagedObjectReference[0]);
            for (PropertyValue propertyValue : propertyValueArray = QueryUtil.getProperty((DataService)dataService, (Object[])objectArray, (String)"info")) {
                ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
                TaskInfo taskInfo = (TaskInfo)propertyValue.value;
                if (TaskMonitorImpl.isTaskCompleted(taskInfo)) {
                    arrayList.add(taskInfo);
                    hashSet.remove(managedObjectReference);
                    continue;
                }
                bl = true;
            }
            try {
                if (!bl) continue;
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return arrayList;
    }

    private static boolean isTaskCompleted(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return false;
        }
        return taskInfo.state == TaskInfo.State.error || taskInfo.state == TaskInfo.State.success;
    }
}

