/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vcservice;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.Optional;
import com.vmware.vise.vim.commons.vcservice.impl.VcSsoDomainFinder;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.vsphere.internal.Config;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceVcSsoDomainFinder
implements VcSsoDomainFinder {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final LookupService _lookupService;
    private final LoadingCache<String, Optional<SsoDomain>> _cacheSsoDomainsByServiceGuid;

    public LookupServiceVcSsoDomainFinder(@Nonnull LookupService lookupService) {
        Validate.notNull((Object)lookupService);
        this._lookupService = lookupService;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(200L);
        if (Config.LS_VC_SSO_DOMAIN_FINDER_CACHE_EXPIRATION_IN_SECONDS >= 0L) {
            cacheBuilder.expireAfterWrite(Config.LS_VC_SSO_DOMAIN_FINDER_CACHE_EXPIRATION_IN_SECONDS, TimeUnit.SECONDS);
        }
        this._cacheSsoDomainsByServiceGuid = cacheBuilder.build((CacheLoader)new CacheLoader<String, Optional<SsoDomain>>(){

            public Optional<SsoDomain> load(String string) throws Exception {
                Validate.notNull((Object)string, (String)"serviceId is null");
                ServiceRegistration.Info[] infoArray = LookupUtil.find((LookupService)LookupServiceVcSsoDomainFinder.this._lookupService, (ServiceRegistration.ServiceType)LookupUtil.VCENTER);
                if (infoArray != null) {
                    for (ServiceRegistration.Info info : infoArray) {
                        if (!string.equals(info.getServiceId())) continue;
                        SsoDomain ssoDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)info).orElse(null);
                        if (ssoDomain != null) {
                            return Optional.of((Object)ssoDomain);
                        }
                        _logger.warn((Object)("The LS service registration for VC with guid " + string + " doesn't contain domain data"));
                        return Optional.empty();
                    }
                }
                throw new IllegalArgumentException("Couldn't find VC with guid " + string);
            }
        });
    }

    public Optional<SsoDomain> findDomainByServiceGuid(String string) {
        Validate.notNull((Object)string, (String)"serviceGuid is null");
        try {
            Optional optional = (Optional)this._cacheSsoDomainsByServiceGuid.get((Object)string);
            return optional;
        }
        catch (ExecutionException executionException) {
            _logger.error((Object)("Couldn't determine the domain of VC with guid " + string));
            return Optional.empty();
        }
    }
}

