/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vsphere.internal;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.Timeout;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "vim-services-vsphere.properties";
    public static final Timeout VC_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT;
    public static final Timeout VC_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT;
    public static final long LS_VC_SSO_DOMAIN_FINDER_CACHE_EXPIRATION_IN_SECONDS;

    private static void logWarningIfSocketTimeoutValueExceedsInteger(String string, long l) {
        if (l > Integer.MAX_VALUE) {
            _logger.warn((Object)("Property '" + string + "' has a value of " + l + " which exceeds the maximum for the int type. The value will be truncated to " + Integer.MAX_VALUE + " when used to set the corresponding socket timeout."));
        }
    }

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties((ClassLoader)classLoader, (String)CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        String string = "vim.services.vc.extension.manager.socket.connection.timeout";
        long l = PropertyUtil.getLongProperty((Properties)properties, (String)string, (long)Timeout.DEFAULT.toMillis());
        Config.logWarningIfSocketTimeoutValueExceedsInteger(string, l);
        VC_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT = Timeout.valueOf((long)l);
        string = "vim.services.vc.extension.manager.socket.timeout";
        l = PropertyUtil.getLongProperty((Properties)properties, (String)string, (long)Timeout.DEFAULT.toMillis());
        Config.logWarningIfSocketTimeoutValueExceedsInteger(string, l);
        VC_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT = Timeout.valueOf((long)l);
        LS_VC_SSO_DOMAIN_FINDER_CACHE_EXPIRATION_IN_SECONDS = PropertyUtil.getLongProperty((Properties)properties, (String)"LookupServiceVcSsoDomainFinder.cacheExpiration", (long)600L);
    }
}

