/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.types;

import com.vmware.ph.client.api.commondataformat.Governed;
import com.vmware.ph.client.api.commondataformat.Id;
import com.vmware.ph.client.api.commondataformat.Immutable;
import com.vmware.ph.client.api.commondataformat.Nullable;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Identifiable;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class FreeFormData
implements CdfAble,
Identifiable {
    @Governed.Value
    private final String type;
    @Governed.Format
    @Id.Scope.Universe
    private final String id;
    private final List<AnyPrimitive[]> data;

    public FreeFormData(String type, String id, @Nullable AnyPrimitive[] data) {
        this(type, id, data != null ? Collections.singletonList(data) : null);
    }

    public FreeFormData(String type, String id, @Nullable List<AnyPrimitive[]> data) {
        Util.throwOnBlankString(type, "The type must not be blank.");
        Util.throwOnBlankString(id, "The id must not be blank.");
        this.type = type;
        this.id = id;
        this.data = data == null ? AnyPrimitive.EMPTY_TABLE : this.deepCopy(data);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<AnyPrimitive[]> getData() {
        return this.deepCopy(this.data);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append(this.type).append(this.id);
        for (Object[] objectArray : this.data) {
            builder.append(objectArray);
        }
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FreeFormData)) {
            return false;
        }
        FreeFormData other = (FreeFormData)obj;
        if (other.data.size() != this.data.size()) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder().append(this.type, other.type).append(this.id, other.id);
        int i = 0;
        for (Object[] objectArray : this.data) {
            builder.append(objectArray, other.data.get(i++));
        }
        return builder.isEquals();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FreeFormData [type=" + this.type + ", id=" + this.id + ", data=[");
        for (AnyPrimitive[] row : this.data) {
            sb.append(Arrays.asList(row));
        }
        sb.append("]");
        return sb.toString();
    }

    private List<AnyPrimitive[]> deepCopy(List<AnyPrimitive[]> data) {
        ArrayList<AnyPrimitive[]> copy = new ArrayList<AnyPrimitive[]>(data.size());
        for (AnyPrimitive[] row : data) {
            if (row == null) continue;
            copy.add(Arrays.copyOf(row, row.length));
        }
        return copy;
    }
}

