/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.types;

import com.vmware.ph.client.api.commondataformat.Governed;
import com.vmware.ph.client.api.commondataformat.Id;
import com.vmware.ph.client.api.commondataformat.Immutable;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Identifiable;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.RelatedResource;
import com.vmware.ph.client.api.util.Util;
import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public class Resource
implements CdfAble,
Identifiable {
    @Governed.Value
    private final String type;
    @Governed.Format
    @Id.Scope.Universe
    private final String id;
    private final KeyValue[] attributes;
    private final RelatedResource[] relations;

    public Resource(String type, String id, KeyValue[] attributes, RelatedResource[] relations) {
        Util.throwOnBlankString(type, "The type must not be blank.");
        Util.throwOnBlankString(id, "The id must not be blank.");
        this.type = type;
        this.id = id;
        this.attributes = attributes == null ? KeyValue.EMPTY_ARRAY : attributes;
        this.relations = relations == null ? RelatedResource.EMPTY_ARRAY : relations;
    }

    public Resource(String type, String id, Object ... keysAndValues) {
        this(type, id, KeyValue.fromArray(keysAndValues), null);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public KeyValue[] getAttributes() {
        return Arrays.copyOf(this.attributes, this.attributes.length);
    }

    public RelatedResource[] getRelations() {
        return Arrays.copyOf(this.relations, this.relations.length);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        return reflectionToStringBuilder.toString();
    }

    @Immutable
    public static class KeyValue {
        public static final KeyValue[] EMPTY_ARRAY = new KeyValue[0];
        @Governed.Value
        private final String key;
        @Governed.Format
        private final AnyPrimitive value;

        public KeyValue(String key, AnyPrimitive value) {
            Util.throwOnBlankString(key, "The key must not be null.");
            if (null == value) {
                throw new IllegalArgumentException("The value cannot be null.");
            }
            this.key = key;
            this.value = value;
        }

        public static KeyValue[] fromArray(Object[] keysAndValues) {
            if (null == keysAndValues) {
                throw new IllegalArgumentException("keysAndValues cannot be null.");
            }
            if (0 != keysAndValues.length % 2) {
                throw new IllegalArgumentException("keysAndValues must contain an even number of elements.");
            }
            KeyValue[] res = new KeyValue[keysAndValues.length / 2];
            for (int i = 0; i < keysAndValues.length; i += 2) {
                Object k = keysAndValues[i];
                if (null == k || !String.class.isAssignableFrom(k.getClass())) {
                    throw new IllegalArgumentException("Key-value array provided should contain keys on every even position and a value on every odd position. Position " + i + " is supposed to be String but it is " + k);
                }
                Object v = keysAndValues[i + 1];
                AnyPrimitive ap = AnyPrimitive.fromObject(v);
                res[i / 2] = new KeyValue((String)k, ap);
            }
            return res;
        }

        public String getKey() {
            return this.key;
        }

        public AnyPrimitive getValue() {
            return this.value;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
        }

        public String toString() {
            ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
            reflectionToStringBuilder.setExcludeFieldNames("EMPTY_ARRAY");
            return reflectionToStringBuilder.toString();
        }
    }
}

