/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.impl;

import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.exceptions.PhClientException;
import com.vmware.ph.client.api.impl.PhClientImpl;
import com.vmware.ph.client.extension.ExtensionUtil;
import com.vmware.ph.client.upload.impl.UploaderFactory;
import com.vmware.ph.common.StringUtil;
import com.vmware.ph.common.audit.AuditFileConfig;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.extension.AuditFilePayloadExtension;
import com.vmware.ph.upload.UploaderAbstractFactory;
import com.vmware.ph.upload.service.UploadService;
import com.vmware.ph.upload.service.UploadServiceBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.annotation.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PhClientBuilder
implements Cloneable {
    public static final String CLIENT_CONFIG_PROPERTIES = "client-config.properties";
    static final String PH_PRODUCTION_SERVER_URL_KEY = "ph-prod-server.url";
    static final String PH_TEST_SERVER_URL_KEY = "ph-test-server.url";
    static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static PropertiesLoader propertiesLoader = new PropertiesLoader();
    private static TempFolderSystemPropertyLoader tempFolderLoader = new TempFolderSystemPropertyLoader();
    private static final String CEIP_FOLDER = PhClientBuilder.getTempFolderForCeipProgram();
    static final String AUDIT_FOLDER = CEIP_FOLDER + "audit" + File.separator;
    static final String BUFFER_FOLDER = CEIP_FOLDER + "buffering" + File.separator;
    static final String AUDIT_FILE_NAME = "sent-to-vmware.txt";
    static final boolean DEFAULT_AUDIT_FILE_ROTATION_ENABLED = true;
    static final int DEFAULT_AUDIT_FILE_SIZE_LIMIT_BYTES = 0x800000;
    static final int DEFAULT_AUDIT_FILE_HISTORY_COUNT = 3;
    private static final long MINIMAL_BUFFER_SIZE_IN_BYTES = 0x100000L;
    static final long DEFAULT_BUFFER_SIZE_IN_BYTES = 0x500000L;
    static final long DEFAULT_BUFFER_UPLOAD_PERIOD_MILLIS = 604800000L;
    private static final Logger log = LoggerFactory.getLogger(PhClientBuilder.class);
    private final String phServerUrl;
    private final Collector collector;
    private final PhClientImplInstantiator phClientInstantiator;
    private final UploadServiceBuilderInstantiator uploadServiceBuilderInstantiator;
    private final ExtensionUtil extensionUtil = ExtensionUtil.getInstance();
    private ProxySettingsProvider proxySettingsProvider;
    private ProxySettings proxySettings;
    private PayloadAuditPersister payloadAuditPersister;
    private int maxRetries = 3;
    private int maxConnectionsTotal = 30;
    private int maxConnectionsPerRoute = 10;
    private int connectionTimeout = 60000;
    private AuditFileConfig auditFileConfig;
    private long bufferSizeInBytes = 0x500000L;
    private long bufferUpoadPeriodMillis = 604800000L;
    private String bufferFolder;
    private KeyStore ks;
    private CeipConfigProvider ceipConfigProvider;

    private PhClientBuilder(String phServerUrl, Collector collector) {
        if (StringUtil.isEmptyOrNull(phServerUrl)) {
            throw new Bug("The phServerUrl is null and this is a bug. As a result the PhClient creation cannot be done. Please contact the PhoneHome team.");
        }
        this.phServerUrl = phServerUrl;
        this.collector = collector;
        this.phClientInstantiator = new PhClientImplInstantiator();
        this.uploadServiceBuilderInstantiator = new UploadServiceBuilderInstantiator();
        this.auditFileConfig = new AuditFileConfig(AUDIT_FOLDER + collector.getCollectorId() + File.separator + AUDIT_FILE_NAME, true, 0x800000, 3);
        this.bufferFolder = BUFFER_FOLDER + collector.getCollectorId() + File.separator;
        this.ceipConfigProvider = new CeipConfigProvider(){

            @Override
            public boolean isCeipEnabled() {
                return true;
            }
        };
    }

    public static PhClientBuilder create(Environment env, Collector collector) {
        Properties props = propertiesLoader.loadConfigProps(CLIENT_CONFIG_PROPERTIES);
        String serverUrl = null;
        serverUrl = Environment.PRODUCTION.equals((Object)env) ? props.getProperty(PH_PRODUCTION_SERVER_URL_KEY) : props.getProperty(PH_TEST_SERVER_URL_KEY);
        if (serverUrl == null) {
            throw new PhClientException("The PhClientBuilder is configured with empty serverUrl property. This is not programatically recoverable error and the program cannot continue. This issue may occur if the configuration file client-config.properties is missing from the classpath, or if its content is incorrectly changed. Please contact the PH library dev team.");
        }
        return new PhClientBuilder(serverUrl, collector);
    }

    public static PhClientBuilder createForCustomServer(String serverUrl, Collector collector) {
        return new PhClientBuilder(serverUrl, collector);
    }

    public PhClientBuilder setProxyProvider(ProxySettingsProvider proxySettingsProvider) {
        Validate.notNull(proxySettingsProvider);
        this.proxySettingsProvider = proxySettingsProvider;
        return this;
    }

    public PhClientBuilder setPayloadAuditPersister(PayloadAuditPersister payloadAuditPersister) {
        Validate.notNull(payloadAuditPersister);
        this.payloadAuditPersister = payloadAuditPersister;
        return this;
    }

    public PhClientBuilder setProxySettings(ProxySettings proxySettings) {
        Validate.notNull(proxySettings);
        this.proxySettings = proxySettings;
        return this;
    }

    public PhClientBuilder setMaxRetries(int maxRetries) {
        Validate.isTrue(maxRetries > 0, "The maxRetries argument must be a non-zero, positive interger.");
        this.maxRetries = maxRetries;
        return this;
    }

    public PhClientBuilder setAuditFileConfig(AuditFileConfig config) {
        Validate.notNull(config);
        this.auditFileConfig = config;
        return this;
    }

    public PhClientBuilder setBufferSizeInBytes(long bufferSizeInBytes) {
        if (bufferSizeInBytes < 0x100000L) {
            throw new IllegalArgumentException("The buffering API needs at least 1048576 bytes of size to function correctly. The provided value is lower and as a result the PhClient creation fails. Please provide a value that larger or equal to the minimal.");
        }
        this.bufferSizeInBytes = bufferSizeInBytes;
        return this;
    }

    public PhClientBuilder setBufferUploadPeriodMillis(long bufferUploadPeriodMillis) {
        if (bufferUploadPeriodMillis < 0L) {
            throw new IllegalArgumentException("bufferUploadPeriodMillis is the period of time in milliseconds since the last upload of buffered data, after which another upload attempt will be executed. It must be positive, but it is = " + bufferUploadPeriodMillis + ". Please pass a positive value.");
        }
        this.bufferUpoadPeriodMillis = bufferUploadPeriodMillis;
        return this;
    }

    public PhClientBuilder setBufferFolder(String bufferFolder) {
        if (StringUtil.isEmptyOrNull(bufferFolder)) {
            throw new IllegalArgumentException("You are trying to change the default buffer folder, but the provided bufferFolder value is blank. The Buffering API cannot work without a buffer folder and as a result the PhClient cannot be created. Please provide a non-blank value for bufferFolder, or not call this method and use the default $TMP subfolder value.");
        }
        this.bufferFolder = bufferFolder;
        return this;
    }

    public PhClientBuilder setMaxConnectionsTotal(int maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
        return this;
    }

    public PhClientBuilder setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    public PhClientBuilder setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public PhClientBuilder setCeipConfigProvider(CeipConfigProvider ceipConfigProvider) {
        Validate.notNull(ceipConfigProvider);
        this.ceipConfigProvider = ceipConfigProvider;
        return this;
    }

    public PhClientBuilder setAcceptedIssuers(X509Certificate[] trustedCertificates) throws CertificateException {
        Validate.notEmpty(trustedCertificates);
        Validate.noNullElements(trustedCertificates);
        try {
            this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
            this.ks.load(null, null);
            int cnt = 1;
            for (X509Certificate cert : trustedCertificates) {
                this.ks.setCertificateEntry(cert.getSubjectDN().getName() + "_" + cnt++, cert);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException e) {
            String msg = "This should never happen. You should investigate further: " + e.getMessage();
            log.error(msg, (Throwable)e);
            throw new Bug(msg, e);
        }
        return this;
    }

    public PhClient build() {
        log.debug("building PhClientImpl with audit file : " + this.auditFileConfig.getFilePath());
        log.debug("building PhClientImpl with buffering folder : " + this.bufferFolder);
        this.initPayloadAuditPersister();
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder builder = this.uploadServiceBuilderInstantiator.create(this.phServerUrl, uploaderFactory);
        log.debug("building PhClientImpl with ssl CA keystore: {}", (Object)this.ks);
        if (this.ks != null) {
            try {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(this.ks);
                TrustManager[] trustManagers = factory.getTrustManagers();
                builder.withTrustManagers(trustManagers);
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                String message = "Intialization of TrustManagerFactory failed beacause of " + e.getMessage() + ". Please, contact the system administrators with this error.";
                log.error(message, (Throwable)e);
                throw new Bug(message, e);
            }
        }
        builder.withMaxConnectionsPerRoute(this.maxConnectionsPerRoute).withMaxRetries(this.maxRetries).withConnectionTimeout(this.connectionTimeout).withMaxConnectionsTotal(this.maxConnectionsTotal);
        if (this.proxySettings != null) {
            builder.withProxySettings(this.proxySettings);
        } else {
            builder.withProxyProvider(this.proxySettingsProvider);
        }
        UploadService uploadService = builder.build();
        return this.phClientInstantiator.createPhClient(this.payloadAuditPersister, uploadService, this.collector, this.bufferUpoadPeriodMillis, this.bufferSizeInBytes, this.bufferFolder, this.ceipConfigProvider);
    }

    private void initPayloadAuditPersister() {
        if (this.payloadAuditPersister == null) {
            AuditFilePayloadExtension extension = this.extensionUtil.loadExtension(AuditFilePayloadExtension.class);
            if (extension == null) {
                log.debug("No PayloadAuditExtension loaded. Audit is disabled - using PayloadAuditPersister.NO_AUDIT.");
                this.payloadAuditPersister = PayloadAuditPersister.NO_AUDIT;
            } else {
                log.debug("PayloadAuditExtension successfully loaded. Setting auditFileConfig to it with filePath = {}", (Object)this.auditFileConfig.getFilePath());
                extension.setAuditFileConfiguration(this.auditFileConfig);
                this.payloadAuditPersister = extension;
            }
        }
    }

    static String getTempFolderForCeipProgram() {
        String baseFolder = tempFolderLoader.getTempFolderSystemProperty();
        if (StringUtils.isBlank(baseFolder)) {
            baseFolder = File.separator;
        } else if (!baseFolder.endsWith(File.separator)) {
            baseFolder = baseFolder + File.separator;
        }
        String result = baseFolder + "vmware" + File.separator + "ceip" + File.separator;
        return result;
    }

    static class TempFolderSystemPropertyLoader {
        TempFolderSystemPropertyLoader() {
        }

        public String getTempFolderSystemProperty() {
            return System.getProperty(PhClientBuilder.JAVA_IO_TMPDIR);
        }
    }

    static class InputStreamLoader {
        InputStreamLoader() {
        }

        public InputStream load(String fileName) {
            ClassLoader classLoader = PhClientBuilder.class.getClassLoader();
            return classLoader.getResourceAsStream(fileName);
        }
    }

    static class UploadServiceBuilderInstantiator {
        UploadServiceBuilderInstantiator() {
        }

        public UploadServiceBuilder create(String phServerUrl, UploaderAbstractFactory uploaderFactory) {
            return UploadServiceBuilder.createForCustomServer(phServerUrl, uploaderFactory);
        }
    }

    static class PhClientImplInstantiator {
        PhClientImplInstantiator() {
        }

        public PhClientImpl createPhClient(PayloadAuditPersister persister, UploadService uploadService, Collector collecor, long bufferUploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, CeipConfigProvider ceipConfigProvider) {
            return new PhClientImpl(persister, uploadService, collecor, bufferUploadPeriodMillis, bufferSizeInBytes, bufferFolder, ceipConfigProvider);
        }
    }

    static class PropertiesLoader {
        private final InputStreamLoader inputStreamLoader = new InputStreamLoader();

        PropertiesLoader() {
        }

        public Properties loadConfigProps(String propertiesFileName) {
            Properties props;
            block15: {
                props = new Properties(System.getProperties());
                try (InputStream inputStream = this.inputStreamLoader.load(propertiesFileName);){
                    if (inputStream != null) {
                        props.load(inputStream);
                        break block15;
                    }
                    throw new Bug(String.format("Failed to load the config '%s'", propertiesFileName));
                }
                catch (IOException e) {
                    log.error(e.toString(), (Throwable)e);
                    throw new Bug(String.format("Failed to load the config '%s'", propertiesFileName), e);
                }
            }
            return props;
        }
    }

    public static enum Environment {
        PRODUCTION,
        TESTING;

    }
}

