/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.audit;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.serialization.CdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.serialization.PayloadSerializer;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.common.audit.LoggerWriter;
import com.vmware.ph.client.common.audit.exception.InvalidFilePathException;
import com.vmware.ph.common.FileSystemOperationsWrapper;
import com.vmware.ph.common.StringUtil;
import com.vmware.ph.common.audit.AuditFileConfig;
import com.vmware.ph.extension.AuditFilePayloadExtension;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AuditFilePayloadPersister
implements AuditFilePayloadExtension {
    private static final Logger log = LoggerFactory.getLogger(AuditFilePayloadPersister.class);
    private static LoggerWriterFactory loggerWriterFactory = new LoggerWriterFactory();
    private static FileSystemOperationsWrapper fileFactory = new FileSystemOperationsWrapper();
    private AuditFileConfig config;
    private final AtomicBoolean isConfigValidated = new AtomicBoolean(false);
    private final PayloadSerializer serializer = new PayloadSerializer();
    private final CdfSequenceSerializerInstantiator cdfSeqSerializerInstantiator = new CdfSequenceSerializerInstantiator();

    @Deprecated
    public AuditFilePayloadPersister() {
        this(new AuditFileConfig("did-you-forgot-to-call-setAuditFileConfiguration.txt", true, 0x800000, 2));
    }

    public AuditFilePayloadPersister(AuditFileConfig config) {
        this.setAuditFileConfiguration(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuditFileConfiguration(AuditFileConfig config) {
        Class<AuditFilePayloadPersister> clazz = AuditFilePayloadPersister.class;
        synchronized (AuditFilePayloadPersister.class) {
            Validate.notNull(config);
            this.config = config;
            this.isConfigValidated.set(false);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistPayload(Payload payload, PayloadEnvelope envelope) throws IOException {
        Class<AuditFilePayloadPersister> clazz = AuditFilePayloadPersister.class;
        synchronized (AuditFilePayloadPersister.class) {
            this.validateConfig();
            try (LoggerWriter writer = loggerWriterFactory.createLoggerWriter(this.config);){
                CdfSequenceSerializer seqSerializer = this.cdfSeqSerializerInstantiator.getCdfSequenceSerializer(writer);
                this.serializer.serialize(payload, envelope, seqSerializer);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistCdfAble(CdfAble cdf) throws IOException {
        Class<AuditFilePayloadPersister> clazz = AuditFilePayloadPersister.class;
        synchronized (AuditFilePayloadPersister.class) {
            this.validateConfig();
            try (LoggerWriter writer = loggerWriterFactory.createLoggerWriter(this.config);){
                CdfSequenceSerializer sequenceSerializer = this.cdfSeqSerializerInstantiator.getCdfSequenceSerializerNoNamespaces(writer);
                sequenceSerializer.write(cdf);
                sequenceSerializer.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void validateConfig() {
        if (!this.isConfigValidated.get()) {
            AuditFilePayloadPersister.validateFilePath(this.config.getFilePath());
            this.isConfigValidated.set(true);
        }
    }

    static void validateFilePath(String filePath) {
        StringUtil.throwOnBlankString(filePath, "filePath should not be blank.");
        log.debug("validating path to audit file : " + filePath);
        File file = fileFactory.createFileObject(filePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new InvalidFilePathException("The provided audit filePath " + filePath + " exists but is a directory when it should be a file. As a result the audit functionality cannot work properly. A workaround is to delete the directory that coincides with the provided filePath.");
            }
        } else {
            AuditFilePayloadPersister.createParentDirectories(file);
        }
    }

    private static void createParentDirectories(File file) {
        try {
            AuditFilePayloadPersister.createParentDirs(file);
        }
        catch (Exception e) {
            String message = "The parent directories of the audit file " + file.getAbsolutePath() + " cannot be created. As a result the audit operation cannot succeed. A workaround can be to create the parent directories manually and try again.";
            log.error(message, (Throwable)e);
            throw new InvalidFilePathException(message, e);
        }
    }

    private static void createParentDirs(File file) {
        boolean parentDirsCreated;
        if (AuditFilePayloadPersister.isParentDirectoryCreationRequired(file) && !(parentDirsCreated = AuditFilePayloadPersister.createMissingParentDirectories(file))) {
            throw new InvalidFilePathException("Failed to create parent directories for " + file.getAbsolutePath());
        }
    }

    static boolean isParentDirectoryCreationRequired(File file) {
        File parent = file.getParentFile();
        return parent != null && !parent.exists();
    }

    static boolean createMissingParentDirectories(File file) {
        File parent = file.getParentFile();
        return parent.mkdirs();
    }

    static class CdfSequenceSerializerInstantiator {
        CdfSequenceSerializerInstantiator() {
        }

        public CdfSequenceSerializer getCdfSequenceSerializer(Writer writer) throws IOException {
            return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(writer);
        }

        public CdfSequenceSerializer getCdfSequenceSerializerNoNamespaces(Writer writer) throws IOException {
            return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializerNoNamespaces(writer);
        }
    }

    static class LoggerWriterFactory {
        LoggerWriterFactory() {
        }

        public LoggerWriter createLoggerWriter(AuditFileConfig config) throws SecurityException, IOException {
            return new LoggerWriter(config);
        }
    }
}

