/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps;

import com.vmware.ph.client.common.extensions.ps.ProxySettingsValidator;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.upload.HttpClientSetup;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxySettingsValidator
implements ProxySettingsValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultProxySettingsValidator.class);
    public static final int EXPECTED_RESPONSE_CODE = 200;
    private final HttpGet validationRequest;
    private final HttpClientBuilder httpClientBuilder;

    public DefaultProxySettingsValidator(URI uri) {
        this(new HttpGet(uri), HttpClientBuilder.create());
    }

    DefaultProxySettingsValidator(HttpGet validationRequest, HttpClientBuilder httpClientBuilder) {
        this.validationRequest = validationRequest;
        this.httpClientBuilder = httpClientBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(ProxySettings proxySettings, HttpConnectionConfig connectionConfig) {
        boolean bl;
        log.debug("Validating proxy settings: {} ", (Object)proxySettings);
        HttpClientSetup.setupHttpClientBuilder(this.httpClientBuilder, connectionConfig, proxySettings, new BasicCredentialsProvider());
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = this.httpClientBuilder.build();
            log.debug("Executing request {} with proxy settings {}.", (Object)this.validationRequest, (Object)proxySettings);
            response = httpClient.execute(this.validationRequest);
            boolean res = this.processResponse(response);
            log.debug("Result of validating proxySettings {} is '{}'.", (Object)proxySettings, (Object)res);
            bl = res;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                log.debug("An exception was caugh while validating proxy settings {} via request {}. These proxy settings do not ensure connectivity to the requested site and they will not be used for accessing it.", new Object[]{proxySettings, this.validationRequest, e});
                bl2 = false;
            }
            catch (Throwable throwable) {
                this.validationRequest.reset();
                IOUtils.closeQuietly(response);
                IOUtils.closeQuietly(httpClient);
                throw throwable;
            }
            this.validationRequest.reset();
            IOUtils.closeQuietly(response);
            IOUtils.closeQuietly(httpClient);
            return bl2;
        }
        this.validationRequest.reset();
        IOUtils.closeQuietly(response);
        IOUtils.closeQuietly(httpClient);
        return bl;
    }

    protected boolean processResponse(CloseableHttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        log.debug("Validating reachability: {} DONE. Response code {}.", (Object)this.validationRequest, (Object)code);
        boolean res = code == 200;
        return res;
    }
}

