/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery.wpad;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.util.ProxyException;
import com.btr.proxy.util.ProxyUtil;
import com.vmware.ph.client.common.extensions.ps.discovery.wpad.PacScriptDiscoverer;
import com.vmware.ph.client.common.extensions.ps.discovery.wpad.exceptions.WpadException;
import java.net.ProxySelector;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpadProxySearchStrategy
implements ProxySearchStrategy {
    private static final Logger log = LoggerFactory.getLogger(WpadProxySearchStrategy.class);
    private final PacScriptDiscoverer pacScriptDiscoverer;
    private ProxySelector proxySelector = null;

    public WpadProxySearchStrategy(PacScriptDiscoverer pacScriptDiscoverer) {
        this.pacScriptDiscoverer = pacScriptDiscoverer;
    }

    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        if (this.proxySelector == null) {
            try {
                this.proxySelector = this.createWpadSelector();
            }
            catch (WpadException e) {
                throw new ProxyException("Couldn't create WPAD selector.", e);
            }
        }
        return this.proxySelector;
    }

    private ProxySelector createWpadSelector() throws WpadException {
        log.debug("Creating WPAD selector.");
        PacProxySelector result = null;
        URL pacScriptUrl = this.pacScriptDiscoverer.discoverPacScript();
        if (pacScriptUrl != null) {
            log.debug("Found available PAC script on the network.");
            result = ProxyUtil.buildPacSelectorForUrl(pacScriptUrl.toString());
            if (result != null) {
                return result;
            }
            throw new WpadException("Couldn't parse PAC script.");
        }
        log.debug("No PAC script found on the network.");
        return null;
    }
}

