/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;

public class Exceptions {
    public static String getStackTrace(Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String getStackTrace() {
        RuntimeException t = new RuntimeException("stack");
        String prefix = "\t";
        return prefix + Exceptions.getCustomStackTrace(t, prefix, true, 1);
    }

    public static String getCustomStackTrace(Throwable t, String prefixStackElement, boolean skipThrowableName, int skipFromTop) {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        if (!skipThrowableName) {
            result.append(t.toString());
            result.append(NEW_LINE);
        }
        StackTraceElement[] stack = t.getStackTrace();
        String prefix = "";
        for (int i = skipFromTop; i < stack.length; ++i) {
            StackTraceElement element = stack[i];
            result.append(prefix);
            result.append(element);
            result.append(NEW_LINE);
            prefix = prefixStackElement;
        }
        return result.toString();
    }

    public static StackTraceElement getCurrentStackElement() {
        return Exceptions.getStackElement(1);
    }

    public static StackTraceElement getStackElement(int howManyMethodsBack) {
        RuntimeException t = new RuntimeException("stack");
        StackTraceElement el = null;
        try {
            el = t.getStackTrace()[1 + howManyMethodsBack];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return el;
    }

    public static String getCurrentMethodName() {
        return Exceptions.getStackElement(1).getMethodName();
    }

    public static String getCallerMethod(int howManyMethodsBack) {
        StackTraceElement element = Exceptions.getStackElement(howManyMethodsBack + 2);
        return element == null ? null : element.getMethodName();
    }

    public static String toCodeLocation(StackTraceElement element) {
        StringBuilder sb = new StringBuilder();
        if (null != element) {
            String filename = element.getFileName();
            int lineNumber = element.getLineNumber();
            boolean isNative = element.isNativeMethod();
            String methodName = element.getMethodName();
            sb.append(methodName);
            if (isNative) {
                sb.append("(Native Method)");
            } else if (filename != null) {
                sb.append("(");
                sb.append(filename);
                if (lineNumber >= 0) {
                    sb.append(":");
                    sb.append(lineNumber);
                }
                sb.append(")");
            } else {
                sb.append("(Unknown Source)");
            }
        }
        return sb.toString();
    }

    public static <T extends Throwable> void logAsErrorAndThrow(Logger log, String message, T t) throws T {
        if (log.isErrorEnabled()) {
            log.error(message, t);
        }
        throw t;
    }

    public static String getClassName() {
        return Exceptions.getClassName(Exceptions.getStackElement(1).getClass());
    }

    public static String getCurrentLocation() {
        StackTraceElement e = Exceptions.getStackElement(1);
        return e.toString();
    }

    public static String getClassName(Class<?> clazz) {
        return Exceptions.afterLast(".", clazz.getName());
    }

    public static String getClassName(Object obj) {
        String res = null;
        if (null != obj) {
            res = Exceptions.getClassName(obj.getClass());
        }
        return res;
    }

    public static void traceEntering(Logger log) {
        if (log.isTraceEnabled()) {
            log.trace("Entering method " + Exceptions.getCallerMethod(0));
        }
    }

    public static void traceEnteringWithInput(Logger log, String input) {
        if (log.isTraceEnabled()) {
            log.trace("Entering method " + Exceptions.getCallerMethod(0) + " ; " + input);
        }
    }

    public static void traceExiting(Logger log) {
        if (log.isTraceEnabled()) {
            log.trace("Exiting  method " + Exceptions.getCallerMethod(0));
        }
    }

    public static void traceExitingWithResult(Logger log, String result) {
        if (log.isTraceEnabled()) {
            log.trace("Exiting  method " + Exceptions.getCallerMethod(0) + " ; Result= " + result);
        }
    }

    public static Exception getCause(Exception e) throws Exception {
        Throwable cause = e.getCause();
        if (cause == null) {
            throw e;
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw e;
    }

    public static Exception throwCauseIncludingMyStacktrace(Exception e) throws Exception {
        Throwable cause = e.getCause();
        if (cause == null) {
            throw e;
        }
        int lenE = e.getStackTrace().length;
        int lenCause = cause.getStackTrace().length;
        StackTraceElement[] combined = new StackTraceElement[lenE + lenCause];
        System.arraycopy(e.getStackTrace(), 0, combined, 0, lenE);
        System.arraycopy(cause.getStackTrace(), 0, combined, lenE, lenCause);
        cause.setStackTrace(combined);
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        throw e;
    }

    private static String afterLast(String subStr, String str) {
        String result = str;
        int lastIndex = str.lastIndexOf(subStr);
        int lenStr = str.length();
        if (-1 != lastIndex && lastIndex != lenStr) {
            result = str.substring(lastIndex + subStr.length());
        }
        return result;
    }
}

