/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.upload;

import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Exceptions;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.UploadState;
import com.vmware.ph.upload.Uploader;
import com.vmware.ph.upload.exception.UploadFailedException;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUploader
implements Uploader {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String protocol;
    protected final String host;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final String deploymentTypeFolderPrefix;
    protected final UploadState uploadState;
    protected final ProxySettings proxySettings;
    protected final int maxResumesBeforeFailure;
    protected final long chunkSize;

    public AbstractUploader(String protocol, String host, int port, String username, String password, long chunkSize, ProxySettings ps, String deploymentTypeFolderPrefix, TransferProgressListener progressListener, int maxResumesBeforeFailure) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.proxySettings = ps;
        this.chunkSize = chunkSize;
        this.deploymentTypeFolderPrefix = deploymentTypeFolderPrefix;
        this.uploadState = new UploadState(progressListener);
        this.maxResumesBeforeFailure = maxResumesBeforeFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadStream(InputStream stream, File destinationFile, boolean shouldCreateFolder, ProxySettings proxySettings) throws UploadFailedException {
        Exceptions.traceEnteringWithInput(this.log, "uploadStream, remoteFile=" + destinationFile.getPath() + ", proxySettings=" + proxySettings);
        String res = "FAILED";
        try {
            this.uploadOverride(stream, destinationFile, shouldCreateFolder, proxySettings);
            res = "SUCCESS";
        }
        catch (Exception e) {
            UploadFailedException ufe = this.toUploadFailedException(e);
            Exceptions.logAsErrorAndThrow(this.log, "Upload failed. Could not upload stream to " + destinationFile.getAbsolutePath(), ufe);
        }
        finally {
            Exceptions.traceExitingWithResult(this.log, res);
        }
    }

    protected static String getDomainOnly(String usernameWithDomain) {
        String[] userAndDomain = usernameWithDomain.split("@");
        String domain = 1 < userAndDomain.length ? userAndDomain[1] : "";
        return domain;
    }

    protected static String getUsernameWithoutDomain(String usernameWithDomain) {
        String[] userAndDomain = usernameWithDomain.split("@");
        String user = userAndDomain[0];
        return user;
    }

    protected String toUnixPathIfNeeded(String pathName) {
        String os;
        if (null != pathName && null != (os = System.getProperty("os.name")) && os.toLowerCase().startsWith("windows")) {
            pathName = pathName.replace("\\", "/");
        }
        return pathName;
    }

    private UploadFailedException toUploadFailedException(Exception e) {
        UploadFailedException ufe = e instanceof UploadFailedException ? (UploadFailedException)e : new UploadFailedException(e);
        return ufe;
    }

    protected abstract void uploadOverride(InputStream var1, File var2, boolean var3, ProxySettings var4) throws Exception;
}

