/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.util.UUIDable;

public class NonSerializables {
    private static final Cache<UUID, Object> registry = CacheBuilder.newBuilder().weakValues().build();

    public static final Object get(UUID key) {
        return registry.getIfPresent(key);
    }

    public static final UUID getKey(Object obj) {
        ConcurrentMap<UUID, Object> map = registry.asMap();
        for (UUID key : map.keySet()) {
            if (obj != map.get(key)) continue;
            return key;
        }
        return null;
    }

    public static final UUID register(Object obj) {
        UUID key;
        if (obj instanceof UUIDable) {
            key = ((UUIDable)obj).getUUID();
            if (NonSerializables.get(key) == null) {
                registry.put(key, obj);
            }
        } else {
            key = NonSerializables.getKey(obj);
            if (key == null) {
                key = UUID.randomUUID();
                registry.put(key, obj);
            }
        }
        return key;
    }

    private NonSerializables() {
    }
}

