/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.model.VmMoveEntityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MoveEntityInfo {
    public ManagedObjectReference moveEntity;
    public ManagedObjectReference hostedObject;
    public ManagedObjectReference hostedVmFolder;
    public ManagedObjectReference destinationObject;
    public String[] moveEntityPrivileges;
    public String[] hostedObjectPrivileges;
    public String[] hostedVmFolderPrivileges;
    public String[] destinationObjectPrivileges;

    public MoveEntityInfo(ManagedObjectReference moveEntity, ManagedObjectReference hostedObject, ManagedObjectReference hostedVmFolder, ManagedObjectReference destinationObject) {
        this.moveEntity = moveEntity;
        this.hostedObject = hostedObject;
        this.hostedVmFolder = hostedVmFolder;
        this.destinationObject = destinationObject;
    }

    public boolean isValid() {
        if (this.moveEntity == null || this.destinationObject == null || this.moveEntity.equals((Object)this.destinationObject)) {
            return false;
        }
        boolean hostedVmFolderCheck = this.hostedVmFolder == null || !this.hostedVmFolder.equals((Object)this.destinationObject);
        return hostedVmFolderCheck && (this.hostedObject == null || !this.hostedObject.equals((Object)this.destinationObject));
    }

    public static List<MoveEntityInfo> buildMoveEntityInfo(Collection<VmMoveEntityData> moveEntitiesData, ManagedObjectReference target) {
        ArrayList<MoveEntityInfo> moveEntities = new ArrayList<MoveEntityInfo>();
        for (VmMoveEntityData moveEntityData : moveEntitiesData) {
            ManagedObjectReference hostedVmFolder = MoveEntityInfo.getHostedVmFolder(moveEntityData.vmFolders, moveEntityData.datacenter);
            ManagedObjectReference hostedObject = MoveEntityInfo.getVmHostedObject(moveEntityData);
            MoveEntityInfo moveEntity = new MoveEntityInfo(moveEntityData.vmRef, hostedObject, hostedVmFolder, target);
            if (!moveEntity.isValid()) continue;
            moveEntities.add(moveEntity);
        }
        return moveEntities;
    }

    private static ManagedObjectReference getHostedVmFolder(ManagedObjectReference[] vmFolders, ManagedObjectReference datacenter) {
        if (vmFolders == null) {
            return null;
        }
        if (vmFolders.length == 1) {
            return datacenter;
        }
        return vmFolders[0];
    }

    private static ManagedObjectReference getVmHostedObject(VmMoveEntityData moveEntityData) {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveEntityData.resourcePool, VirtualApp.class)) {
            return moveEntityData.resourcePool;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveEntityData.rpParent, ClusterComputeResource.class)) {
            return moveEntityData.rpParent;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveEntityData.rpParent, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moveEntityData.rpParent, VirtualApp.class)) {
            return moveEntityData.resourcePool;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveEntityData.rpParent, ComputeResource.class)) {
            return moveEntityData.parentHost;
        }
        return moveEntityData.resourcePool;
    }
}

