/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.GuestInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VmPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String IS_VM_CONNECTED = "isVmConnected";
    private static final String IS_MIGRATE_AVAILABLE = "isMigrateAvailable";
    private static final String INSTALL_AVAILABLE = "installAvailable";
    private static final String UPGRADE_AVAILABLE = "upgradeAvailable";
    private static final String IS_INSTALL_UPGRADE_VM_TOOLS_AVAILABLE = "isInstallUpgradeVmToolsAvailable";
    private static final String IS_UNMOUNT_VM_TOOLS_AVAILABLE = "isUnmountVmToolsAvailable";
    private static final String IS_CANCEL_HARDWARE_UPGRADE_AVAILABLE = "isCancelHardwareUpgradeAvailable";
    private static final String IS_QUESTION_AVAILABLE = "isQuestionAvailable";
    private static final String IS_TAKE_SNAPSHOT_AVAILABLE = "isTakeSnapshotAvailable";
    private static final String IS_MANAGE_SNAPSHOT_AVAILABLE = "isManageSnapshotsAvailable";
    private static final String IS_REVERT_TO_LATEST_SNAPSHOT_AVAILABLE = "isRevertToLatestSnapshotAvailable";
    private static final String CONNECTION_STATE_PROP = "runtime/connectionState";
    private static final String IS_TEMPLATE_PROP = "config/template";
    private static final String IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP = "isNormalVMOrPrimaryFTVM";
    private static final String TOOLS_INSTALLER_MOUNTED_PROP = "runtime/toolsInstallerMounted";
    private static final String POWER_STATE_PROP = "powerState";
    private static final String TOOLS_RUNNING_STATUS_PROP = "toolsRunningStatus";
    private static final String TOOLS_VERSION_STATUS_PROP = "toolsVersionStatus";
    private static final String CONFIG_SCHEDULE_INFO_KEY_PROP = "config/scheduledHardwareUpgradeInfo/versionKey";
    private static final String QUESTION_ID_PROP = "runtime/question/id";
    private static final String MULTIPLE_SNAPSHOTS_SUPPORTED_PROP = "capability/multipleSnapshotsSupported";
    private static final String FT_STATE_PROP = "runtime/faultToleranceState";
    private static final String FT_INFO_PROP = "config/ftInfo";
    private static final String CURRENT_SNAPSHOT_PROP = "snapshot/currentSnapshot";
    private final DataServiceExtensionRegistry _dsExtensionRegistry;

    public VmPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        this._dsExtensionRegistry = registry;
        this._dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo tInfo = new TypeInfo();
        tInfo.type = VirtualMachine.class.getSimpleName();
        tInfo.properties = new String[]{IS_VM_CONNECTED, IS_MIGRATE_AVAILABLE, INSTALL_AVAILABLE, UPGRADE_AVAILABLE, IS_INSTALL_UPGRADE_VM_TOOLS_AVAILABLE, IS_UNMOUNT_VM_TOOLS_AVAILABLE, IS_CANCEL_HARDWARE_UPGRADE_AVAILABLE, IS_QUESTION_AVAILABLE, IS_TAKE_SNAPSHOT_AVAILABLE, IS_MANAGE_SNAPSHOT_AVAILABLE, IS_REVERT_TO_LATEST_SNAPSHOT_AVAILABLE};
        DerivedPropertyInfo isVmConnectedPropInfo = new DerivedPropertyInfo();
        isVmConnectedPropInfo.propertyName = IS_VM_CONNECTED;
        isVmConnectedPropInfo.sourcePropertyNames = new String[]{CONNECTION_STATE_PROP};
        DerivedPropertyInfo isMigrateAvailablePropInfo = new DerivedPropertyInfo();
        isMigrateAvailablePropInfo.propertyName = IS_MIGRATE_AVAILABLE;
        isMigrateAvailablePropInfo.sourcePropertyNames = new String[]{CONNECTION_STATE_PROP, IS_TEMPLATE_PROP};
        DerivedPropertyInfo installVmToolsAvailablePropInfo = new DerivedPropertyInfo();
        installVmToolsAvailablePropInfo.propertyName = INSTALL_AVAILABLE;
        installVmToolsAvailablePropInfo.sourcePropertyNames = new String[]{POWER_STATE_PROP, IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP, TOOLS_RUNNING_STATUS_PROP, TOOLS_INSTALLER_MOUNTED_PROP};
        DerivedPropertyInfo upgradeVmToolsAvailablePropInfo = new DerivedPropertyInfo();
        upgradeVmToolsAvailablePropInfo.propertyName = UPGRADE_AVAILABLE;
        upgradeVmToolsAvailablePropInfo.sourcePropertyNames = new String[]{IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP, TOOLS_RUNNING_STATUS_PROP, TOOLS_VERSION_STATUS_PROP, TOOLS_INSTALLER_MOUNTED_PROP};
        DerivedPropertyInfo isInstallUpgradeVmToolsAvailablePropInfo = new DerivedPropertyInfo();
        isInstallUpgradeVmToolsAvailablePropInfo.propertyName = IS_INSTALL_UPGRADE_VM_TOOLS_AVAILABLE;
        isInstallUpgradeVmToolsAvailablePropInfo.sourcePropertyNames = new String[]{CONNECTION_STATE_PROP, IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP, TOOLS_INSTALLER_MOUNTED_PROP};
        DerivedPropertyInfo isUnmountVmToolsAvailablePropInfo = new DerivedPropertyInfo();
        isUnmountVmToolsAvailablePropInfo.propertyName = IS_UNMOUNT_VM_TOOLS_AVAILABLE;
        isUnmountVmToolsAvailablePropInfo.sourcePropertyNames = new String[]{POWER_STATE_PROP, TOOLS_INSTALLER_MOUNTED_PROP};
        DerivedPropertyInfo isCancelHwUpgradeAvailablePropInfo = new DerivedPropertyInfo();
        isCancelHwUpgradeAvailablePropInfo.propertyName = IS_CANCEL_HARDWARE_UPGRADE_AVAILABLE;
        isCancelHwUpgradeAvailablePropInfo.sourcePropertyNames = new String[]{CONFIG_SCHEDULE_INFO_KEY_PROP};
        DerivedPropertyInfo isQuestionAvailablePropInfo = new DerivedPropertyInfo();
        isQuestionAvailablePropInfo.propertyName = IS_QUESTION_AVAILABLE;
        isQuestionAvailablePropInfo.sourcePropertyNames = new String[]{QUESTION_ID_PROP};
        DerivedPropertyInfo isTakeSnapshotAvailablePropInfo = new DerivedPropertyInfo();
        isTakeSnapshotAvailablePropInfo.propertyName = IS_TAKE_SNAPSHOT_AVAILABLE;
        isTakeSnapshotAvailablePropInfo.sourcePropertyNames = new String[]{MULTIPLE_SNAPSHOTS_SUPPORTED_PROP, FT_STATE_PROP, FT_INFO_PROP};
        DerivedPropertyInfo isManageSnapshotAvailablePropInfo = new DerivedPropertyInfo();
        isManageSnapshotAvailablePropInfo.propertyName = IS_MANAGE_SNAPSHOT_AVAILABLE;
        isManageSnapshotAvailablePropInfo.sourcePropertyNames = new String[]{CONNECTION_STATE_PROP, MULTIPLE_SNAPSHOTS_SUPPORTED_PROP, FT_STATE_PROP, FT_INFO_PROP};
        DerivedPropertyInfo isRevertToLatestSnapshotAvailablePropInfo = new DerivedPropertyInfo();
        isRevertToLatestSnapshotAvailablePropInfo.propertyName = IS_REVERT_TO_LATEST_SNAPSHOT_AVAILABLE;
        isRevertToLatestSnapshotAvailablePropInfo.sourcePropertyNames = new String[]{MULTIPLE_SNAPSHOTS_SUPPORTED_PROP, CURRENT_SNAPSHOT_PROP, FT_STATE_PROP, FT_INFO_PROP};
        tInfo.derivedProperties = new DerivedPropertyInfo[]{isVmConnectedPropInfo, isMigrateAvailablePropInfo, installVmToolsAvailablePropInfo, upgradeVmToolsAvailablePropInfo, isInstallUpgradeVmToolsAvailablePropInfo, isUnmountVmToolsAvailablePropInfo, isCancelHwUpgradeAvailablePropInfo, isQuestionAvailablePropInfo, isTakeSnapshotAvailablePropInfo, isManageSnapshotAvailablePropInfo, isRevertToLatestSnapshotAvailablePropInfo};
        return new TypeInfo[]{tInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] vmRefs = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object vmRef : vmRefs) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(vmRef);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = vmRef;
            PropertyValue[] computedValues = this.computeResultSet(reqPropSet, sourcePropertyValuesMap, resItem.resourceObject);
            resItem.properties = computedValues;
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] computeResultSet(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(IS_VM_CONNECTED)) {
            VmPropertyProviderAdapter.computeIsVmConnected(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_MIGRATE_AVAILABLE)) {
            VmPropertyProviderAdapter.computeMigrateAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(INSTALL_AVAILABLE)) {
            VmPropertyProviderAdapter.computeInstallVmToolsAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(UPGRADE_AVAILABLE)) {
            VmPropertyProviderAdapter.computeUpgradeVmToolsAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_INSTALL_UPGRADE_VM_TOOLS_AVAILABLE)) {
            VmPropertyProviderAdapter.computeInstallUpgradeVmToolsAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_UNMOUNT_VM_TOOLS_AVAILABLE)) {
            VmPropertyProviderAdapter.computeUnmountVmToolsAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_CANCEL_HARDWARE_UPGRADE_AVAILABLE)) {
            VmPropertyProviderAdapter.computeCancelHwUpgradeAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_QUESTION_AVAILABLE)) {
            VmPropertyProviderAdapter.computeQuestionAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_TAKE_SNAPSHOT_AVAILABLE)) {
            VmPropertyProviderAdapter.computeTakeSnapshotAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_MANAGE_SNAPSHOT_AVAILABLE)) {
            VmPropertyProviderAdapter.computeManageSnapshotAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_REVERT_TO_LATEST_SNAPSHOT_AVAILABLE)) {
            VmPropertyProviderAdapter.computeRevertToLatestSnapshotAvailable(propertyValuesMap, results, resourceObject);
        }
        return results.toArray(new PropertyValue[0]);
    }

    private static void computeIsVmConnected(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)propertyValuesMap.get(CONNECTION_STATE_PROP);
        boolean result = VirtualMachine.ConnectionState.connected.equals((Object)connectionState);
        results.add(VmPropertyProviderAdapter.createPropValue(IS_VM_CONNECTED, result, resourceObject));
    }

    private static void computeMigrateAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)propertyValuesMap.get(CONNECTION_STATE_PROP);
        Boolean isTemplateValue = (Boolean)propertyValuesMap.get(IS_TEMPLATE_PROP);
        boolean isTemplate = isTemplateValue != null ? isTemplateValue : false;
        boolean result = VirtualMachine.ConnectionState.connected.equals((Object)connectionState) && !isTemplate;
        results.add(VmPropertyProviderAdapter.createPropValue(IS_MIGRATE_AVAILABLE, result, resourceObject));
    }

    private static void computeInstallVmToolsAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        VirtualMachine.PowerState powerState = (VirtualMachine.PowerState)propertyValuesMap.get(POWER_STATE_PROP);
        Boolean isNormalOrPrimaryFtVal = (Boolean)propertyValuesMap.get(IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP);
        boolean isNormalOrPrimaryFt = isNormalOrPrimaryFtVal != null ? isNormalOrPrimaryFtVal : true;
        String toolsRunningStatusStr = (String)propertyValuesMap.get(TOOLS_RUNNING_STATUS_PROP);
        GuestInfo.ToolsRunningStatus toolsRunningStatus = VmPropertyProviderAdapter.getToolsRunningStatus(toolsRunningStatusStr);
        boolean toolsInstallerMounted = (Boolean)propertyValuesMap.get(TOOLS_INSTALLER_MOUNTED_PROP);
        boolean result = VirtualMachine.PowerState.poweredOn.equals((Object)powerState) && isNormalOrPrimaryFt && GuestInfo.ToolsRunningStatus.guestToolsNotRunning.equals((Object)toolsRunningStatus) && !toolsInstallerMounted;
        results.add(VmPropertyProviderAdapter.createPropValue(INSTALL_AVAILABLE, result, resourceObject));
    }

    private static void computeUpgradeVmToolsAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        Boolean isNormalOrPrimaryFtVal = (Boolean)propertyValuesMap.get(IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP);
        boolean isNormalOrPrimaryFt = isNormalOrPrimaryFtVal != null ? isNormalOrPrimaryFtVal : true;
        String toolsRunningStatusStr = (String)propertyValuesMap.get(TOOLS_RUNNING_STATUS_PROP);
        GuestInfo.ToolsRunningStatus toolsRunningStatus = VmPropertyProviderAdapter.getToolsRunningStatus(toolsRunningStatusStr);
        String toolsVersionStatusStr = (String)propertyValuesMap.get(TOOLS_VERSION_STATUS_PROP);
        GuestInfo.ToolsVersionStatus toolsVersionStatus = VmPropertyProviderAdapter.getToolsVersionStatus(toolsVersionStatusStr);
        boolean toolsInstallerMounted = (Boolean)propertyValuesMap.get(TOOLS_INSTALLER_MOUNTED_PROP);
        boolean result = isNormalOrPrimaryFt && GuestInfo.ToolsRunningStatus.guestToolsRunning.equals((Object)toolsRunningStatus) && (GuestInfo.ToolsVersionStatus.guestToolsNeedUpgrade.equals((Object)toolsVersionStatus) || GuestInfo.ToolsVersionStatus.guestToolsSupportedOld.equals((Object)toolsVersionStatus) || GuestInfo.ToolsVersionStatus.guestToolsTooOld.equals((Object)toolsVersionStatus) || GuestInfo.ToolsVersionStatus.guestToolsBlacklisted.equals((Object)toolsVersionStatus)) && !toolsInstallerMounted;
        results.add(VmPropertyProviderAdapter.createPropValue(UPGRADE_AVAILABLE, result, resourceObject));
    }

    private static void computeInstallUpgradeVmToolsAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)propertyValuesMap.get(CONNECTION_STATE_PROP);
        Boolean isNormalOrPrimaryFtVal = (Boolean)propertyValuesMap.get(IS_NORMAL_VM_OR_PRIMARY_FT_VM_PROP);
        boolean isNormalOrPrimaryFt = isNormalOrPrimaryFtVal != null ? isNormalOrPrimaryFtVal : true;
        boolean toolsInstallerMounted = (Boolean)propertyValuesMap.get(TOOLS_INSTALLER_MOUNTED_PROP);
        boolean result = VirtualMachine.ConnectionState.connected.equals((Object)connectionState) && isNormalOrPrimaryFt && !toolsInstallerMounted;
        results.add(VmPropertyProviderAdapter.createPropValue(IS_INSTALL_UPGRADE_VM_TOOLS_AVAILABLE, result, resourceObject));
    }

    private static void computeUnmountVmToolsAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        VirtualMachine.PowerState powerState = (VirtualMachine.PowerState)propertyValuesMap.get(POWER_STATE_PROP);
        boolean toolsInstallerMounted = (Boolean)propertyValuesMap.get(TOOLS_INSTALLER_MOUNTED_PROP);
        boolean result = VirtualMachine.PowerState.poweredOn.equals((Object)powerState) && toolsInstallerMounted;
        results.add(VmPropertyProviderAdapter.createPropValue(IS_UNMOUNT_VM_TOOLS_AVAILABLE, result, resourceObject));
    }

    private static void computeCancelHwUpgradeAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        String hwUpgradeInfoKey = (String)propertyValuesMap.get(CONFIG_SCHEDULE_INFO_KEY_PROP);
        boolean result = !StringUtil.isNullOrEmpty((String)hwUpgradeInfoKey);
        results.add(VmPropertyProviderAdapter.createPropValue(IS_CANCEL_HARDWARE_UPGRADE_AVAILABLE, result, resourceObject));
    }

    private static void computeQuestionAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        String questionInfoId = (String)propertyValuesMap.get(QUESTION_ID_PROP);
        boolean result = !StringUtil.isNullOrEmpty((String)questionInfoId);
        results.add(VmPropertyProviderAdapter.createPropValue(IS_QUESTION_AVAILABLE, result, resourceObject));
    }

    private static void computeTakeSnapshotAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        Boolean multipleSnapshotsSupportedVal = (Boolean)propertyValuesMap.get(MULTIPLE_SNAPSHOTS_SUPPORTED_PROP);
        boolean multipleSnapshotsSupported = multipleSnapshotsSupportedVal != null ? multipleSnapshotsSupportedVal : true;
        VirtualMachine.FaultToleranceState ftState = (VirtualMachine.FaultToleranceState)propertyValuesMap.get(FT_STATE_PROP);
        FaultToleranceConfigInfo ftInfo = (FaultToleranceConfigInfo)propertyValuesMap.get(FT_INFO_PROP);
        boolean isFtVm = VmPropertyProviderAdapter.isFt(ftState, ftInfo);
        boolean result = multipleSnapshotsSupported && !isFtVm;
        results.add(VmPropertyProviderAdapter.createPropValue(IS_TAKE_SNAPSHOT_AVAILABLE, result, resourceObject));
    }

    private static void computeManageSnapshotAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)propertyValuesMap.get(CONNECTION_STATE_PROP);
        Boolean multipleSnapshotsSupportedVal = (Boolean)propertyValuesMap.get(MULTIPLE_SNAPSHOTS_SUPPORTED_PROP);
        boolean multipleSnapshotsSupported = multipleSnapshotsSupportedVal != null ? multipleSnapshotsSupportedVal : true;
        VirtualMachine.FaultToleranceState ftState = (VirtualMachine.FaultToleranceState)propertyValuesMap.get(FT_STATE_PROP);
        FaultToleranceConfigInfo ftInfo = (FaultToleranceConfigInfo)propertyValuesMap.get(FT_INFO_PROP);
        boolean isFtVm = VmPropertyProviderAdapter.isFt(ftState, ftInfo);
        boolean result = VirtualMachine.ConnectionState.connected.equals((Object)connectionState) && multipleSnapshotsSupported && !isFtVm;
        results.add(VmPropertyProviderAdapter.createPropValue(IS_MANAGE_SNAPSHOT_AVAILABLE, result, resourceObject));
    }

    private static void computeRevertToLatestSnapshotAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        Boolean multipleSnapshotsSupportedVal = (Boolean)propertyValuesMap.get(MULTIPLE_SNAPSHOTS_SUPPORTED_PROP);
        boolean multipleSnapshotsSupported = multipleSnapshotsSupportedVal != null ? multipleSnapshotsSupportedVal : true;
        ManagedObjectReference currSnapshotRef = (ManagedObjectReference)propertyValuesMap.get(CURRENT_SNAPSHOT_PROP);
        VirtualMachine.FaultToleranceState ftState = (VirtualMachine.FaultToleranceState)propertyValuesMap.get(FT_STATE_PROP);
        FaultToleranceConfigInfo ftInfo = (FaultToleranceConfigInfo)propertyValuesMap.get(FT_INFO_PROP);
        boolean isFtVm = VmPropertyProviderAdapter.isFt(ftState, ftInfo);
        boolean result = multipleSnapshotsSupported && currSnapshotRef != null && !isFtVm;
        results.add(VmPropertyProviderAdapter.createPropValue(IS_REVERT_TO_LATEST_SNAPSHOT_AVAILABLE, result, resourceObject));
    }

    private static PropertyValue createPropValue(String propName, Object propValue, Object resObject) {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = propName;
        pv.value = propValue;
        pv.resourceObject = resObject;
        return pv;
    }

    private static GuestInfo.ToolsRunningStatus getToolsRunningStatus(String toolsRunningStatus) {
        HashSet<String> toolsRunningStatusVals = new HashSet<String>();
        for (GuestInfo.ToolsRunningStatus status : GuestInfo.ToolsRunningStatus.values()) {
            toolsRunningStatusVals.add(status.name());
        }
        return toolsRunningStatusVals.contains(toolsRunningStatus) ? GuestInfo.ToolsRunningStatus.valueOf((String)toolsRunningStatus) : null;
    }

    private static GuestInfo.ToolsVersionStatus getToolsVersionStatus(String toolsVersionStatus) {
        if (StringUtil.isNullOrEmpty((String)toolsVersionStatus)) {
            return null;
        }
        HashSet<String> toolsVersionStatusVals = new HashSet<String>();
        for (GuestInfo.ToolsVersionStatus status : GuestInfo.ToolsVersionStatus.values()) {
            toolsVersionStatusVals.add(status.name());
        }
        return toolsVersionStatusVals.contains(toolsVersionStatus) ? GuestInfo.ToolsVersionStatus.valueOf((String)toolsVersionStatus) : null;
    }

    private static boolean isFt(VirtualMachine.FaultToleranceState ftState, FaultToleranceConfigInfo ftInfo) {
        return !VirtualMachine.FaultToleranceState.notConfigured.equals((Object)ftState) && ftInfo != null && ftInfo.role >= 1;
    }
}

