/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.model.storagelocator;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorDatastoreItem;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorDatastoreRawData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorStoragePodItem;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StoragePodQueryBinding;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import com.vmware.vsphere.client.vm.api.model.provisioning.VirtualDiskFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageLocatorItemsFactory {
    private static final String VMFS_TYPE = "VMFS";
    private static final String VVOL_TYPE = "VVOL";
    private static final String NFS41_TYPE = "NFS41";
    private static final String NFS3_TYPE = "NFS";
    private static final String VSAN_TYPE = "vsan";
    public static final String PRIVILEGE_ALLOCATESPACE = "Datastore.AllocateSpace";

    public StorageLocatorItemsData fromDatastoreRawData(Collection<StorageLocatorDatastoreRawData> rawData) {
        StorageLocatorItemsData result = new StorageLocatorItemsData();
        if (rawData == null || rawData.isEmpty()) {
            result.storagePodItems = new StorageLocatorStoragePodItem[0];
            result.datastoreItems = new StorageLocatorDatastoreItem[0];
            return result;
        }
        ArrayList<StorageLocatorDatastoreItem> datastoreItems = new ArrayList<StorageLocatorDatastoreItem>();
        ArrayList<StorageLocatorStoragePodItem> storagePodItems = new ArrayList<StorageLocatorStoragePodItem>();
        HashMap<Object, List<Object>> dsByPod = new HashMap<Object, List<Object>>();
        HashMap<Object, StorageLocatorDatastoreRawData> dsProperties = new HashMap<Object, StorageLocatorDatastoreRawData>(rawData.size());
        for (StorageLocatorDatastoreRawData dsData : rawData) {
            dsProperties.put(dsData.provider, dsData);
            StorageLocatorDatastoreItem datastoreItem = this.newDatastoreItem(dsData);
            datastoreItems.add(datastoreItem);
            if (datastoreItem.parentStoragePod == null) continue;
            if (!dsByPod.containsKey(datastoreItem.parentStoragePod)) {
                StorageLocatorStoragePodItem podItem = this.newStoragePodItem(dsData.parentPod);
                storagePodItems.add(podItem);
                dsByPod.put(datastoreItem.parentStoragePod, new ArrayList());
            }
            ((List)dsByPod.get(datastoreItem.parentStoragePod)).add(datastoreItem.storageRef);
        }
        StorageLocatorItemsFactory.populateAggregatedProperties(datastoreItems, storagePodItems, dsProperties, dsByPod);
        result.datastoreItems = datastoreItems.toArray(new StorageLocatorDatastoreItem[datastoreItems.size()]);
        result.storagePodItems = storagePodItems.toArray(new StorageLocatorStoragePodItem[storagePodItems.size()]);
        Arrays.sort(result.datastoreItems, new Comparator<StorageLocatorDatastoreItem>(){

            @Override
            public int compare(StorageLocatorDatastoreItem o1, StorageLocatorDatastoreItem o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        Arrays.sort(result.storagePodItems, new Comparator<StorageLocatorStoragePodItem>(){

            @Override
            public int compare(StorageLocatorStoragePodItem o1, StorageLocatorStoragePodItem o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return result;
    }

    private static void populateAggregatedProperties(List<StorageLocatorDatastoreItem> datastoreItems, List<StorageLocatorStoragePodItem> storagePodItems, Map<Object, StorageLocatorDatastoreRawData> datastoreInfos, Map<Object, List<Object>> datastoresByPod) {
        for (StorageLocatorDatastoreItem storageLocatorDatastoreItem : datastoreItems) {
            StorageLocatorDatastoreRawData dsInfo = datastoreInfos.get(storageLocatorDatastoreItem.storageRef);
            List<StorageLocatorDatastoreRawData> dsList = Arrays.asList(dsInfo);
            storageLocatorDatastoreItem.diskFormatsAvailable = StorageLocatorItemsFactory.getSupportedFormats(dsList);
            storageLocatorDatastoreItem.hardwareAcceleration = StorageLocatorItemsFactory.getHardwareAcceleration(dsList);
            storageLocatorDatastoreItem.multipleHostAccess = StorageLocatorItemsFactory.getMultipleHostAccess(dsList);
            storageLocatorDatastoreItem.thinProvisioningSupported = StorageLocatorItemsFactory.getThinProvisioningSupported(dsList);
        }
        for (StorageLocatorStoragePodItem storageLocatorStoragePodItem : storagePodItems) {
            ArrayList<StorageLocatorDatastoreRawData> dsInfos = new ArrayList<StorageLocatorDatastoreRawData>();
            for (Object ds : datastoresByPod.get(storageLocatorStoragePodItem.storageRef)) {
                dsInfos.add(datastoreInfos.get(ds));
            }
            storageLocatorStoragePodItem.diskFormatsAvailable = StorageLocatorItemsFactory.getSupportedFormats(dsInfos);
            storageLocatorStoragePodItem.hardwareAcceleration = StorageLocatorItemsFactory.getHardwareAcceleration(dsInfos);
            storageLocatorStoragePodItem.multipleHostAccess = StorageLocatorItemsFactory.getMultipleHostAccess(dsInfos);
            storageLocatorStoragePodItem.thinProvisioningSupported = StorageLocatorItemsFactory.getThinProvisioningSupported(dsInfos);
        }
    }

    private static boolean getMultipleHostAccess(List<StorageLocatorDatastoreRawData> dsData) {
        for (StorageLocatorDatastoreRawData dsInfo : dsData) {
            if (!Boolean.TRUE.equals(dsInfo.summary.multipleHostAccess)) continue;
            return true;
        }
        return false;
    }

    private static boolean getThinProvisioningSupported(List<StorageLocatorDatastoreRawData> dsData) {
        for (StorageLocatorDatastoreRawData dsInfo : dsData) {
            if (dsInfo.capability.perFileThinProvisioningSupported) continue;
            return false;
        }
        return true;
    }

    private static String getHardwareAcceleration(List<StorageLocatorDatastoreRawData> dsData) {
        for (StorageLocatorDatastoreRawData dsInfo : dsData) {
            if (Boolean.TRUE.equals(dsInfo.vStorageSupported)) continue;
            return VmStringUtil.getString("hwAcceleration.notSupported");
        }
        return VmStringUtil.getString("hwAcceleration.supported");
    }

    private static List<VirtualDiskFormat> getSupportedFormats(List<StorageLocatorDatastoreRawData> dsData) {
        boolean acceleration;
        ArrayList<VirtualDiskFormat> result = new ArrayList<VirtualDiskFormat>();
        String firstDatastoreType = !dsData.isEmpty() ? dsData.get((int)0).summary.type : null;
        String string = firstDatastoreType = firstDatastoreType == null ? "" : firstDatastoreType;
        if (VVOL_TYPE.equals(firstDatastoreType)) {
            result.add(VirtualDiskFormat.thin);
            result.add(VirtualDiskFormat.nativeThick);
            return result;
        }
        if (VSAN_TYPE.equals(firstDatastoreType)) {
            result.add(VirtualDiskFormat.asDefinedInProfile);
            return result;
        }
        if ((NFS3_TYPE.equalsIgnoreCase(firstDatastoreType) || NFS41_TYPE.equalsIgnoreCase(firstDatastoreType)) && !(acceleration = StorageLocatorItemsFactory.hasAcceleration(dsData))) {
            result.add(VirtualDiskFormat.thin);
            return result;
        }
        result.add(VirtualDiskFormat.sameAsSource);
        result.add(VirtualDiskFormat.flat);
        result.add(VirtualDiskFormat.thick);
        result.add(VirtualDiskFormat.thin);
        return result;
    }

    private static boolean hasAcceleration(List<StorageLocatorDatastoreRawData> dsData) {
        if (dsData.isEmpty()) {
            return false;
        }
        for (StorageLocatorDatastoreRawData dsInfo : dsData) {
            if (Boolean.TRUE.equals(dsInfo.vStorageSupported)) continue;
            return false;
        }
        return true;
    }

    private StorageLocatorDatastoreItem newDatastoreItem(StorageLocatorDatastoreRawData data) {
        boolean privilegeGranted;
        StorageLocatorDatastoreItem datastoreItem = new StorageLocatorDatastoreItem();
        datastoreItem.name = data.summary.name;
        datastoreItem.storageRef = data.summary.datastore;
        datastoreItem.capacity = data.summary.capacity;
        datastoreItem.freeSpace = data.summary.freeSpace;
        datastoreItem.provisionedSpace = data.summary.capacity - data.summary.freeSpace;
        if (data.summary.uncommitted != null) {
            datastoreItem.provisionedSpace += data.summary.uncommitted.longValue();
        }
        if (data.parentPod != null) {
            datastoreItem.parentStoragePod = (ManagedObjectReference)data.parentPod.provider;
        }
        datastoreItem.type = data.summary.type;
        datastoreItem.formattedType = this.formatDatastoreType(data.summary.type, data.vmfsMajorVersion);
        datastoreItem.vStorageSupported = Boolean.TRUE.equals(data.vStorageSupported);
        datastoreItem.hasAllocateSpacePrivilege = privilegeGranted = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{PRIVILEGE_ALLOCATESPACE}, (String[])data.grantedPrivileges);
        return datastoreItem;
    }

    private String formatDatastoreType(String dsType, Integer vmfsMajorVersion) {
        if (VMFS_TYPE.equalsIgnoreCase(dsType)) {
            if (vmfsMajorVersion != null) {
                return VmStringUtil.getString("dsType.vmfsWithVersion", vmfsMajorVersion.toString());
            }
            return VmStringUtil.getString("dsType.vmfs");
        }
        if (NFS3_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.nfs3");
        }
        if (NFS41_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.nfs41");
        }
        if (VSAN_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.vsan");
        }
        if (VVOL_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.vvol");
        }
        return dsType;
    }

    private StorageLocatorStoragePodItem newStoragePodItem(StoragePodQueryBinding storagePodInfo) {
        StorageLocatorStoragePodItem podItem = new StorageLocatorStoragePodItem();
        podItem.storageRef = (ManagedObjectReference)storagePodInfo.provider;
        podItem.name = storagePodInfo.summary.name;
        podItem.capacity = storagePodInfo.summary.capacity;
        podItem.freeSpace = storagePodInfo.summary.freeSpace;
        podItem.provisionedSpace = storagePodInfo.summary.capacity - storagePodInfo.summary.freeSpace;
        podItem.drsEnabled = Boolean.TRUE.equals(storagePodInfo.drsEnabled);
        return podItem;
    }
}

