/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service.migration;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationStorageLocatorSpec;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorDatastoreRawData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.Validate;

public class VmMigrationStorageLocatorService
implements PropertyProviderBean {
    private static final String PROPERTY_DATASTORE = "datastore";
    private static final String PROPERTY_VMHOST = "host";
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private final StorageLocatorItemsFactory _storageItemsFactory;

    public VmMigrationStorageLocatorService(QueryServiceFactory queryServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory, StorageLocatorItemsFactory storageItemsFactory) {
        this._queryService = queryServiceFactory.getQueryService();
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._storageItemsFactory = storageItemsFactory;
    }

    public StorageLocatorItemsData getStorageLocatorData(VmMigrationStorageLocatorSpec spec) {
        Validate.notNull((Object)spec);
        Validate.notEmpty((Object[])spec.vms);
        Collection<StorageLocatorDatastoreRawData> rawData = this.getAvailableDatastores(spec);
        StorageLocatorItemsData result = this._storageItemsFactory.fromDatastoreRawData(rawData);
        return result;
    }

    public Collection<StorageLocatorDatastoreRawData> getAvailableDatastores(VmMigrationStorageLocatorSpec spec) {
        Validate.notNull((Object)spec);
        Validate.notEmpty((Object[])spec.vms);
        List<Object> datastores = spec.resource != null ? this.getRelevantDatastoresForResource(spec.resource) : this.getRelevantDatastoresForVms(Arrays.asList(spec.vms));
        Collection<StorageLocatorDatastoreRawData> rawData = this.getDatastoreData(datastores);
        return VmMigrationStorageLocatorService.filterAvailableDatastores(rawData);
    }

    private List<Object> getRelevantDatastoresForResource(ManagedObjectReference resource) {
        ResultSet clusterDsResult = this._queryService.select(new String[]{PROPERTY_DATASTORE}).from(new String[]{resource.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)resource).fetch();
        List resourceData = clusterDsResult.getItems();
        if (resourceData.isEmpty() || ((ResourceItem)resourceData.get(0)).get(PROPERTY_DATASTORE) == null) {
            return Collections.emptyList();
        }
        return Arrays.asList((Object[])((ResourceItem)resourceData.get(0)).get(PROPERTY_DATASTORE));
    }

    private List<Object> getRelevantDatastoresForVms(Collection<ManagedObjectReference> vm) {
        ResultSet vmHostResult = this._queryService.select(new String[]{PROPERTY_VMHOST}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vm).fetch();
        LinkedHashSet<Object> vmHosts = new LinkedHashSet<Object>();
        for (ResourceItem vmItem : vmHostResult.getItems()) {
            vmHosts.add(vmItem.get(PROPERTY_VMHOST));
        }
        List<Object> datastores = Collections.emptyList();
        if (!vmHosts.isEmpty()) {
            datastores = this.getHostDatastores(vmHosts);
        }
        return datastores;
    }

    private List<Object> getHostDatastores(Collection<Object> hosts) {
        ResultSet hostDsResult = this._queryService.select(new String[]{PROPERTY_DATASTORE}).from(new String[]{HostSystem.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, hosts).fetch();
        List datastoreItems = hostDsResult.getItems();
        if (ArrayUtil.isNullOrEmpty((List)datastoreItems)) {
            return Collections.emptyList();
        }
        ArrayList<Object> datastores = new ArrayList<Object>();
        ResourceItem firstHostProperties = (ResourceItem)datastoreItems.get(0);
        Object[] hostDatastores = (Object[])firstHostProperties.get(PROPERTY_DATASTORE);
        if (ArrayUtil.isNullOrEmpty((Object[])hostDatastores)) {
            return Collections.emptyList();
        }
        datastores.addAll(Arrays.asList(hostDatastores));
        for (int index = 1; index < datastoreItems.size(); ++index) {
            datastores.retainAll(Arrays.asList((Object[])((ResourceItem)datastoreItems.get(index)).get(PROPERTY_DATASTORE)));
            if (datastores.isEmpty()) break;
        }
        return datastores;
    }

    private Collection<StorageLocatorDatastoreRawData> getDatastoreData(Collection<Object> dsRefs) {
        Collection result = this._queryBindingService.prepare(StorageLocatorDatastoreRawData.class).fetch(dsRefs);
        return result;
    }

    private static Collection<StorageLocatorDatastoreRawData> filterAvailableDatastores(Collection<StorageLocatorDatastoreRawData> datastores) {
        ArrayList<StorageLocatorDatastoreRawData> result = new ArrayList<StorageLocatorDatastoreRawData>();
        for (StorageLocatorDatastoreRawData datastore : datastores) {
            if (!VmMigrationStorageLocatorService.isAvailable(datastore)) continue;
            result.add(datastore);
        }
        return result;
    }

    private static boolean isAvailable(StorageLocatorDatastoreRawData datastore) {
        return datastore.summary.accessible && Datastore.Summary.MaintenanceModeState.normal.toString().equals(datastore.summary.maintenanceMode);
    }
}

