/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.util;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmPrivilegeUtil {
    private static Log _logger = LogFactory.getLog(VmPrivilegeUtil.class);
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;

    public VmPrivilegeUtil(ObjectReferenceService objectReferenceService, QueryServiceFactory queryServiceFactory) {
        this._objectReferenceService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    public boolean hasPrivileges(Object object, String ... requiredPrivileges) {
        boolean hasPrivileges = true;
        try {
            ResourceItem item = (ResourceItem)this._queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{this._objectReferenceService.getResourceObjectType(object)}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).fetch().getItems().iterator().next();
            Object[] grantedPrivileges = item != null ? (String[])item.get("grantedPrivileges") : new String[]{};
            System.out.println("Granted privileges: " + Arrays.toString(grantedPrivileges));
            hasPrivileges = AuthorizationUtil.isPrivilegeGranted((String[])requiredPrivileges, (String[])grantedPrivileges);
        }
        catch (Exception error) {
            _logger.error((Object)"Failed to retrieve privileges: ", (Throwable)error);
        }
        return hasPrivileges;
    }
}

