/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.management.ManageableComponent;
import flex.messaging.FlexContext;
import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.config.ServerSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.MessagingSecurity;
import flex.messaging.services.MessageService;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;

public class SubscriptionManager
extends ManageableComponent {
    public static final String TYPE = "SubscriptionManager";
    private static final int SUBTOPICS_NOT_SUPPORTED = 10553;
    private static final int WILDCARD_SUBTOPICS_NOT_ALLOWED = 10560;
    private static final Object classMutex = new Object();
    private static int instanceCount = 0;
    protected final Map<Object, MessageClient> allSubscriptions = new ConcurrentHashMap<Object, MessageClient>();
    private final Object allSubscriptionsLock = new Object();
    private final TopicSubscription globalSubscribers = new TopicSubscription();
    private final Map<Subtopic, TopicSubscription> subscribersPerSubtopic = new ConcurrentHashMap<Subtopic, TopicSubscription>();
    private final Map<Subtopic, TopicSubscription> subscribersPerSubtopicWildcard = new ConcurrentHashMap<Subtopic, TopicSubscription>();
    protected final MessageDestination destination;
    private TimeoutManager subscriberSessionManager;
    private long subscriptionTimeoutMillis;

    public SubscriptionManager(MessageDestination destination) {
        this(destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionManager(MessageDestination destination, boolean enableManagement) {
        super(enableManagement);
        Object object = classMutex;
        synchronized (object) {
            super.setId(TYPE + ++instanceCount);
        }
        this.destination = destination;
        this.subscriptionTimeoutMillis = 0L;
    }

    @Override
    public void setId(String id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        if (this.isManaged() && this.getControl() != null) {
            this.getControl().unregister();
            this.setControl(null);
            this.setManaged(false);
        }
        Object object = this;
        synchronized (object) {
            if (this.subscriberSessionManager != null) {
                this.subscriberSessionManager.shutdown();
                this.subscriberSessionManager = null;
            }
        }
        object = this.allSubscriptionsLock;
        synchronized (object) {
            if (!this.allSubscriptions.isEmpty()) {
                for (Map.Entry<Object, MessageClient> objectMessageClientEntry : this.allSubscriptions.entrySet()) {
                    this.removeSubscriber(objectMessageClientEntry.getValue());
                }
            }
        }
    }

    public void setSubscriptionTimeoutMillis(long value) {
        this.subscriptionTimeoutMillis = value;
        if (this.subscriptionTimeoutMillis > 0L) {
            this.subscriberSessionManager = new TimeoutManager(new ThreadFactory(){
                int counter = 1;

                @Override
                public synchronized Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable);
                    t.setName(SubscriptionManager.this.destination.getId() + "-SubscriptionTimeoutThread-" + this.counter++);
                    return t;
                }
            });
        }
    }

    public long getSubscriptionTimeoutMillis() {
        return this.subscriptionTimeoutMillis;
    }

    public Object getSubscriptionState() {
        ArrayList<String> subState = new ArrayList<String>();
        if (this.globalSubscribers.defaultSubscriptions != null && !this.globalSubscribers.defaultSubscriptions.isEmpty()) {
            subState.add(null);
            subState.add(null);
        }
        if (this.globalSubscribers.selectorSubscriptions != null) {
            for (String s : this.globalSubscribers.selectorSubscriptions.keySet()) {
                subState.add(s);
                subState.add(null);
            }
        }
        this.addSubscriptionState(subState, this.subscribersPerSubtopic);
        this.addSubscriptionState(subState, this.subscribersPerSubtopicWildcard);
        if (Log.isDebug()) {
            Log.getLogger((String)"Service.Message").debug("Retrieved subscription state to send to new cluster member for destination: " + this.destination.getId() + ": " + StringUtils.NEWLINE + subState);
        }
        return subState;
    }

    private void addSubscriptionState(List<String> subState, Map<Subtopic, TopicSubscription> subsPerSubtopic) {
        for (Map.Entry<Subtopic, TopicSubscription> entry : subsPerSubtopic.entrySet()) {
            Subtopic subtopic = entry.getKey();
            TopicSubscription tc = entry.getValue();
            if (tc.defaultSubscriptions != null && !tc.defaultSubscriptions.isEmpty()) {
                subState.add(null);
                subState.add(subtopic.toString());
            }
            if (tc.selectorSubscriptions == null) continue;
            for (String s : tc.selectorSubscriptions.keySet()) {
                subState.add(s);
                subState.add(subtopic.toString());
            }
        }
    }

    protected String getDebugSubscriptionState() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(" global subscriptions: ").append(this.globalSubscribers).append(StringUtils.NEWLINE);
        sb.append(" regular subtopic subscriptions: ").append(this.subscribersPerSubtopic).append(StringUtils.NEWLINE);
        sb.append(" wildcard subtopic subscriptions: ").append(this.subscribersPerSubtopicWildcard).append(StringUtils.NEWLINE);
        return sb.toString();
    }

    @Override
    protected String getLogCategory() {
        return "Service.Message";
    }

    public Set<Object> getSubscriberIds() {
        return this.allSubscriptions.keySet();
    }

    public Set<Object> getSubscriberIds(Message message, boolean evalSelector) {
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
        List<Object> subtopicObj = message.getHeader("DSSubtopic");
        if (subtopicObj instanceof Object[]) {
            subtopicObj = Arrays.asList((Object[])subtopicObj);
        }
        if (subtopicObj instanceof String) {
            String subtopicString = (String)((Object)subtopicObj);
            if (subtopicString.length() > 0) {
                this.addSubtopicSubscribers(subtopicString, message, ids, evalSelector);
            } else {
                this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
            }
        } else if (subtopicObj instanceof List) {
            List<Object> subtopicList = subtopicObj;
            for (String string : subtopicList) {
                this.addSubtopicSubscribers(string, message, ids, evalSelector);
            }
        } else {
            this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
        }
        return ids;
    }

    public Set<Object> getSubscriberIds(Message message, boolean evalSelector, List<Subtopic> subtopics) {
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
        if (subtopics == null || subtopics.isEmpty()) {
            this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
        } else {
            for (Subtopic subtopic : subtopics) {
                this.addSubtopicSubscribers(subtopic, message, ids, evalSelector);
            }
        }
        return ids;
    }

    public Set<Object> getSubscriberIds(String subtopicPattern, Map messageHeaders) {
        AsyncMessage msg = new AsyncMessage();
        msg.setHeader("DSSubtopic", subtopicPattern);
        if (messageHeaders != null) {
            msg.setHeaders(messageHeaders);
        }
        return this.getSubscriberIds(msg, true);
    }

    void addSubtopicSubscribers(String subtopicString, Message message, Set<Object> ids, boolean evalSelector) {
        Subtopic subtopic = this.getSubtopic(subtopicString);
        this.addSubtopicSubscribers(subtopic, message, ids, evalSelector);
    }

    void addSubtopicSubscribers(Subtopic subtopic, Message message, Set<Object> ids, boolean evalSelector) {
        Set<Subtopic> subtopics;
        TopicSubscription ts;
        if (!this.destination.getServerSettings().getAllowSubtopics()) {
            ServiceException se = new ServiceException();
            se.setMessage(10553, new Object[]{subtopic.getValue(), this.destination.getId()});
            throw se;
        }
        ServiceAdapter adapter = this.destination.getAdapter();
        if (adapter instanceof MessagingSecurity && !((MessagingSecurity)((Object)adapter)).allowSend(subtopic)) {
            ServiceException se = new ServiceException();
            se.setMessage(10558, new Object[]{subtopic.getValue()});
            throw se;
        }
        if (this.subscribersPerSubtopic.containsKey(subtopic)) {
            ts = this.subscribersPerSubtopic.get(subtopic);
            this.addTopicSubscribers(ts, message, ids, evalSelector);
        }
        if (!(subtopics = this.subscribersPerSubtopicWildcard.keySet()).isEmpty()) {
            for (Subtopic st : subtopics) {
                if (!st.matches(subtopic)) continue;
                ts = this.subscribersPerSubtopicWildcard.get(st);
                this.addTopicSubscribers(ts, message, ids, evalSelector);
            }
        }
    }

    void addTopicSubscribers(TopicSubscription ts, Message message, Set<Object> ids, boolean evalSelector) {
        if (ts == null) {
            return;
        }
        Map<Object, MessageClient> subs = ts.defaultSubscriptions;
        if (subs != null) {
            ids.addAll(subs.keySet());
        }
        if (ts.selectorSubscriptions == null) {
            return;
        }
        for (Map.Entry<String, Map<Object, MessageClient>> entry : ts.selectorSubscriptions.entrySet()) {
            String selector = entry.getKey();
            subs = entry.getValue();
            if (!evalSelector) {
                ids.addAll(subs.keySet());
                continue;
            }
            JMSSelector jmsSel = new JMSSelector(selector);
            try {
                if (!jmsSel.match(message)) continue;
                ids.addAll(subs.keySet());
            }
            catch (JMSSelectorException jmse) {
                if (!Log.isWarn()) continue;
                Log.getLogger((String)"Message.Selector").warn("Error processing message selector: " + jmsSel + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE + "  selector: " + selector);
            }
        }
    }

    public MessageClient getSubscriber(Object clientId) {
        MessageClient client = this.allSubscriptions.get(clientId);
        if (client != null && !client.isTimingOut()) {
            this.monitorTimeout(client);
        }
        return client;
    }

    public void removeSubscriber(MessageClient client) {
        client.invalidate();
        if (this.getSubscriber(client.getClientId()) != null) {
            Log.getLogger((String)"Service.Message").error("Failed to remove client: " + client.getClientId());
        }
    }

    public void addSubscriber(Object clientId, String selector, String subtopicString, String endpointId) {
        this.addSubscriber(clientId, selector, subtopicString, endpointId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Object clientId, String selector, String subtopicString, String endpointId, int maxFrequency) {
        Subtopic subtopic = this.getSubtopic(subtopicString);
        MessageClient client = null;
        try {
            Map<Object, MessageClient> subs;
            SubscriptionManager subscriptionManager;
            TopicSubscription topicSub;
            boolean subscriptionAlreadyExists = this.getSubscriber(clientId) != null;
            client = this.getMessageClient(clientId, endpointId);
            FlexClient flexClient = FlexContext.getFlexClient();
            if (subscriptionAlreadyExists) {
                if (flexClient != null && !flexClient.getId().equals(client.getFlexClient().getId())) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10559, new Object[]{clientId});
                    throw se;
                }
                client.resetEndpoint(endpointId);
            }
            ServiceAdapter adapter = this.destination.getAdapter();
            client.updateLastUse();
            if (subtopic == null) {
                topicSub = this.globalSubscribers;
            } else {
                if (!this.destination.getServerSettings().getAllowSubtopics()) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10553, new Object[]{subtopicString, this.destination.getId()});
                    throw se;
                }
                if (subtopic.containsSubtopicWildcard() && this.destination.getServerSettings().isDisallowWildcardSubtopics()) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10560, new Object[]{subtopicString, this.destination.getId()});
                    throw se;
                }
                if (adapter instanceof MessagingSecurity && subtopic != null && !((MessagingSecurity)((Object)adapter)).allowSubscribe(subtopic)) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10557, new Object[]{subtopicString});
                    throw se;
                }
                Map<Subtopic, TopicSubscription> map = subtopic.containsSubtopicWildcard() ? this.subscribersPerSubtopicWildcard : this.subscribersPerSubtopic;
                subscriptionManager = this;
                synchronized (subscriptionManager) {
                    topicSub = map.get(subtopic);
                    if (topicSub == null) {
                        topicSub = new TopicSubscription();
                        map.put(subtopic, topicSub);
                    }
                }
            }
            if (selector == null) {
                subs = topicSub.defaultSubscriptions;
                if (subs == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        subs = topicSub.defaultSubscriptions;
                        if (subs == null) {
                            topicSub.defaultSubscriptions = subs = new ConcurrentHashMap<Object, MessageClient>();
                        }
                    }
                }
            } else {
                subscriptionManager = this;
                synchronized (subscriptionManager) {
                    if (topicSub.selectorSubscriptions == null) {
                        topicSub.selectorSubscriptions = new ConcurrentHashMap<String, Map<Object, MessageClient>>();
                    }
                }
                subs = topicSub.selectorSubscriptions.get(selector);
                if (subs == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        subs = topicSub.selectorSubscriptions.get(selector);
                        if (subs == null) {
                            subs = new ConcurrentHashMap<Object, MessageClient>();
                            topicSub.selectorSubscriptions.put(selector, subs);
                        }
                    }
                }
            }
            if (subs.containsKey(clientId)) {
                if (Log.isWarn()) {
                    Log.getLogger((String)"Message.Selector").warn("Client: " + clientId + " already subscribed to: " + this.destination.getId() + " selector: " + selector + " subtopic: " + subtopicString);
                }
            } else {
                client.addSubscription(selector, subtopicString, maxFrequency);
                subscriptionManager = this;
                synchronized (subscriptionManager) {
                    if (subs.isEmpty() && this.destination.isClustered() && this.destination.getServerSettings().getRoutingMode() == ServerSettings.RoutingMode.SERVER_TO_SERVER) {
                        this.sendSubscriptionToPeer(true, selector, subtopicString);
                    }
                    subs.put(clientId, client);
                }
                this.monitorTimeout(client);
                if (!subscriptionAlreadyExists) {
                    client.notifyCreatedListeners();
                }
            }
            this.releaseMessageClient(client);
        }
        catch (Throwable throwable) {
            this.releaseMessageClient(client);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeSubscriber(Object clientId, String selector, String subtopicString, String endpointId) {
        MessageClient client = null;
        try {
            TopicSubscription topicSub;
            Object object = this.allSubscriptionsLock;
            // MONITORENTER : object
            client = this.allSubscriptions.get(clientId);
            if (client == null) {
                // MONITOREXIT : object
                if (client == null) return;
                this.releaseMessageClient(client);
                return;
            }
            client = this.getMessageClient(clientId, endpointId);
            // MONITOREXIT : object
            Subtopic subtopic = this.getSubtopic(subtopicString);
            Map<Subtopic, TopicSubscription> map = null;
            if (subtopic == null) {
                topicSub = this.globalSubscribers;
            } else {
                map = subtopic.containsSubtopicWildcard() ? this.subscribersPerSubtopicWildcard : this.subscribersPerSubtopic;
                topicSub = map.get(subtopic);
                if (topicSub == null) {
                    throw new MessageException("Client: " + clientId + " not subscribed to subtopic: " + subtopic);
                }
            }
            Map<Object, MessageClient> subs = selector == null ? topicSub.defaultSubscriptions : topicSub.selectorSubscriptions.get(selector);
            if (subs == null) throw new MessageException("Client: " + clientId + " not subscribed to destination with selector: " + selector);
            if (subs.get(clientId) == null) {
                throw new MessageException("Client: " + clientId + " not subscribed to destination with selector: " + selector);
            }
            SubscriptionManager subscriptionManager = this;
            // MONITORENTER : subscriptionManager
            subs.remove(clientId);
            if (subs.isEmpty() && this.destination.isClustered() && this.destination.getServerSettings().getRoutingMode() == ServerSettings.RoutingMode.SERVER_TO_SERVER) {
                this.sendSubscriptionToPeer(false, selector, subtopicString);
            }
            if (subs.isEmpty()) {
                if (selector != null && topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty()) {
                    topicSub.selectorSubscriptions.remove(selector);
                }
                if (!(subtopic == null || topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty() || topicSub.defaultSubscriptions != null && !topicSub.defaultSubscriptions.isEmpty() || topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty() || topicSub.defaultSubscriptions != null && !topicSub.defaultSubscriptions.isEmpty())) {
                    map.remove(subtopic);
                }
            }
            // MONITOREXIT : subscriptionManager
            if (client.removeSubscription(selector, subtopicString)) {
                this.allSubscriptions.remove(clientId);
                client.invalidate();
            }
            if (client == null) return;
            this.releaseMessageClient(client);
            return;
        }
        catch (Throwable throwable) {
            if (client == null) throw throwable;
            this.releaseMessageClient(client);
            throw throwable;
        }
    }

    protected MessageClient newMessageClient(Object clientId, String endpointId) {
        return new MessageClient(clientId, this.destination, endpointId, true);
    }

    public MessageClient registerMessageClient(Object clientId, String endpointId) {
        MessageClient client = this.getMessageClient(clientId, endpointId);
        this.monitorTimeout(client);
        if (client.isRegistered()) {
            this.releaseMessageClient(client);
        } else {
            client.setRegistered(true);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageClient getMessageClient(Object clientId, String endpointId) {
        Object object = this.allSubscriptionsLock;
        synchronized (object) {
            MessageClient client = this.allSubscriptions.get(clientId);
            if (client == null) {
                client = this.newMessageClient(clientId, endpointId);
                this.allSubscriptions.put(clientId, client);
            }
            client.incrementReferences();
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageClient(MessageClient client) {
        if (client == null) {
            return;
        }
        Object object = this.allSubscriptionsLock;
        synchronized (object) {
            if (client.decrementReferences()) {
                this.allSubscriptions.remove(client.getClientId());
                client.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorTimeout(MessageClient client) {
        if (this.subscriberSessionManager != null) {
            MessageClient messageClient = client;
            synchronized (messageClient) {
                if (!client.isTimingOut()) {
                    this.subscriberSessionManager.scheduleTimeout(client);
                    client.setTimingOut(true);
                }
            }
        }
    }

    private Subtopic getSubtopic(String subtopic) {
        return subtopic != null ? new Subtopic(subtopic, this.destination.getServerSettings().getSubtopicSeparator()) : null;
    }

    protected void sendSubscriptionToPeer(boolean subscribe, String selector, String subtopic) {
        if (Log.isDebug()) {
            Log.getLogger((String)"Service.Message").debug("Sending subscription to peers for subscribe? " + subscribe + " selector: " + selector + " subtopic: " + subtopic);
        }
        ((MessageService)this.destination.getService()).sendSubscribeFromPeer(this.destination.getId(), subscribe, selector, subtopic);
    }

    static class TopicSubscription {
        Map<Object, MessageClient> defaultSubscriptions;
        Map<String, Map<Object, MessageClient>> selectorSubscriptions;

        TopicSubscription() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("default subscriptions: ").append(this.defaultSubscriptions).append(StringUtils.NEWLINE);
            sb.append("selector subscriptions: ").append(this.selectorSubscriptions).append(StringUtils.NEWLINE);
            return sb.toString();
        }
    }
}

