/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.internal;

import com.vmware.vise.util.PropertyUtil;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "sso-token-management.properties";
    public static final long MIN_NANO_TIME_BETWEEN_LOCAL_DOMAIN_DETERMINATION_ATTEMPTS;
    public static final long SSO_DOMAIN_DEPENDENCIES_TIMEOUT_SECONDS;

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties((ClassLoader)classLoader, (String)CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        MIN_NANO_TIME_BETWEEN_LOCAL_DOMAIN_DETERMINATION_ATTEMPTS = TimeUnit.SECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"sso.tokenManagement.minTimeBetweenLocalSsoDomainDeterminations", (long)60L));
        SSO_DOMAIN_DEPENDENCIES_TIMEOUT_SECONDS = PropertyUtil.getLongProperty((Properties)properties, (String)"sso.tokenManagement.SsoDomainDependenciesTimeout", (long)120L);
    }
}

