/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt;

import com.vmware.af.VmAfClient;
import com.vmware.sso.internal.Config;
import com.vmware.sso.internal.SsoTokenManagementBundleActivator;
import com.vmware.sso.tokenmgmt.SsoDomainFinder;
import com.vmware.vise.util.Optional;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SsoDomain {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    static final String PROP_NAME__LOCAL_DOMAIN_ID = "sso.localDomainId";
    static final String PROP_NAME__LOCAL_DOMAIN_NAME = "sso.localDomainName";
    static final String PROP_NAME__LOCAL_DOMAIN_TYPE = "sso.localDomainType";
    static final String UNKNOWN_DOMAIN_NAME = "<unknown_domain_name>";
    static final String UNKNOWN_LOCAL_DOMAIN_ID = "<LDID>";
    static final String UNKNOWN_LOCAL_DOMAIN_NAME = "<unknown-local-domain-name>";
    private static final CountDownLatch _setDependenciesHasBeenInvoked = new CountDownLatch(1);
    private static volatile ServiceRegistry _serviceRegistry;
    private static volatile ConfigurationServiceData _configServiceData;
    private static volatile SsoDomainAndSourceAndNanoTime _localDomainCombo;
    private static final Lock _localDomainLock;
    @Nonnull
    private final String _id;
    @Nullable
    private final String _name;
    @Nullable
    private final String _type;
    private final boolean _isLocal;
    private volatile String _cachedToString;

    private static SsoDomainDataAndSource determineLocalDomainData() throws InterruptedException {
        SsoDomainDataAndSource ssoDomainDataAndSource;
        SsoDomainFinder.SsoDomainData ssoDomainData;
        ConfigurationServiceData configurationServiceData = _configServiceData;
        ServiceRegistry serviceRegistry = _serviceRegistry;
        if (configurationServiceData == null && serviceRegistry == null) {
            throw SsoDomain.buildErrorIfSetDependenciesIsNotInvoked();
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        SsoDomainDataSource ssoDomainDataSource = null;
        if (serviceRegistry != null && (ssoDomainData = SsoDomain.findLocalSsoDomain(_serviceRegistry)) != null) {
            string = ssoDomainData.getId();
            string2 = ssoDomainData.getName();
            string3 = ssoDomainData.getType();
            ssoDomainDataSource = SsoDomainDataSource.FINDER;
            _logger.info((Object)"Determined the local SSO domain through finder");
        }
        if (string == null) {
            boolean bl = true;
            if (configurationServiceData != null) {
                string = configurationServiceData.localDomainId;
                string2 = configurationServiceData.localDomainName != null ? configurationServiceData.localDomainName : UNKNOWN_LOCAL_DOMAIN_NAME;
                string3 = configurationServiceData.localDomainType;
                if (string != null) {
                    ssoDomainDataSource = SsoDomainDataSource.CONFIG;
                    _logger.info((Object)"Determined the local SSO domain through config service");
                } else {
                    bl = configurationServiceData.isAfdEnabled;
                }
            }
            if (string == null) {
                if (bl) {
                    try {
                        ssoDomainDataAndSource = new VmAfClient("localhost");
                        string = ssoDomainDataAndSource.getDomainID();
                        string2 = ssoDomainDataAndSource.getDomainName();
                        ssoDomainDataSource = SsoDomainDataSource.VMAFD;
                        _logger.info((Object)"Determined the local SSO domain through VMAFD. Note that the domain type is unavailable through VMAFD.");
                    }
                    catch (Throwable throwable) {
                        _logger.error((Object)"VMAFD error", throwable);
                        string = null;
                    }
                }
                if (string == null) {
                    string = UNKNOWN_LOCAL_DOMAIN_ID;
                    ssoDomainDataSource = SsoDomainDataSource.DEFAULT;
                    _logger.info((Object)"Fell back to unknown local SSO domain");
                }
            }
        }
        ssoDomainData = new SsoDomainFinder.SsoDomainData(string, string2, string3);
        ssoDomainDataAndSource = new SsoDomainDataAndSource(ssoDomainData, ssoDomainDataSource);
        return ssoDomainDataAndSource;
    }

    private static ExceptionInInitializerError buildErrorIfSetDependenciesIsNotInvoked() {
        return new ExceptionInInitializerError("Before accessing the local SSO domain, please, invoke method " + SsoDomain.class.getSimpleName() + ".setDependencies(...).  @" + Integer.toHexString(System.identityHashCode(SsoDomain.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private static SsoDomainFinder.SsoDomainData findLocalSsoDomain(@Nullable ServiceRegistry serviceRegistry) throws InterruptedException {
        if (serviceRegistry == null) {
            return null;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        SsoDomainFinderListener ssoDomainFinderListener = new SsoDomainFinderListener(atomicReference, countDownLatch);
        try {
            SsoDomainFinder.SsoDomainData ssoDomainData;
            serviceRegistry.registerServiceListener(SsoDomainFinder.class.getName(), (ServiceListener)ssoDomainFinderListener);
            if (SsoTokenManagementBundleActivator.runningInOsgiEnvironment) {
                countDownLatch.await(10L, TimeUnit.MINUTES);
            } else {
                countDownLatch.await(5L, TimeUnit.SECONDS);
            }
            SsoDomainFinder.SsoDomainData ssoDomainData2 = ssoDomainData = (SsoDomainFinder.SsoDomainData)atomicReference.get();
            return ssoDomainData2;
        }
        finally {
            serviceRegistry.unregisterServiceListener(SsoDomainFinder.class.getName(), (ServiceListener)ssoDomainFinderListener);
        }
    }

    public static SsoDomain getLocal() {
        if (HolderOfLocalSsoDomain.LOCAL_DOMAIN_DATA_SOURCE == SsoDomainDataSource.FINDER) {
            return HolderOfLocalSsoDomain.LOCAL_DOMAIN;
        }
        SsoDomainAndSourceAndNanoTime ssoDomainAndSourceAndNanoTime = _localDomainCombo;
        SsoDomain ssoDomain = SsoDomain.getValidLocalDomain(ssoDomainAndSourceAndNanoTime);
        if (ssoDomain != null) {
            return ssoDomain;
        }
        _localDomainLock.lock();
        try {
            ssoDomain = SsoDomain.getValidLocalDomain(ssoDomainAndSourceAndNanoTime);
            if (ssoDomain != null) {
                SsoDomain ssoDomain2 = ssoDomain;
                return ssoDomain2;
            }
            SsoDomainDataAndSource ssoDomainDataAndSource = SsoDomain.determineLocalDomainData();
            long l = System.nanoTime();
            SsoDomainFinder.SsoDomainData ssoDomainData = ssoDomainDataAndSource.getSsoDomainData();
            ssoDomain = new SsoDomain(ssoDomainData.getId(), ssoDomainData.getName(), ssoDomainData.getType(), true);
            SsoDomainDataSource ssoDomainDataSource = ssoDomainDataAndSource.getSource();
            _localDomainCombo = ssoDomainAndSourceAndNanoTime = new SsoDomainAndSourceAndNanoTime(ssoDomain, ssoDomainDataSource, l);
            if (ssoDomainDataSource == SsoDomainDataSource.FINDER) {
                _configServiceData = null;
                _serviceRegistry = null;
            }
            SsoDomain ssoDomain3 = ssoDomain;
            return ssoDomain3;
        }
        finally {
            _localDomainLock.unlock();
        }
    }

    private static SsoDomain getValidLocalDomain(SsoDomainAndSourceAndNanoTime ssoDomainAndSourceAndNanoTime) {
        if (ssoDomainAndSourceAndNanoTime != null && (ssoDomainAndSourceAndNanoTime.getSource() == SsoDomainDataSource.FINDER || Config.MIN_NANO_TIME_BETWEEN_LOCAL_DOMAIN_DETERMINATION_ATTEMPTS > 0L && System.nanoTime() - ssoDomainAndSourceAndNanoTime.getNanoTime() < Config.MIN_NANO_TIME_BETWEEN_LOCAL_DOMAIN_DETERMINATION_ATTEMPTS)) {
            return ssoDomainAndSourceAndNanoTime.getSsoDomain();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDependencies(@Nonnull ConfigurationService configurationService, @Nullable ServiceRegistry serviceRegistry) {
        try {
            _logger.info((Object)("SsoDomain.setDependencies(): " + configurationService + ",  " + serviceRegistry + ",   @" + Integer.toHexString(System.identityHashCode(SsoDomain.class))));
            Validate.isTrue((configurationService != null || serviceRegistry != null ? 1 : 0) != 0);
            _serviceRegistry = serviceRegistry;
            if (configurationService != null) {
                ConfigurationServiceData configurationServiceData;
                String string;
                String string2;
                boolean bl = PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)"afd.disabled", (boolean)false);
                String string3 = configurationService.getProperty(PROP_NAME__LOCAL_DOMAIN_ID);
                if (StringUtil.isNullOrWhitespace((String)string3)) {
                    string3 = null;
                }
                if (StringUtil.isNullOrWhitespace((String)(string2 = configurationService.getProperty(PROP_NAME__LOCAL_DOMAIN_NAME)))) {
                    string2 = null;
                }
                if (StringUtil.isNullOrWhitespace((String)(string = configurationService.getProperty(PROP_NAME__LOCAL_DOMAIN_TYPE)))) {
                    string = null;
                }
                _configServiceData = configurationServiceData = new ConfigurationServiceData(!bl, string3, string2, string);
                _logger.info((Object)configurationServiceData);
            }
        }
        finally {
            _setDependenciesHasBeenInvoked.countDown();
        }
    }

    private SsoDomain(@Nonnull String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        Validate.notEmpty((String)string);
        this._id = string;
        this._name = string2;
        this._type = string3;
        this._isLocal = bl;
    }

    public static SsoDomain valueOf(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        Validate.notNull((Object)string);
        SsoDomain ssoDomain = SsoDomain.getLocal();
        if (ssoDomain.getId().equals(string)) {
            return ssoDomain;
        }
        return new SsoDomain(string, string2, string3, false);
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public static boolean isLocalDomainId(String string) {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        return ssoDomain.getId().equals(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SsoDomain) {
            SsoDomain ssoDomain = (SsoDomain)object;
            return this._id.equals(ssoDomain._id);
        }
        return false;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String toString() {
        String string = this._cachedToString;
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this._name != null) {
                stringBuilder.append(this._name).append('(');
            }
            stringBuilder.append(this._id);
            if (this._isLocal) {
                stringBuilder.append("@L");
            }
            if (!StringUtil.isNullOrEmpty((String)this._type)) {
                stringBuilder.append("~").append(this._type);
            }
            if (this._name != null) {
                stringBuilder.append(')');
            }
            this._cachedToString = string = stringBuilder.toString();
        }
        return string;
    }

    static {
        _localDomainLock = new ReentrantLock();
    }

    private static class SsoDomainAndSourceAndNanoTime {
        private final SsoDomain _ssoDomain;
        private final SsoDomainDataSource _source;
        private final long _nanoTime;

        public SsoDomainAndSourceAndNanoTime(SsoDomain ssoDomain, SsoDomainDataSource ssoDomainDataSource, long l) {
            Validate.notNull((Object)ssoDomain);
            Validate.notNull((Object)((Object)ssoDomainDataSource));
            Validate.isTrue((l > 0L ? 1 : 0) != 0);
            this._ssoDomain = ssoDomain;
            this._source = ssoDomainDataSource;
            this._nanoTime = l;
        }

        public SsoDomain getSsoDomain() {
            return this._ssoDomain;
        }

        public long getNanoTime() {
            return this._nanoTime;
        }

        public SsoDomainDataSource getSource() {
            return this._source;
        }
    }

    private static class SsoDomainDataAndSource {
        private final SsoDomainFinder.SsoDomainData _ssoDomainData;
        private final SsoDomainDataSource _source;

        public SsoDomainDataAndSource(SsoDomainFinder.SsoDomainData ssoDomainData, SsoDomainDataSource ssoDomainDataSource) {
            this._ssoDomainData = ssoDomainData;
            this._source = ssoDomainDataSource;
        }

        public SsoDomainFinder.SsoDomainData getSsoDomainData() {
            return this._ssoDomainData;
        }

        public SsoDomainDataSource getSource() {
            return this._source;
        }
    }

    private static enum SsoDomainDataSource {
        FINDER,
        VMAFD,
        CONFIG,
        DEFAULT;

    }

    static class ConfigurationServiceData {
        final boolean isAfdEnabled;
        final String localDomainId;
        final String localDomainName;
        final String localDomainType;

        ConfigurationServiceData(boolean bl, @Nullable String string, @Nullable String string2, @Nullable String string3) {
            this.isAfdEnabled = bl;
            this.localDomainId = string;
            this.localDomainName = string2;
            this.localDomainType = string3;
        }

        public String toString() {
            return this.getClass().getCanonicalName() + ": isAfdEnabled: " + this.isAfdEnabled + ", localDomainId: " + this.localDomainId + ", localDomainName: " + this.localDomainName + ", localDomainType: " + this.localDomainType;
        }
    }

    static class SsoDomainFinderListener
    implements ServiceListener {
        private final AtomicReference<SsoDomainFinder.SsoDomainData> _ssoDomainDataRef;
        private final CountDownLatch _latch;

        SsoDomainFinderListener(AtomicReference<SsoDomainFinder.SsoDomainData> atomicReference, CountDownLatch countDownLatch) {
            this._ssoDomainDataRef = atomicReference;
            this._latch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(Object object) {
            if (this._latch.getCount() == 0L) {
                return;
            }
            try {
                SsoDomainFinder ssoDomainFinder = (SsoDomainFinder)object;
                Optional<SsoDomainFinder.SsoDomainData> optional = ssoDomainFinder.findLocalDomain();
                this._ssoDomainDataRef.set((SsoDomainFinder.SsoDomainData)optional.orElse(null));
            }
            catch (Exception exception) {
                _logger.error((Object)"SsoDomainFinder listener failure", (Throwable)exception);
                this._ssoDomainDataRef.set(null);
            }
            finally {
                this._latch.countDown();
            }
        }

        public void serviceRemoved(Object object) {
        }
    }

    static class HolderOfLocalSsoDomain {
        static final SsoDomain LOCAL_DOMAIN;
        static final SsoDomainDataSource LOCAL_DOMAIN_DATA_SOURCE;

        HolderOfLocalSsoDomain() {
        }

        static {
            SsoDomainDataAndSource ssoDomainDataAndSource;
            if (SsoTokenManagementBundleActivator.runningInOsgiEnvironment) {
                try {
                    boolean bl;
                    long l = Config.SSO_DOMAIN_DEPENDENCIES_TIMEOUT_SECONDS;
                    if (l < 0L) {
                        l = 0L;
                    }
                    if (!(bl = _setDependenciesHasBeenInvoked.await(l, TimeUnit.SECONDS))) {
                        throw SsoDomain.buildErrorIfSetDependenciesIsNotInvoked();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ExceptionInInitializerError(interruptedException);
                }
            }
            try {
                ssoDomainDataAndSource = SsoDomain.determineLocalDomainData();
            }
            catch (InterruptedException interruptedException) {
                throw new ExceptionInInitializerError(interruptedException);
            }
            SsoDomainFinder.SsoDomainData ssoDomainData = ssoDomainDataAndSource.getSsoDomainData();
            LOCAL_DOMAIN = new SsoDomain(ssoDomainData.getId(), ssoDomainData.getName(), ssoDomainData.getType(), true);
            LOCAL_DOMAIN_DATA_SOURCE = ssoDomainDataAndSource.getSource();
            _logger.info((Object)("Local SSO domain: " + LOCAL_DOMAIN));
            if (LOCAL_DOMAIN_DATA_SOURCE == SsoDomainDataSource.FINDER) {
                _configServiceData = null;
                _serviceRegistry = null;
            }
        }
    }
}

