/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.vise.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public class TokenAcquisitionResult {
    @Nonnull
    private final SsoDomain _ssoDomain;
    private final TokenEx _tokenEx;
    private final Throwable _error;

    public TokenAcquisitionResult(@Nonnull SsoDomain ssoDomain, @Nullable TokenEx tokenEx, @Nullable Throwable throwable) {
        Validate.notNull((Object)ssoDomain);
        if (tokenEx == null && throwable == null) {
            throw new IllegalArgumentException("Both tokenEx and error are null");
        }
        this._ssoDomain = ssoDomain;
        this._tokenEx = tokenEx;
        this._error = throwable;
    }

    public SsoDomain getSsoDomain() {
        return this._ssoDomain;
    }

    public Optional<TokenEx> getTokenEx() {
        return Optional.ofNullable((Object)this._tokenEx);
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable((Object)this._error);
    }

    public String toString() {
        return "domain=" + this._ssoDomain + ", tokenEx=" + this._tokenEx + ", error=" + this._error;
    }
}

